/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AutoValue_CloudDatastoreRemoteServiceConfig;
import com.google.appengine.api.datastore.AutoValue_CloudDatastoreRemoteServiceConfig_AppId;
import com.google.appengine.api.datastore.DatastoreServiceGlobalConfig;
import com.google.appengine.api.datastore.LocationMapper;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.auto.value.AutoValue;
import java.security.PrivateKey;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
public abstract class CloudDatastoreRemoteServiceConfig {
    public static void setConfig(CloudDatastoreRemoteServiceConfig config) {
        DatastoreServiceGlobalConfig.setConfig(config.toInternalConfig());
    }

    public static void clear() {
        DatastoreServiceGlobalConfig.clear();
    }

    private DatastoreServiceGlobalConfig toInternalConfig() {
        return DatastoreServiceGlobalConfig.builder().appId(Objects.requireNonNull(this.appId()).appIdString()).emulatorHost(this.emulatorHost()).hostOverride(this.hostOverride()).additionalAppIds(this.additionalAppIdsAsStrings()).serviceAccount(this.serviceAccount()).accessToken(this.accessToken()).privateKey(this.privateKey()).useComputeEngineCredential(this.useComputeEngineCredential()).installApiProxyEnvironment(this.installApiProxyEnvironment()).maxRetries(this.maxRetries()).httpConnectTimeoutMillis(this.httpConnectTimeoutMillis()).asyncStackTraceCaptureEnabled(this.asyncStackTraceCaptureEnabled()).build();
    }

    abstract @Nullable AppId appId();

    abstract @Nullable String emulatorHost();

    abstract @Nullable String hostOverride();

    abstract @Nullable ImmutableSet<AppId> additionalAppIds();

    abstract boolean installApiProxyEnvironment();

    abstract @Nullable String serviceAccount();

    abstract @Nullable PrivateKey privateKey();

    abstract @Nullable String accessToken();

    abstract boolean useComputeEngineCredential();

    abstract int maxRetries();

    abstract int httpConnectTimeoutMillis();

    abstract boolean asyncStackTraceCaptureEnabled();

    @Nullable ImmutableSet<String> additionalAppIdsAsStrings() {
        if (this.additionalAppIds() == null) {
            return null;
        }
        ImmutableSet.Builder appIds = ImmutableSet.builder();
        for (AppId appId : this.additionalAppIds()) {
            appIds.add(appId.toString());
        }
        return appIds.build();
    }

    public static Builder builder() {
        return new AutoValue_CloudDatastoreRemoteServiceConfig.Builder().installApiProxyEnvironment(true).useComputeEngineCredential(false).maxRetries(3).httpConnectTimeoutMillis(20000).asyncStackTraceCaptureEnabled(true);
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder appId(AppId var1);

        public abstract Builder emulatorHost(String var1);

        public abstract Builder hostOverride(String var1);

        public abstract Builder additionalAppIds(Set<AppId> var1);

        public abstract Builder installApiProxyEnvironment(boolean var1);

        public abstract Builder useComputeEngineCredential(boolean var1);

        public abstract Builder maxRetries(int var1);

        public abstract Builder httpConnectTimeoutMillis(int var1);

        public abstract Builder asyncStackTraceCaptureEnabled(boolean var1);

        public abstract Builder accessToken(String var1);

        public Builder useServiceAccountCredential(String serviceAccountId, PrivateKey privateKey) {
            return this.serviceAccount(serviceAccountId).privateKey(privateKey);
        }

        abstract Builder serviceAccount(String var1);

        abstract Builder privateKey(PrivateKey var1);

        abstract CloudDatastoreRemoteServiceConfig autoBuild();

        public CloudDatastoreRemoteServiceConfig build() {
            CloudDatastoreRemoteServiceConfig config = this.autoBuild();
            config.toInternalConfig();
            return config;
        }
    }

    @AutoValue
    public static abstract class AppId {
        abstract Location location();

        abstract String projectId();

        public static AppId create(Location location, String projectId) {
            return new AutoValue_CloudDatastoreRemoteServiceConfig_AppId(location, projectId);
        }

        String appIdString() {
            return String.format("%s~%s", LocationMapper.getPartitionId(this.location()), this.projectId());
        }

        public static enum Location {
            US_CENTRAL,
            EUROPE_WEST,
            US_EAST1,
            ASIA_NORTHEAST1,
            US_EAST4,
            AUSTRALIA_SOUTHEAST1,
            EUROPE_WEST1,
            EUROPE_WEST3;


            public static Location fromString(String locationString) {
                return Location.valueOf(locationString.toUpperCase().replaceAll("-", "_"));
            }
        }
    }
}

