/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.taskqueue;

import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class LeaseOptions {
    private Long lease;
    private TimeUnit unit;
    private Long countLimit;
    private Double deadlineInSeconds;
    private boolean groupByTag;
    private byte[] tag;

    private LeaseOptions() {
        this.lease = null;
        this.unit = null;
        this.countLimit = null;
        this.deadlineInSeconds = null;
        this.groupByTag = false;
        this.tag = null;
    }

    public LeaseOptions(LeaseOptions options) {
        this.lease = options.lease;
        this.unit = options.unit;
        this.countLimit = options.countLimit;
        this.deadlineInSeconds = options.deadlineInSeconds;
        this.groupByTag = options.groupByTag;
        this.tag = options.tag;
    }

    Long getLease() {
        return this.lease;
    }

    TimeUnit getUnit() {
        return this.unit;
    }

    Long getCountLimit() {
        return this.countLimit;
    }

    Double getDeadlineInSeconds() {
        return this.deadlineInSeconds;
    }

    boolean getGroupByTag() {
        return this.groupByTag;
    }

    byte[] getTag() {
        return this.tag;
    }

    public LeaseOptions leasePeriod(long lease, TimeUnit unit) {
        if (unit == null) {
            throw new IllegalArgumentException("Unit for lease period must not be null");
        }
        if (lease <= 0L) {
            throw new IllegalArgumentException("Lease period must be greater than 0, got " + lease + " " + (Object)((Object)unit));
        }
        this.lease = lease;
        this.unit = unit;
        return this;
    }

    public LeaseOptions countLimit(long countLimit) {
        if (countLimit <= 0L) {
            throw new IllegalArgumentException("Number of tasks to lease must be greater than 0");
        }
        this.countLimit = countLimit;
        return this;
    }

    public LeaseOptions deadlineInSeconds(@Nullable Double deadlineInSeconds) {
        if (deadlineInSeconds != null && deadlineInSeconds <= 0.0) {
            throw new IllegalArgumentException("Deadline must be > 0, got " + deadlineInSeconds);
        }
        this.deadlineInSeconds = deadlineInSeconds;
        return this;
    }

    public LeaseOptions groupByTag() {
        this.groupByTag = true;
        return this;
    }

    public LeaseOptions tag(byte[] tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must not be null");
        }
        this.groupByTag = true;
        this.tag = tag;
        return this;
    }

    public LeaseOptions tag(String tag) {
        if (tag == null) {
            throw new IllegalArgumentException("Tag must not be null");
        }
        this.groupByTag = true;
        this.tag = tag.getBytes();
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.lease == null ? 0 : this.lease.hashCode());
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        result = 31 * result + (this.countLimit == null ? 0 : this.countLimit.hashCode());
        result = 31 * result + (this.deadlineInSeconds == null ? 0 : this.deadlineInSeconds.hashCode());
        result = 31 * result + (this.groupByTag ? 1 : 0);
        result = 31 * result + (this.tag == null ? 0 : Arrays.hashCode(this.tag));
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeaseOptions other = (LeaseOptions)obj;
        if (this.lease == null ? other.lease != null : !this.lease.equals(other.lease)) {
            return false;
        }
        if (this.unit == null ? other.unit != null : !this.unit.equals((Object)other.unit)) {
            return false;
        }
        if (this.countLimit == null ? other.countLimit != null : !this.countLimit.equals(other.countLimit)) {
            return false;
        }
        if (this.deadlineInSeconds == null ? other.deadlineInSeconds != null : !this.deadlineInSeconds.equals(other.deadlineInSeconds)) {
            return false;
        }
        if (this.groupByTag != other.groupByTag) {
            return false;
        }
        return Arrays.equals(this.tag, other.tag);
    }

    public String toString() {
        return "LeaseOptions[lease=" + this.lease + " " + (Object)((Object)this.unit) + ",countLimit=" + this.countLimit + ",deadlineInSeconds=" + this.deadlineInSeconds + ",groupByTag=" + this.groupByTag + "]";
    }

    public static final class Builder {
        public static LeaseOptions withLeasePeriod(long lease, TimeUnit unit) {
            return Builder.withDefaults().leasePeriod(lease, unit);
        }

        public static LeaseOptions withCountLimit(long countLimit) {
            return Builder.withDefaults().countLimit(countLimit);
        }

        public static LeaseOptions withDeadlineInSeconds(@Nullable Double deadlineInSeconds) {
            return Builder.withDefaults().deadlineInSeconds(deadlineInSeconds);
        }

        public static LeaseOptions withTag(byte[] tag) {
            return Builder.withDefaults().tag(tag);
        }

        public static LeaseOptions withTag(String tag) {
            return Builder.withDefaults().tag(tag);
        }

        private static LeaseOptions withDefaults() {
            return new LeaseOptions();
        }

        private Builder() {
        }
    }
}

