/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.hash.Funnel;
import com.google.appengine.repackaged.com.google.common.hash.Funnels;
import com.google.appengine.repackaged.com.google.common.hash.PrimitiveSink;
import com.google.appengine.repackaged.com.google.common.labs.collect.BiStream;
import com.google.appengine.repackaged.com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.appengine.repackaged.com.google.errorprone.annotations.ResultIgnorabilityUnspecified;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageFactories;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MessageLiteOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MutableMessage;
import com.google.appengine.repackaged.com.google.protobuf.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.protobuf.UnknownFieldSet;
import com.google.appengine.repackaged.com.google.protobuf.contrib.JavaQualifiedNames;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;

public final class MessageUtils {
    private static final String GET_DEFAULT_INSTANCE_MSG = "Message class must implement the #getDefaultInstance() static method: ";

    public static <T extends MessageLite> T getDefaultInstance(Class<T> type) {
        try {
            return (T)((MessageLite)type.cast(type.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0])));
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new IllegalArgumentException(GET_DEFAULT_INSTANCE_MSG + type, e);
        }
    }

    public static Class<? extends ProtocolMessageEnum> getProtoEnumClass(Descriptors.EnumDescriptor descriptor) throws ClassNotFoundException {
        StringBuilder javaType = new StringBuilder(descriptor.getName());
        for (Descriptors.Descriptor parent = descriptor.getContainingType(); parent != null; parent = parent.getContainingType()) {
            javaType.insert(0, "$").insert(0, parent.getName());
        }
        Descriptors.FileDescriptor fileDescriptor = descriptor.getFile();
        javaType.insert(0, MessageUtils.getJavaPrefix(fileDescriptor));
        return Class.forName(javaType.toString());
    }

    private static String getJavaPrefix(Descriptors.FileDescriptor fileDesc) {
        String javaPackage;
        StringBuilder result = new StringBuilder();
        DescriptorProtos.FileOptions options = fileDesc.getOptions();
        if (options.hasJavaPackage()) {
            javaPackage = options.getJavaPackage();
        } else {
            String protoPackage = fileDesc.getPackage();
            javaPackage = "com.google.protos" + ("".equals(protoPackage) ? "" : "." + protoPackage);
        }
        if (options.hasJavaApiVersion() && options.getJavaApiVersion() == 1) {
            javaPackage = options.hasJavaAltApiPackage() ? options.getJavaAltApiPackage() : javaPackage + ".proto2api";
        }
        result.append(javaPackage).append(".");
        if (!options.getJavaMultipleFiles()) {
            result.append(JavaQualifiedNames.getOuterClassname(fileDesc)).append("$");
        }
        return result.toString();
    }

    public static String getProtoTypeName(Class<? extends MessageLite> clazz) {
        MessageLite proto = MessageUtils.getDefaultInstance(clazz);
        if (proto instanceof GeneratedMessage) {
            return ((GeneratedMessage)proto).getDescriptorForType().getFullName();
        }
        if (proto instanceof GeneratedMutableMessage) {
            return ((GeneratedMutableMessage)proto).getDescriptorForType().getFullName();
        }
        ProtocolMessage proto1 = (ProtocolMessage)proto;
        return proto1.getProtocolType().getProtocolDescriptor().getProtoName();
    }

    public static <T extends Enum<T>> String getProto2EnumTypeName(Class<T> enumClass) {
        try {
            Method m = enumClass.getMethod("getDescriptor", new Class[0]);
            Descriptors.EnumDescriptor desc = (Descriptors.EnumDescriptor)m.invoke(null, new Object[0]);
            return desc.getFullName();
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Bad reflection stuff shouldn't have happened:");
        }
    }

    public static <T extends Enum<T>> String getProto1EnumTypeName(Class<T> enumClass) {
        String enumClassName = enumClass.getSimpleName();
        try {
            String parentTypeName = MessageUtils.getProtoTypeName(enumClass.getEnclosingClass());
            return parentTypeName + "." + enumClassName;
        }
        catch (Exception e) {
            throw new AssertionError((Object)"Bad reflection stuff shouldn't have happened:");
        }
    }

    public static Message toMessage(MessageOrBuilder messageOrBuilder) {
        return (Message)MessageUtils.toMessageLite(messageOrBuilder);
    }

    public static MessageLite toMessageLite(MessageLiteOrBuilder messageOrBuilder) {
        Preconditions.checkNotNull(messageOrBuilder);
        if (messageOrBuilder instanceof MessageLite) {
            return (MessageLite)messageOrBuilder;
        }
        if (messageOrBuilder instanceof MessageLite.Builder) {
            MessageLite.Builder builder = (MessageLite.Builder)messageOrBuilder;
            return builder.build();
        }
        throw new IllegalStateException("MessageLiteOrBuilder must be a MessageLite or a MessageLite.Builder!");
    }

    public static Message.Builder toBuilder(MessageOrBuilder messageOrBuilder) {
        return (Message.Builder)MessageUtils.toBuilderLite(messageOrBuilder);
    }

    public static MessageLite.Builder toBuilderLite(MessageLiteOrBuilder messageLiteOrBuilder) {
        Preconditions.checkNotNull(messageLiteOrBuilder);
        if (messageLiteOrBuilder instanceof MessageLite.Builder) {
            return (MessageLite.Builder)messageLiteOrBuilder;
        }
        if (messageLiteOrBuilder instanceof MessageLite) {
            MessageLite messageLite = (MessageLite)messageLiteOrBuilder;
            return messageLite.toBuilder();
        }
        throw new IllegalStateException("MessageLiteOrBuilder must be a MessageLite or a MessageLite.Builder!");
    }

    public static Object getValue(MessageOrBuilder message, Descriptors.FieldDescriptor ... fields) {
        return MessageUtils.getValue(message, Iterators.forArray(fields));
    }

    public static <T> T getValue(MessageOrBuilder message, Iterator<Descriptors.FieldDescriptor> fields) {
        try {
            Object currentValue = message;
            while (fields.hasNext()) {
                Descriptors.FieldDescriptor fieldDescriptor;
                String fieldClassName;
                Object msg = currentValue;
                String msgClassName = msg.getDescriptorForType().getFullName();
                if (!msgClassName.equals(fieldClassName = (fieldDescriptor = fields.next()).getContainingType().getFullName())) {
                    throw new IllegalStateException(String.format("Expected message class %s, but was %s", fieldClassName, msgClassName));
                }
                if (!fieldDescriptor.isRepeated()) {
                    if (!msg.hasField(fieldDescriptor) && !fields.hasNext()) {
                        if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                            return (T)MessageUtils.getDefaultInstance(MessageUtils.getMessageFieldClass(fieldDescriptor));
                        }
                        return (T)fieldDescriptor.getDefaultValue();
                    }
                } else if (msg.getRepeatedFieldCount(fieldDescriptor) == 0 && !fields.hasNext()) {
                    if (fieldDescriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                        return (T)ImmutableList.of();
                    }
                    return (T)fieldDescriptor.getDefaultValue();
                }
                currentValue = msg.getField(fieldDescriptor);
            }
            return (T)currentValue;
        }
        catch (ClassCastException cce) {
            throw new IllegalStateException("Each field in the path (except the last) must correspond to a message", cce);
        }
    }

    @ResultIgnorabilityUnspecified
    @Deprecated
    public static <B extends Message.Builder> B compress(B builder) {
        return MessageUtils.compress(builder, field -> true);
    }

    @ResultIgnorabilityUnspecified
    private static <B extends Message.Builder> B compress(B builder, Predicate<Descriptors.FieldDescriptor> mayCompress) {
        for (Descriptors.FieldDescriptor field : builder.getDescriptorForType().getFields()) {
            Message.Builder subBuilder;
            if (field.isRepeated()) {
                if (!field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) continue;
                for (int i = 0; i < builder.getRepeatedFieldCount(field); ++i) {
                    subBuilder = builder.newBuilderForField(field);
                    subBuilder.mergeFrom((Message)builder.getRepeatedField(field, i));
                    MessageUtils.compress(subBuilder, mayCompress);
                    builder.setRepeatedField(field, i, subBuilder.build());
                }
                continue;
            }
            if (field.isRequired()) {
                if (!field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) continue;
                Message.Builder subBuilder2 = builder.newBuilderForField(field);
                subBuilder2.mergeFrom((Message)builder.getField(field));
                MessageUtils.compress(subBuilder2, mayCompress);
                builder.setField(field, subBuilder2.build());
                continue;
            }
            if (!builder.hasField(field)) continue;
            if (field.getJavaType().equals((Object)Descriptors.FieldDescriptor.JavaType.MESSAGE)) {
                Message.Builder emptyBuilder = builder.newBuilderForField(field);
                subBuilder = emptyBuilder.clone();
                subBuilder.mergeFrom((Message)builder.getField(field));
                Message subMessage = MessageUtils.compress(subBuilder, mayCompress).build();
                if (subMessage.equals(emptyBuilder.buildPartial()) && mayCompress.test(field)) {
                    builder.clearField(field);
                    continue;
                }
                builder.setField(field, subMessage);
                continue;
            }
            Object currentValue = builder.getField(field);
            if (!Objects.equals(currentValue, field.getDefaultValue()) || !mayCompress.test(field)) continue;
            builder.clearField(field);
        }
        return builder;
    }

    @ResultIgnorabilityUnspecified
    public static <B extends Message.Builder> B compressSafely(B builder) {
        return MessageUtils.compress(builder, f -> f.getContainingOneof() == null);
    }

    @ResultIgnorabilityUnspecified
    public static <T extends Message.Builder> T setAllOptionalFields(T builder) {
        return MessageMutator.withBuilder(builder).setFieldsRecursively(TraversalNode.startingFrom(builder.getDescriptorForType(), f -> !f.isRequired()));
    }

    @ResultIgnorabilityUnspecified
    public static <T extends Message.Builder> T setAllRequiredFields(T builder) {
        return MessageMutator.withBuilder(builder).setFieldsRecursively(TraversalNode.startingFrom(builder.getDescriptorForType(), Descriptors.FieldDescriptor::isRequired));
    }

    @ResultIgnorabilityUnspecified
    public static <T extends Message.Builder> T setAllFields(T builder) {
        return MessageMutator.withBuilder(builder).setFieldsRecursively(TraversalNode.startingFrom(builder.getDescriptorForType()));
    }

    public static <T extends MutableMessage> T setAllOptionalFields(T message) {
        return MessageMutator.mutable(message).setFieldsRecursively(TraversalNode.startingFrom(message.getDescriptorForType(), f -> !f.isRequired()));
    }

    @ResultIgnorabilityUnspecified
    public static <T extends MutableMessage> T setAllRequiredFields(T message) {
        return MessageMutator.mutable(message).setFieldsRecursively(TraversalNode.startingFrom(message.getDescriptorForType(), Descriptors.FieldDescriptor::isRequired));
    }

    public static <T extends MutableMessage> T setAllFields(T message) {
        return MessageMutator.mutable(message).setFieldsRecursively(TraversalNode.startingFrom(message.getDescriptorForType()));
    }

    @ResultIgnorabilityUnspecified
    public static boolean clearOptionalFields(Message.Builder builder) {
        boolean messageEmpty = true;
        Map<Descriptors.FieldDescriptor, Object> fields = builder.getAllFields();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> entry : fields.entrySet()) {
            boolean clearField = false;
            Descriptors.FieldDescriptor field = entry.getKey();
            Object value = entry.getValue();
            switch (field.getJavaType()) {
                case INT: 
                case LONG: 
                case FLOAT: 
                case DOUBLE: 
                case BOOLEAN: 
                case STRING: 
                case ENUM: 
                case BYTE_STRING: {
                    if (!field.isOptional() || !value.equals(field.getDefaultValue())) break;
                    clearField = true;
                    break;
                }
                case MESSAGE: {
                    Message.Builder subBuilder;
                    if (field.isRepeated()) {
                        int size = builder.getRepeatedFieldCount(field);
                        for (int i = 0; i < size; ++i) {
                            Message.Builder subBuilder2 = ((Message)builder.getRepeatedField(field, i)).toBuilder();
                            MessageUtils.clearOptionalFields(subBuilder2);
                            builder.setRepeatedField(field, i, subBuilder2.build());
                        }
                        break;
                    }
                    try {
                        subBuilder = builder.getFieldBuilder(field);
                    }
                    catch (UnsupportedOperationException e) {
                        subBuilder = builder.newBuilderForField(field).mergeFrom((Message)value);
                    }
                    clearField = MessageUtils.clearOptionalFields(subBuilder);
                }
            }
            if (clearField) {
                builder.clearField(field);
                continue;
            }
            messageEmpty = false;
        }
        return messageEmpty;
    }

    public static boolean containsUnknownFields(MessageOrBuilder message) {
        return !message.getUnknownFields().equals(UnknownFieldSet.getDefaultInstance()) || message.getDescriptorForType().getFields().stream().anyMatch(field -> MessageUtils.fieldContainsUnknown(message, field));
    }

    private static boolean fieldContainsUnknown(MessageOrBuilder message, Descriptors.FieldDescriptor field) {
        if (field.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            return false;
        }
        return field.isRepeated() ? ((List)message.getField(field)).stream().anyMatch(MessageUtils::containsUnknownFields) : message.hasField(field) && MessageUtils.containsUnknownFields((Message)message.getField(field));
    }

    public static <T extends Enum<T>> T getEnumValue(Descriptors.EnumValueDescriptor valueDescriptor, Class<T> enumType) {
        try {
            Method valueOf = enumType.getMethod("valueOf", Descriptors.EnumValueDescriptor.class);
            return (T)((Enum)enumType.cast(valueOf.invoke(null, valueDescriptor)));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new AssertionError(String.format("ProtocolEnum class %s must implement valueOf(int) static method.", enumType), e);
        }
    }

    public static Method getGetterMethod(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Preconditions.checkArgument(!descriptor.isExtension(), "extensions do not have getter methods. %s", (Object)descriptor);
        Class<? extends Message> owner = MessageUtils.getFieldContainerClass(descriptor);
        String fieldName = JavaQualifiedNames.getFieldName(descriptor, true);
        String fieldSuffix = "";
        if (descriptor.isMapField()) {
            fieldSuffix = "Map";
        } else if (descriptor.isRepeated()) {
            fieldSuffix = "List";
        }
        try {
            String methodName = String.format("get%s%s", fieldName, fieldSuffix);
            return owner.getMethod(methodName, new Class[0]);
        }
        catch (NoSuchMethodException noGet) {
            if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.BOOLEAN) {
                try {
                    return owner.getMethod("is" + fieldName, new Class[0]);
                }
                catch (NoSuchMethodException noIs) {
                    throw new IllegalStateException("Could not find getter method for " + descriptor, noGet);
                }
            }
            throw new IllegalStateException("Could not find getter method for " + descriptor, noGet);
        }
    }

    public static Method getHasserMethod(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Preconditions.checkArgument(!descriptor.isExtension(), "extensions do not have hasser methods. %s", (Object)descriptor);
        Preconditions.checkArgument(!descriptor.isRepeated(), "repeated fields do not have hasser methods. %s", (Object)descriptor);
        if (descriptor.getFile().getSyntax() == Descriptors.FileDescriptor.Syntax.PROTO3) {
            Preconditions.checkArgument(descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "proto3 primitive fields do not have hasser methods. %s", (Object)descriptor);
        }
        Class<? extends Message> owner = MessageUtils.getFieldContainerClass(descriptor);
        try {
            return owner.getMethod("has" + JavaQualifiedNames.getFieldName(descriptor, true), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find hasser method for " + descriptor, e);
        }
    }

    public static Method getOneOfCaseMethod(Descriptors.OneofDescriptor descriptor) throws SecurityException {
        Class<?> owner = MessageFactories.getImmutableMessageFactory().getPrototype(descriptor.getContainingType()).getClass();
        try {
            return owner.getMethod("get" + JavaQualifiedNames.underscoresToCamelCase(descriptor.getName(), true) + "Case", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Could not find case method for " + descriptor, e);
        }
    }

    public static Field getExtensionField(Descriptors.FieldDescriptor descriptor) throws SecurityException {
        Preconditions.checkArgument(descriptor.isExtension(), "%s is not an extension", (Object)descriptor);
        String extensionFieldName = JavaQualifiedNames.getFieldName(descriptor, false);
        if (descriptor.getExtensionScope() != null) {
            Class<?> owner = MessageFactories.getImmutableMessageFactory().getPrototype(descriptor.getExtensionScope()).getClass();
            try {
                return owner.getField(extensionFieldName);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalStateException("Could not find extension field for " + descriptor, e);
            }
        }
        String containingClass = JavaQualifiedNames.getPackage(descriptor.getFile()) + "." + JavaQualifiedNames.getOuterClassname(descriptor.getFile());
        try {
            return Class.forName(containingClass).getField(extensionFieldName);
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
            throw new IllegalStateException("Could not find extension field for " + descriptor, e);
        }
    }

    public static Funnel<MessageLite> protoFunnel() {
        return ProtoFunnel.INSTANCE;
    }

    public static boolean isEmpty(MessageOrBuilder messageOrBuilder) {
        Descriptors.Descriptor descriptor = messageOrBuilder.getDescriptorForType();
        List<Descriptors.FieldDescriptor> fields = descriptor.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            Descriptors.FieldDescriptor field = fields.get(i);
            Descriptors.OneofDescriptor oneofDescriptor = field.getContainingOneof();
            if (oneofDescriptor != null) {
                i += oneofDescriptor.getFieldCount() - 1;
                if (!messageOrBuilder.hasOneof(oneofDescriptor)) continue;
                return false;
            }
            if (!(field.isRepeated() ? messageOrBuilder.getRepeatedFieldCount(field) > 0 : messageOrBuilder.hasField(field))) continue;
            return false;
        }
        return messageOrBuilder.getUnknownFields().asMap().isEmpty() && messageOrBuilder.getAllFields().isEmpty();
    }

    private static Class<? extends Message> getMessageFieldClass(Descriptors.FieldDescriptor descriptor) {
        Preconditions.checkArgument(descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE, "Cannot get message type for non-message field: %s", (Object)descriptor);
        Message messagePrototype = MessageFactories.getImmutableMessageFactory().getPrototype(descriptor.getMessageType());
        if (messagePrototype == null) {
            messagePrototype = MessageFactories.getMutableMessageFactory().getPrototype(descriptor.getMessageType());
        }
        return messagePrototype.getClass();
    }

    private static Class<? extends Message> getFieldContainerClass(Descriptors.FieldDescriptor descriptor) {
        Message messagePrototype = MessageFactories.getImmutableMessageFactory().getPrototype(descriptor.getContainingType());
        if (messagePrototype == null) {
            messagePrototype = MessageFactories.getMutableMessageFactory().getPrototype(descriptor.getContainingType());
        }
        return messagePrototype.getClass();
    }

    private MessageUtils() {
    }

    private static abstract class MessageMutator<T extends MessageOrBuilder> {
        private MessageMutator() {
        }

        static <B extends Message.Builder> MessageMutator<B> withBuilder(final B builder) {
            return new MessageMutator<B>(){

                @Override
                B get() {
                    return builder;
                }

                @Override
                void addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    builder.addRepeatedField(field, this.buildIfBuilder(value));
                }

                @Override
                void setField(Descriptors.FieldDescriptor field, Object value) {
                    builder.setField(field, this.buildIfBuilder(value));
                }

                @Override
                MessageMutator<?> mutableField(Descriptors.FieldDescriptor field) {
                    return 1.withBuilder(builder.newBuilderForField(field));
                }

                private Object buildIfBuilder(Object value) {
                    return value instanceof Message.Builder ? ((Message.Builder)value).buildPartial() : value;
                }
            };
        }

        static <M extends MutableMessage> MessageMutator<M> mutable(final M message) {
            return new MessageMutator<M>(){

                @Override
                M get() {
                    return message;
                }

                @Override
                void addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    message.addRepeatedField(field, value);
                }

                @Override
                void setField(Descriptors.FieldDescriptor field, Object value) {
                    message.setField(field, value);
                }

                @Override
                MessageMutator<?> mutableField(Descriptors.FieldDescriptor field) {
                    return 2.mutable(message.newMessageForField(field));
                }
            };
        }

        abstract T get();

        abstract void addRepeatedField(Descriptors.FieldDescriptor var1, Object var2);

        abstract void setField(Descriptors.FieldDescriptor var1, Object var2);

        abstract MessageMutator<?> mutableField(Descriptors.FieldDescriptor var1);

        final T setTopLevelFields(Predicate<? super Descriptors.FieldDescriptor> filter) {
            for (Descriptors.FieldDescriptor descriptor : this.get().getDescriptorForType().getFields()) {
                if (!filter.test(descriptor) || descriptor.isRepeated() || this.get().hasField(descriptor)) continue;
                if (descriptor.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                    this.setField(descriptor, this.mutableField(descriptor).get());
                    continue;
                }
                this.setField(descriptor, descriptor.getDefaultValue());
            }
            return this.get();
        }

        final T setFieldsRecursively(TraversalNode node) {
            node.getChildren().forEach(this::setFieldRecursively);
            return this.get();
        }

        private void setFieldRecursively(TraversalNode fieldNode, Descriptors.FieldDescriptor field) {
            if (field.isRepeated()) {
                if (this.get().getRepeatedFieldCount(field) > 0) {
                    return;
                }
                switch (field.getJavaType()) {
                    case MESSAGE: {
                        this.addRepeatedField(field, this.mutableField(field).setFieldsRecursively(fieldNode));
                        break;
                    }
                    default: {
                        this.addRepeatedField(field, MessageMutator.defaultValueForRepeatedField(field));
                        break;
                    }
                }
            } else {
                if (this.get().hasField(field)) {
                    return;
                }
                switch (field.getJavaType()) {
                    case MESSAGE: {
                        this.setField(field, this.mutableField(field).setFieldsRecursively(fieldNode));
                        break;
                    }
                    default: {
                        this.setField(field, field.getDefaultValue());
                    }
                }
            }
        }

        private static Object defaultValueForRepeatedField(Descriptors.FieldDescriptor field) {
            switch (field.getJavaType()) {
                case ENUM: {
                    return field.getEnumType().getValues().get(0);
                }
                case BOOLEAN: {
                    return Boolean.FALSE;
                }
                case BYTE_STRING: {
                    return ByteString.EMPTY;
                }
                case DOUBLE: {
                    return 0.0;
                }
                case FLOAT: {
                    return Float.valueOf(0.0f);
                }
                case INT: {
                    return 0;
                }
                case LONG: {
                    return 0L;
                }
                case STRING: {
                    return "";
                }
            }
            throw new IllegalArgumentException("No known default value for " + field);
        }
    }

    private static abstract class TraversalNode {
        private TraversalNode() {
        }

        static TraversalNode startingFrom(Descriptors.Descriptor root) {
            return TraversalNode.startingFrom(root, f -> true);
        }

        static TraversalNode startingFrom(final Descriptors.Descriptor root, final Predicate<? super Descriptors.FieldDescriptor> filter) {
            return new TraversalNode(){

                @Override
                boolean shouldTraverse(Descriptors.FieldDescriptor field) {
                    return filter.test(field);
                }

                @Override
                boolean hasTraversed(Descriptors.FieldDescriptor field) {
                    return false;
                }

                @Override
                Descriptors.Descriptor getDescriptor() {
                    return root;
                }

                @Override
                public String toString() {
                    return root.getFullName();
                }
            };
        }

        final BiStream<TraversalNode, Descriptors.FieldDescriptor> getChildren() {
            return (BiStream)this.getDescriptor().getFields().stream().filter(this::shouldTraverse).collect(BiStream.concatenating(f -> BiStream.of((Object)this.ofField((Descriptors.FieldDescriptor)f), (Object)f)));
        }

        abstract boolean shouldTraverse(Descriptors.FieldDescriptor var1);

        abstract boolean hasTraversed(Descriptors.FieldDescriptor var1);

        abstract Descriptors.Descriptor getDescriptor();

        public abstract String toString();

        private TraversalNode ofField(final Descriptors.FieldDescriptor field) {
            Preconditions.checkArgument(!this.hasTraversed(field), "Recursive field unsupported: %s.%s", (Object)this, (Object)field.getName());
            final TraversalNode parent = this;
            return new TraversalNode(this){

                @Override
                boolean hasTraversed(Descriptors.FieldDescriptor nestedField) {
                    return nestedField.getFullName().equals(field.getFullName()) || parent.hasTraversed(nestedField);
                }

                @Override
                boolean shouldTraverse(Descriptors.FieldDescriptor field2) {
                    return parent.shouldTraverse(field2);
                }

                @Override
                Descriptors.Descriptor getDescriptor() {
                    return field.getMessageType();
                }

                @Override
                public String toString() {
                    return parent + "." + field.getName();
                }
            };
        }
    }

    private static enum ProtoFunnel implements Funnel<MessageLite>
    {
        INSTANCE;


        @Override
        public void funnel(MessageLite message, PrimitiveSink into) {
            try {
                message.writeTo(Funnels.asOutputStream(into));
            }
            catch (IOException impossible) {
                throw new AssertionError((Object)impossible);
            }
        }
    }

    public static class ForSingularFields {
        private ForSingularFields() {
        }

        @CanIgnoreReturnValue
        public static <T extends Message.Builder> T setAllOptionalTopLevelFields(T builder) {
            return MessageMutator.withBuilder(builder).setTopLevelFields(f -> !f.isRequired());
        }

        @CanIgnoreReturnValue
        public static <T extends MutableMessage> T setAllOptionalTopLevelFields(T message) {
            return MessageMutator.mutable(message).setTopLevelFields(f -> !f.isRequired());
        }

        @CanIgnoreReturnValue
        public static <T extends Message.Builder> T setAllRequiredTopLevelFields(T builder) {
            return MessageMutator.withBuilder(builder).setTopLevelFields(Descriptors.FieldDescriptor::isRequired);
        }

        @CanIgnoreReturnValue
        public static <T extends MutableMessage> T setAllRequiredTopLevelFields(T message) {
            return MessageMutator.mutable(message).setTopLevelFields(Descriptors.FieldDescriptor::isRequired);
        }

        @CanIgnoreReturnValue
        public static <T extends Message.Builder> T setAllTopLevelFields(T builder) {
            return MessageMutator.withBuilder(builder).setTopLevelFields(f -> true);
        }

        @CanIgnoreReturnValue
        public static <T extends MutableMessage> T setAllTopLevelFields(T message) {
            return MessageMutator.mutable(message).setTopLevelFields(f -> true);
        }
    }
}

