/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.io.opencensus.trace;

import com.google.appengine.repackaged.io.opencensus.common.Scope;
import com.google.appengine.repackaged.io.opencensus.trace.ContextHandle;
import com.google.appengine.repackaged.io.opencensus.trace.Span;
import com.google.appengine.repackaged.io.opencensus.trace.Status;
import com.google.appengine.repackaged.io.opencensus.trace.unsafe.ContextHandleUtils;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;

final class CurrentSpanUtils {
    private CurrentSpanUtils() {
    }

    @Nullable
    static Span getCurrentSpan() {
        return ContextHandleUtils.getValue(ContextHandleUtils.currentContext());
    }

    static Scope withSpan(Span span, boolean endSpan) {
        return new ScopeInSpan(span, endSpan);
    }

    static Runnable withSpan(Span span, boolean endSpan, Runnable runnable) {
        return new RunnableInSpan(span, runnable, endSpan);
    }

    static <C> Callable<C> withSpan(Span span, boolean endSpan, Callable<C> callable) {
        return new CallableInSpan(span, callable, endSpan);
    }

    private static void setErrorStatus(Span span, Throwable t) {
        span.setStatus(Status.UNKNOWN.withDescription(t.getMessage() == null ? t.getClass().getSimpleName() : t.getMessage()));
    }

    private static final class CallableInSpan<V>
    implements Callable<V> {
        private final Span span;
        private final Callable<V> callable;
        private final boolean endSpan;

        private CallableInSpan(Span span, Callable<V> callable, boolean endSpan) {
            this.span = span;
            this.callable = callable;
            this.endSpan = endSpan;
        }

        @Override
        public V call() throws Exception {
            ContextHandle origContext = ContextHandleUtils.withValue(ContextHandleUtils.currentContext(), this.span).attach();
            try {
                V v = this.callable.call();
                return v;
            }
            catch (Exception e) {
                CurrentSpanUtils.setErrorStatus(this.span, e);
                throw e;
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException("unexpected", t);
            }
            finally {
                ContextHandleUtils.currentContext().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class RunnableInSpan
    implements Runnable {
        private final Span span;
        private final Runnable runnable;
        private final boolean endSpan;

        private RunnableInSpan(Span span, Runnable runnable, boolean endSpan) {
            this.span = span;
            this.runnable = runnable;
            this.endSpan = endSpan;
        }

        @Override
        public void run() {
            ContextHandle origContext = ContextHandleUtils.withValue(ContextHandleUtils.currentContext(), this.span).attach();
            try {
                this.runnable.run();
            }
            catch (Throwable t) {
                CurrentSpanUtils.setErrorStatus(this.span, t);
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new RuntimeException("unexpected", t);
            }
            finally {
                ContextHandleUtils.currentContext().detach(origContext);
                if (this.endSpan) {
                    this.span.end();
                }
            }
        }
    }

    private static final class ScopeInSpan
    implements Scope {
        private final ContextHandle origContext;
        private final Span span;
        private final boolean endSpan;

        private ScopeInSpan(Span span, boolean endSpan) {
            this.span = span;
            this.endSpan = endSpan;
            this.origContext = ContextHandleUtils.withValue(ContextHandleUtils.currentContext(), span).attach();
        }

        @Override
        public void close() {
            ContextHandleUtils.currentContext().detach(this.origContext);
            if (this.endSpan) {
                this.span.end();
            }
        }
    }
}

