/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.setup.timer;

import com.google.appengine.setup.timer.Timer;

public abstract class AbstractIntervalTimer
implements Timer {
    protected boolean running = false;
    protected long startTime = 0L;
    protected long cumulativeTime = 0L;

    @Override
    public synchronized void start() {
        if (this.running) {
            throw new IllegalStateException("already running");
        }
        this.startTime = this.getCurrent();
        this.running = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.running) {
            throw new IllegalStateException("not running");
        }
        this.update(this.getCurrent());
        this.running = false;
    }

    @Override
    public synchronized void update() {
        this.update(this.getCurrent());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNanoseconds() {
        double ratio = this.getRatio();
        AbstractIntervalTimer abstractIntervalTimer = this;
        synchronized (abstractIntervalTimer) {
            if (this.running) {
                return this.cumulativeTime + (long)((double)(this.getCurrent() - this.startTime) * ratio);
            }
            return this.cumulativeTime;
        }
    }

    protected double getRatio() {
        return 1.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(long currentValue) {
        AbstractIntervalTimer abstractIntervalTimer = this;
        synchronized (abstractIntervalTimer) {
            long increment = (long)((double)(currentValue - this.startTime) * this.getRatio());
            this.cumulativeTime += increment;
            this.startTime = currentValue;
        }
    }

    protected abstract long getCurrent();
}

