/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.servlet.ee10;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.Query;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;

public class SessionCleanupServlet
extends HttpServlet {
    static final String SESSION_ENTITY_TYPE = "_ah_SESSION";
    static final String EXPIRES_PROP = "_expires";
    static final int MAX_SESSION_COUNT = 100;
    private DatastoreService datastore;

    public void init() {
        this.datastore = DatastoreServiceFactory.getDatastoreService();
    }

    public void service(HttpServletRequest request, HttpServletResponse response) {
        if ("clear".equals(request.getQueryString())) {
            this.clearAll(response);
        } else {
            this.sendForm(request.getRequestURI() + "?clear", response);
        }
    }

    private void clearAll(HttpServletResponse response) {
        Query query = new Query(SESSION_ENTITY_TYPE);
        query.setKeysOnly();
        query.addFilter(EXPIRES_PROP, Query.FilterOperator.LESS_THAN, System.currentTimeMillis());
        ArrayList<Key> killList = new ArrayList<Key>();
        Iterable<Entity> entities = this.datastore.prepare(query).asIterable(FetchOptions.Builder.withLimit(100));
        for (Entity expiredSession : entities) {
            Key key = expiredSession.getKey();
            killList.add(key);
        }
        this.datastore.delete(killList);
        response.setStatus(200);
        try {
            response.getWriter().println("Cleared " + killList.size() + " expired sessions.");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendForm(String actionUrl, HttpServletResponse response) {
        Query query = new Query(SESSION_ENTITY_TYPE);
        query.setKeysOnly();
        query.addFilter(EXPIRES_PROP, Query.FilterOperator.LESS_THAN, System.currentTimeMillis());
        int count = this.datastore.prepare(query).countEntities();
        response.setContentType("text/html");
        response.setCharacterEncoding("utf-8");
        try {
            PrintWriter writer = response.getWriter();
            writer.println("<html><head><title>Session Cleanup</title></head>");
            writer.println("<body>There are currently " + count + " expired sessions.");
            writer.println("<p><form method=\"POST\" action=\"" + actionUrl + "\">");
            writer.println("<input type=\"submit\" value=\"Delete Next 100\" >");
            writer.println("</form></body></html>");
        }
        catch (IOException ex) {
            response.setStatus(500);
            try {
                response.getWriter().println(ex);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        response.setStatus(200);
    }
}

