/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore;

import com.google.appengine.api.blobstore.RangeFormatException;
import com.google.appengine.api.blobstore.UnsupportedRangeFormatException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.annotations.Nullable;

public class ByteRange {
    private final long start;
    private final @Nullable Long end;
    static final String BYTES_UNIT = "bytes";
    static final String UNIT_REGEX = "([^=\\s]+)";
    static final String VALID_RANGE_HEADER_REGEX = "([^=\\s]+)\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)";
    static final String INVALID_RANGE_HEADER_REGEX = "((?:\\s*,\\s*(?:\\d*)-(?:\\d*))*)";
    static final Pattern RANGE_HEADER_PATTERN = Pattern.compile("^\\s*([^=\\s]+)\\s*=\\s*(\\d*)\\s*-\\s*(\\d*)((?:\\s*,\\s*(?:\\d*)-(?:\\d*))*)\\s*$");
    static final String CONTENT_RANGE_UNIT_REGEX = "([^\\s]+)";
    static final String VALID_CONTENT_RANGE_HEADER_REGEX = "bytes\\s+(\\d+)-(\\d+)/(\\d+)";
    static final Pattern CONTENT_RANGE_HEADER_PATTERN = Pattern.compile("^\\s*bytes\\s+(\\d+)-(\\d+)/(\\d+)\\s*$");

    public ByteRange(long start) {
        this(start, null);
    }

    public ByteRange(long start, long end) {
        this(start, (Long)end);
        if (start < 0L) {
            throw new IllegalArgumentException("If end is provided, start must be positive.");
        }
        if (end < start) {
            throw new IllegalArgumentException("end must be >= start.");
        }
    }

    protected ByteRange(long start, @Nullable Long end) {
        this.start = start;
        this.end = end;
    }

    public boolean hasEnd() {
        return this.end != null;
    }

    public long getStart() {
        return this.start;
    }

    public long getEnd() {
        if (!this.hasEnd()) {
            throw new IllegalStateException("Byte-range does not have end.  Check hasEnd() before use");
        }
        return Objects.requireNonNull(this.end);
    }

    public String toString() {
        if (this.end != null) {
            return "bytes=" + this.start + "-" + this.end;
        }
        if (this.start < 0L) {
            return "bytes=" + this.start;
        }
        return "bytes=" + this.start + "-";
    }

    public static ByteRange parse(String byteRange) {
        Matcher matcher = RANGE_HEADER_PATTERN.matcher(byteRange);
        if (!matcher.matches()) {
            throw new RangeFormatException("Invalid range format: " + byteRange);
        }
        String unsupportedRange = Objects.requireNonNull(matcher.group(4));
        if (!"".equals(unsupportedRange)) {
            throw new UnsupportedRangeFormatException("Unsupported range format: " + byteRange);
        }
        String units = Objects.requireNonNull(matcher.group(1));
        if (!BYTES_UNIT.equals(units)) {
            throw new UnsupportedRangeFormatException("Unsupported unit: " + units);
        }
        String start = Objects.requireNonNull(matcher.group(2));
        Long startValue = "".equals(start) ? null : Long.valueOf(Long.parseLong(start));
        String end = Objects.requireNonNull(matcher.group(3));
        Long endValue = "".equals(end) ? null : Long.valueOf(Long.parseLong(end));
        if (startValue == null && endValue != null) {
            startValue = -endValue.longValue();
            endValue = null;
        }
        Objects.requireNonNull(startValue, () -> "Invalid range format: " + byteRange);
        if (endValue == null) {
            return new ByteRange(startValue);
        }
        try {
            return new ByteRange((long)startValue, (long)endValue);
        }
        catch (IllegalArgumentException ex) {
            throw new RangeFormatException("Invalid range format: " + byteRange, ex);
        }
    }

    public static ByteRange parseContentRange(String contentRange) {
        Matcher matcher = CONTENT_RANGE_HEADER_PATTERN.matcher(contentRange);
        if (!matcher.matches()) {
            throw new RangeFormatException("Invalid content-range format: " + contentRange);
        }
        String start = Objects.requireNonNull(matcher.group(1));
        String end = Objects.requireNonNull(matcher.group(2));
        return new ByteRange(Long.parseLong(start), Long.parseLong(end));
    }

    public int hashCode() {
        int hash = 17;
        hash = hash * 37 + Long.hashCode(this.start);
        if (this.end != null) {
            hash = hash * 37 + this.end.hashCode();
        }
        return hash;
    }

    public boolean equals(@Nullable Object object) {
        if (object instanceof ByteRange) {
            ByteRange key = (ByteRange)object;
            return this.start == key.getStart() && Objects.equals(this.end, key.end);
        }
        return false;
    }
}

