/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PropertyContainer;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class EmbeddedEntity
extends PropertyContainer {
    private static final long serialVersionUID = -3204136387360930156L;
    private @Nullable Key key = null;
    private final Map<String, @Nullable Object> propertyMap = new HashMap<String, Object>();

    public @Nullable Key getKey() {
        return this.key;
    }

    public void setKey(@Nullable Key key) {
        this.key = key;
    }

    @Override
    Map<String, @Nullable Object> getPropertyMap() {
        return this.propertyMap;
    }

    @Override
    public EmbeddedEntity clone() {
        EmbeddedEntity result = new EmbeddedEntity();
        result.setKey(this.key);
        result.setPropertiesFrom(this);
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<EmbeddedEntity");
        if (this.key != null) {
            builder.append(" [").append(this.key).append(']');
        }
        builder.append(":\n");
        this.appendPropertiesTo(builder);
        builder.append(">\n");
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.propertyMap);
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EmbeddedEntity)) {
            return false;
        }
        EmbeddedEntity other = (EmbeddedEntity)obj;
        if (!this.propertyMap.equals(other.propertyMap)) {
            return false;
        }
        return this.key == null ? other.key == null : this.key.equals(other.key, false);
    }
}

