/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import java.util.Objects;
import org.jspecify.annotations.Nullable;

public final class Entities {
    public static final String KIND_METADATA_KIND = "__kind__";
    public static final String PROPERTY_METADATA_KIND = "__property__";
    public static final String NAMESPACE_METADATA_KIND = "__namespace__";
    public static final long NAMESPACE_METADATA_EMPTY_ID = 1L;
    public static final String ENTITY_GROUP_METADATA_KIND = "__entity_group__";
    public static final long ENTITY_GROUP_METADATA_ID = 1L;

    public static Key createKindKey(String kind) {
        return KeyFactory.createKey(KIND_METADATA_KIND, kind);
    }

    public static Key createPropertyKey(String kind, String property) {
        return KeyFactory.createKey(Entities.createKindKey(kind), PROPERTY_METADATA_KIND, property);
    }

    public static Key createNamespaceKey(String namespace) {
        if (namespace.isEmpty()) {
            return KeyFactory.createKey(NAMESPACE_METADATA_KIND, 1L);
        }
        return KeyFactory.createKey(NAMESPACE_METADATA_KIND, namespace);
    }

    public static @Nullable String getNamespaceFromNamespaceKey(Key namespaceKey) {
        if (namespaceKey.getId() == 1L) {
            return "";
        }
        return namespaceKey.getName();
    }

    public static Key createEntityGroupKey(Key key) {
        while (key.getParent() != null) {
            key = key.getParent();
        }
        return KeyFactory.createKey(key, ENTITY_GROUP_METADATA_KIND, 1L);
    }

    public static long getVersionProperty(Entity entity) {
        Number value = (Number)Objects.requireNonNull(entity.getProperty("__version__"));
        return value.longValue();
    }
}

