/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AppIdNamespace;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.storage.onestore.v3.OnestoreEntity;
import org.jspecify.annotations.Nullable;

public class KeyFactory {
    public static Key createKey(String kind, long id) {
        return KeyFactory.createKey(null, kind, id);
    }

    public static Key createKey(@Nullable Key parent, String kind, long id) {
        return KeyFactory.createKey(parent, kind, id, null);
    }

    static Key createKey(@Nullable Key parent, String kind, long id, @Nullable AppIdNamespace appIdNamespace) {
        if (id == 0L) {
            throw new IllegalArgumentException("id cannot be zero");
        }
        return new Key(kind, parent, id, appIdNamespace);
    }

    public static Key createKey(String kind, String name) {
        return KeyFactory.createKey(null, kind, name);
    }

    public static Key createKey(@Nullable Key parent, String kind, String name) {
        return KeyFactory.createKey(parent, kind, name, null);
    }

    static Key createKey(@Nullable Key parent, String kind, String name, @Nullable AppIdNamespace appIdNamespace) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("name cannot be null or empty");
        }
        return new Key(kind, parent, name, appIdNamespace);
    }

    public static String createKeyString(String kind, long id) {
        return KeyFactory.keyToString(KeyFactory.createKey(kind, id));
    }

    public static String createKeyString(@Nullable Key parent, String kind, long id) {
        return KeyFactory.keyToString(KeyFactory.createKey(parent, kind, id));
    }

    public static String createKeyString(String kind, String name) {
        return KeyFactory.keyToString(KeyFactory.createKey(kind, name));
    }

    public static String createKeyString(@Nullable Key parent, String kind, String name) {
        return KeyFactory.keyToString(KeyFactory.createKey(parent, kind, name));
    }

    public static String keyToString(Key key) {
        if (!key.isComplete()) {
            throw new IllegalArgumentException("Key is incomplete.");
        }
        OnestoreEntity.Reference reference = KeyTranslator.convertToPb(key);
        return BaseEncoding.base64Url().omitPadding().encode(reference.toByteArray());
    }

    public static Key stringToKey(String encoded) {
        byte[] decodedBytes;
        int modulo = encoded.length() % 4;
        if (modulo != 0) {
            encoded = encoded + "====".substring(modulo);
        }
        try {
            decodedBytes = BaseEncoding.base64Url().decode(CharMatcher.whitespace().removeFrom(encoded));
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Cannot parse: " + encoded, ex);
        }
        OnestoreEntity.Reference reference = new OnestoreEntity.Reference();
        boolean parsed = reference.parseFrom(decodedBytes);
        if (!parsed) {
            throw new IllegalArgumentException("Could not parse Reference");
        }
        return KeyTranslator.createFromPb(reference);
    }

    private KeyFactory() {
    }

    public static final class Builder {
        private Key current;

        public Builder(String kind, String name) {
            this.current = KeyFactory.createKey(null, kind, name);
        }

        public Builder(String kind, long id) {
            this.current = KeyFactory.createKey(null, kind, id);
        }

        public Builder(Key key) {
            this.current = key;
        }

        public Builder addChild(String kind, String name) {
            this.current = KeyFactory.createKey(this.current, kind, name);
            return this;
        }

        public Builder addChild(String kind, long id) {
            this.current = KeyFactory.createKey(this.current, kind, id);
            return this;
        }

        public Key getKey() {
            return this.current;
        }

        public String getString() {
            return KeyFactory.keyToString(this.current);
        }
    }
}

