/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQueryResultsSource;
import com.google.appengine.api.datastore.CloudDatastoreV1Client;
import com.google.appengine.api.datastore.DatastoreCallbacks;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.WrappedQueryResultCloudDatastoreV1;
import com.google.appengine.repackaged.com.google.datastore.v1.Query;
import com.google.appengine.repackaged.com.google.datastore.v1.QueryResultBatch;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryRequest;
import com.google.appengine.repackaged.com.google.datastore.v1.RunQueryResponse;
import java.util.concurrent.Future;
import org.jspecify.annotations.Nullable;

class QueryResultsSourceCloudDatastoreV1
extends BaseQueryResultsSource<RunQueryResponse, RunQueryRequest, RunQueryResponse> {
    private final CloudDatastoreV1Client cloudDatastoreV1Client;
    private final RunQueryRequest initialRequest;
    private int remainingLimit;

    QueryResultsSourceCloudDatastoreV1(DatastoreCallbacks callbacks, FetchOptions fetchOptions, Transaction txn, Query query, RunQueryRequest request, Future<RunQueryResponse> runQueryResponse, CloudDatastoreV1Client cloudDatastoreV1Client) {
        super(callbacks, fetchOptions, txn, query, runQueryResponse);
        this.initialRequest = request;
        this.cloudDatastoreV1Client = cloudDatastoreV1Client;
        this.remainingLimit = fetchOptions.getLimit() != null ? fetchOptions.getLimit() : -1;
    }

    @Override
    RunQueryRequest buildNextCallPrototype(RunQueryResponse initialResponse) {
        return this.initialRequest;
    }

    @Override
    Future<RunQueryResponse> makeNextCall(RunQueryRequest prototype, BaseQueryResultsSource.WrappedQueryResult latestResult, @Nullable Integer fetchCount, @Nullable Integer offset) {
        RunQueryRequest.Builder runQueryRequest = prototype.toBuilder();
        Query.Builder query = runQueryRequest.getQueryBuilder();
        query.setStartCursor(latestResult.getEndCursor().toByteString());
        QueryResultBatch latestBatch = ((WrappedQueryResultCloudDatastoreV1)latestResult).getBatch();
        if (query.hasLimit()) {
            this.remainingLimit -= latestBatch.getEntityResultsCount();
            query.getLimitBuilder().setValue(Math.max(this.remainingLimit, 0));
        }
        if (offset != null) {
            query.setOffset(offset);
        } else {
            query.clearOffset();
        }
        return this.cloudDatastoreV1Client.runQuery(runQueryRequest.build());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapInitialResult(RunQueryResponse initialResponse) {
        return new WrappedQueryResultCloudDatastoreV1(initialResponse.getBatch());
    }

    @Override
    BaseQueryResultsSource.WrappedQueryResult wrapResult(RunQueryResponse res) {
        return new WrappedQueryResultCloudDatastoreV1(res.getBatch());
    }
}

