/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.log;

import com.google.appengine.api.log.InvalidRequestException;
import com.google.appengine.api.log.LogQuery;
import com.google.appengine.api.log.LogQueryResult;
import com.google.appengine.api.log.LogService;
import com.google.appengine.api.log.LogServiceException;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.UninitializedMessageException;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.Iterator;
import java.util.Objects;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jspecify.annotations.Nullable;

final class LogServiceImpl
implements LogService {
    static final String PACKAGE = "logservice";
    static final String READ_RPC_NAME = "Read";

    LogServiceImpl() {
    }

    public LogQueryResult fetch(LogQuery query) {
        try {
            return this.fetchAsync(query).get();
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof LogServiceException) {
                throw (LogServiceException)e.getCause();
            }
            if (e.getCause() instanceof InvalidRequestException) {
                throw (InvalidRequestException)e.getCause();
            }
            throw new LogServiceException(e.getMessage());
        }
        catch (InterruptedException e) {
            throw new LogServiceException(e.getMessage());
        }
    }

    Future<LogQueryResult> fetchAsync(LogQuery query) {
        Long endTimeUs;
        LogServicePb.LogReadRequest.Builder request = LogServicePb.LogReadRequest.newBuilder().setAppId(LogServiceImpl.getCurrentEnvironmentOrThrow().getAppId());
        Long startTimeUs = query.getStartTimeUsec();
        if (startTimeUs != null) {
            request.setStartTime(startTimeUs);
        }
        if ((endTimeUs = query.getEndTimeUsec()) != null) {
            request.setEndTime(endTimeUs);
        }
        int batchSize = Objects.requireNonNull(query.getBatchSize(), "Null batch size");
        request.setCount(batchSize);
        LogService.LogLevel minLogLevel = query.getMinLogLevel();
        if (minLogLevel != null) {
            request.setMinimumLogLevel(minLogLevel.ordinal());
        }
        request.setIncludeIncomplete(query.getIncludeIncomplete()).setIncludeAppLogs(query.getIncludeAppLogs());
        TreeSet<LogQuery.Version> convertedModuleInfos = Sets.newTreeSet(LogQuery.VERSION_COMPARATOR);
        if (!query.getMajorVersionIds().isEmpty()) {
            for (String versionId : query.getMajorVersionIds()) {
                convertedModuleInfos.add(new LogQuery.Version("default", versionId));
            }
        } else if (!query.getVersions().isEmpty()) {
            convertedModuleInfos.addAll(query.getVersions());
        } else {
            String versionId;
            Iterator<String> currentVersionId = LogServiceImpl.getCurrentEnvironmentOrThrow().getVersionId();
            versionId = ((String)((Object)currentVersionId)).split("\\.")[0];
            convertedModuleInfos.add(new LogQuery.Version(LogServiceImpl.getCurrentEnvironmentOrThrow().getModuleId(), versionId));
        }
        for (LogQuery.Version moduleInfo : convertedModuleInfos) {
            LogServicePb.LogModuleVersion.Builder requestModuleVersion = request.addModuleVersionBuilder();
            if (!moduleInfo.getModuleId().equals("default")) {
                requestModuleVersion.setModuleId(moduleInfo.getModuleId());
            }
            requestModuleVersion.setVersionId(moduleInfo.getVersionId());
        }
        for (String requestId : query.getRequestIds()) {
            request.addRequestId(ByteString.copyFromUtf8(requestId));
        }
        String offset = query.getOffset();
        if (offset != null) {
            request.setOffset(LogQueryResult.parseOffset(offset));
        }
        final LogQuery finalizedQuery = query;
        ApiProxy.ApiConfig apiConfig = new ApiProxy.ApiConfig();
        Future<byte[]> responseBytes = ApiProxy.makeAsyncCall(PACKAGE, READ_RPC_NAME, request.build().toByteArray(), apiConfig);
        return new FutureWrapper<byte[], LogQueryResult>(responseBytes){

            @Override
            protected LogQueryResult wrap(byte @Nullable [] responseBytes) {
                try {
                    LogServicePb.LogReadResponse response = LogServicePb.LogReadResponse.parseFrom(responseBytes, (ExtensionRegistryLite)ExtensionRegistry.getEmptyRegistry());
                    return new LogQueryResult(response, finalizedQuery);
                }
                catch (InvalidProtocolBufferException | UninitializedMessageException e) {
                    throw new LogServiceException("Could not parse LogReadResponse", e);
                }
            }

            @Override
            protected Throwable convertException(Throwable cause) {
                if (cause instanceof ApiProxy.ApplicationException) {
                    ApiProxy.ApplicationException e = (ApiProxy.ApplicationException)cause;
                    LogServicePb.LogServiceError.ErrorCode errorCode = LogServicePb.LogServiceError.ErrorCode.forNumber(e.getApplicationError());
                    if (errorCode == LogServicePb.LogServiceError.ErrorCode.INVALID_REQUEST) {
                        return new InvalidRequestException(e.getErrorDetail());
                    }
                    return new LogServiceException(e.getErrorDetail());
                }
                return cause;
            }
        };
    }

    private static ApiProxy.Environment getCurrentEnvironmentOrThrow() {
        ApiProxy.Environment environment = ApiProxy.getCurrentEnvironment();
        if (environment == null) {
            throw new IllegalStateException("Operation not allowed in a thread that is neither the original request thread nor a thread created by ThreadManager");
        }
        return environment;
    }
}

