/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.mail;

import javax.mail.internet.MimeMessage;
import org.jspecify.annotations.Nullable;

public final class BounceNotification {
    private final @Nullable MimeMessage rawMessage;
    private final @Nullable Details original;
    private final @Nullable Details notification;

    BounceNotification(@Nullable MimeMessage rawMessage, @Nullable Details original, @Nullable Details notification) {
        this.rawMessage = rawMessage;
        this.original = original;
        this.notification = notification;
    }

    public final @Nullable MimeMessage getRawMessage() {
        return this.rawMessage;
    }

    public final @Nullable Details getOriginal() {
        return this.original;
    }

    public final @Nullable Details getNotification() {
        return this.notification;
    }

    public static final class Details {
        private final @Nullable String from;
        private final @Nullable String to;
        private final @Nullable String cc;
        private final @Nullable String bcc;
        private final @Nullable String subject;
        private final @Nullable String text;

        private Details(@Nullable String from, @Nullable String to, @Nullable String cc, @Nullable String bcc, @Nullable String subject, @Nullable String text) {
            this.from = from;
            this.to = to;
            this.cc = cc;
            this.bcc = bcc;
            this.subject = subject;
            this.text = text;
        }

        public @Nullable String getFrom() {
            return this.from;
        }

        public @Nullable String getTo() {
            return this.to;
        }

        public @Nullable String getCc() {
            return this.cc;
        }

        public @Nullable String getBcc() {
            return this.bcc;
        }

        public @Nullable String getSubject() {
            return this.subject;
        }

        public @Nullable String getText() {
            return this.text;
        }
    }

    public static class BounceNotificationBuilder {
        private MimeMessage rawMessage;
        private Details original;
        private Details notification;

        public BounceNotification build() {
            return new BounceNotification(this.rawMessage, this.original, this.notification);
        }

        public BounceNotificationBuilder withRawMessage(MimeMessage rawMessage) {
            this.rawMessage = rawMessage;
            return this;
        }

        public BounceNotificationBuilder withOriginal(Details original) {
            this.original = original;
            return this;
        }

        public BounceNotificationBuilder withNotification(Details notification) {
            this.notification = notification;
            return this;
        }
    }

    public static class DetailsBuilder {
        private @Nullable String from;
        private @Nullable String to;
        private @Nullable String cc;
        private @Nullable String bcc;
        private @Nullable String subject;
        private @Nullable String text;

        public Details build() {
            return new Details(this.from, this.to, this.cc, this.bcc, this.subject, this.text);
        }

        public DetailsBuilder withFrom(@Nullable String from) {
            this.from = from;
            return this;
        }

        public DetailsBuilder withTo(@Nullable String to) {
            this.to = to;
            return this;
        }

        public DetailsBuilder withCc(@Nullable String cc) {
            this.cc = cc;
            return this;
        }

        public DetailsBuilder withBcc(@Nullable String bcc) {
            this.bcc = bcc;
            return this;
        }

        public DetailsBuilder withSubject(@Nullable String subject) {
            this.subject = subject;
            return this;
        }

        public DetailsBuilder withText(@Nullable String text) {
            this.text = text;
            return this;
        }
    }
}

