/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search;

import com.google.appengine.api.search.Facet;
import com.google.appengine.api.search.Field;
import com.google.appengine.api.search.Util;
import com.google.appengine.api.search.checkers.DocumentChecker;
import com.google.appengine.api.search.checkers.FieldChecker;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.HashMultimap;
import com.google.appengine.repackaged.com.google.common.collect.SetMultimap;
import com.google.apphosting.api.search.DocumentPb;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public class Document
implements Serializable {
    static final int MAX_FIELDS_TO_STRING = 10;
    static final int MAX_FACETS_TO_STRING = 10;
    private static final long serialVersionUID = 309382038422977263L;
    private final String documentId;
    private final Map<String, List<Field>> fieldMap;
    private final List<Field> fields;
    private volatile List<Facet> facets;
    private volatile transient Map<String, List<Facet>> facetMap;
    private final int rank;
    private final boolean rankDefaulted;
    private final Locale locale;

    protected Document(Builder builder) {
        this.documentId = builder.documentId;
        this.fieldMap = new HashMap<String, List<Field>>(builder.fieldMap);
        this.fields = Collections.unmodifiableList(builder.fields);
        this.facets = Collections.unmodifiableList(builder.facets);
        this.facetMap = Document.buildFacetMap(this.facets);
        this.locale = builder.locale;
        if (builder.rank == null) {
            this.rank = DocumentChecker.getNumberOfSecondsSince();
            this.rankDefaulted = true;
        } else {
            this.rank = builder.rank;
            this.rankDefaulted = false;
        }
        this.checkValid();
    }

    public Iterable<Field> getFields() {
        return this.fields;
    }

    public Iterable<Facet> getFacets() {
        return this.facets;
    }

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fieldMap.keySet());
    }

    public Set<String> getFacetNames() {
        return this.facetMap.keySet();
    }

    public Iterable<Field> getFields(String name) {
        List<Field> fieldsForName = this.fieldMap.get(name);
        if (fieldsForName == null) {
            return null;
        }
        return Collections.unmodifiableList(fieldsForName);
    }

    public Iterable<Facet> getFacets(String name) {
        List<Facet> facetsForName = this.facetMap.get(name);
        if (facetsForName == null) {
            return null;
        }
        return Collections.unmodifiableList(facetsForName);
    }

    public Field getOnlyField(String name) {
        List<Field> fieldsForName = this.fieldMap.get(name);
        Preconditions.checkArgument(fieldsForName != null && fieldsForName.size() == 1, "Field %s is present %s times; expected 1", (Object)name, fieldsForName == null ? 0 : fieldsForName.size());
        return fieldsForName.get(0);
    }

    public Facet getOnlyFacet(String name) {
        List<Facet> facetsForName = this.facetMap.get(name);
        Preconditions.checkArgument(facetsForName != null && facetsForName.size() == 1, "Facet %s is present %s times; expected 1", (Object)name, facetsForName == null ? 0 : facetsForName.size());
        return facetsForName.get(0);
    }

    public int getFieldCount(String name) {
        List<Field> fieldsForName = this.fieldMap.get(name);
        return fieldsForName == null ? 0 : fieldsForName.size();
    }

    public int getFacetCount(String name) {
        List<Facet> facetsForName = this.facetMap.get(name);
        return facetsForName == null ? 0 : facetsForName.size();
    }

    public String getId() {
        return this.documentId;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int getRank() {
        return this.rank;
    }

    public int hashCode() {
        return this.documentId.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Document)) {
            return false;
        }
        Document doc = (Document)object;
        return this.documentId.equals(doc.getId());
    }

    private Document checkValid() {
        if (this.documentId != null) {
            DocumentChecker.checkDocumentId(this.documentId);
        }
        Preconditions.checkArgument(this.fieldMap != null, "Null map of fields in document for indexing");
        Preconditions.checkArgument(this.fields != null, "Null list of fields in document for indexing");
        Preconditions.checkArgument(this.facetMap != null, "Null map of facets in document for indexing");
        Preconditions.checkArgument(this.facets != null, "Null list of facets in document for indexing");
        return this;
    }

    private static Map<String, List<Facet>> buildFacetMap(List<Facet> facets) {
        LinkedHashMap<String, ArrayList<Facet>> facetMap = new LinkedHashMap<String, ArrayList<Facet>>();
        for (Facet facet : facets) {
            ArrayList<Facet> facetsForName = (ArrayList<Facet>)facetMap.get(facet.getName());
            if (facetsForName == null) {
                facetsForName = new ArrayList<Facet>();
                facetMap.put(facet.getName(), facetsForName);
            }
            facetsForName.add(facet);
        }
        return Collections.unmodifiableMap(facetMap);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.facets == null) {
            this.facets = Collections.emptyList();
        }
        this.facetMap = Document.buildFacetMap(this.facets);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    static Builder newBuilder(DocumentPb.Document document) {
        Builder docBuilder = Document.newBuilder().setId(document.getId());
        if (document.hasLanguage()) {
            docBuilder.setLocale(FieldChecker.parseLocale(document.getLanguage()));
        }
        for (DocumentPb.Field field : document.getFieldList()) {
            docBuilder.addField(Field.newBuilder(field));
        }
        for (DocumentPb.Facet facet : document.getFacetList()) {
            docBuilder.addFacet(Facet.withProtoMessage(facet));
        }
        if (document.hasOrderId()) {
            docBuilder.setRank(document.getOrderId());
        }
        return docBuilder;
    }

    DocumentPb.Document copyToProtocolBuffer() {
        DocumentPb.Document.Builder docBuilder = DocumentPb.Document.newBuilder();
        if (this.documentId != null) {
            docBuilder.setId(this.documentId);
        }
        if (this.locale != null) {
            docBuilder.setLanguage(this.locale.toString());
        }
        for (Field field : this.fields) {
            docBuilder.addField(field.copyToProtocolBuffer());
        }
        for (Facet facet : this.getFacets()) {
            docBuilder.addFacet(facet.copyToProtocolBuffer());
        }
        docBuilder.setOrderId(this.rank);
        DocumentPb.Document.OrderIdSource orderIdSource = this.rankDefaulted ? DocumentPb.Document.OrderIdSource.DEFAULTED : DocumentPb.Document.OrderIdSource.SUPPLIED;
        docBuilder.setOrderIdSource(orderIdSource);
        return DocumentChecker.checkValid(docBuilder.build());
    }

    public String toString() {
        return new Util.ToStringHelper("Document").addField("documentId", this.documentId).addIterableField("fields", this.fields, 10).addIterableField("facets", this.getFacets(), 10).addField("locale", this.locale).addField("rank", this.rank).finish();
    }

    boolean isIdenticalTo(Document other) {
        if (this.documentId == null ? other.documentId != null : !this.documentId.equals(other.documentId)) {
            return false;
        }
        if (this.fields == null ? other.fields != null : !this.fields.equals(other.fields)) {
            return false;
        }
        if (!this.getFacets().equals(other.getFacets())) {
            return false;
        }
        if (this.locale == null ? other.locale != null : !this.locale.equals(other.locale)) {
            return false;
        }
        return this.rank == other.rank;
    }

    public static class Builder {
        private final Map<String, List<Field>> fieldMap = new HashMap<String, List<Field>>();
        private final List<Field> fields = new ArrayList<Field>();
        private final List<Facet> facets = new ArrayList<Facet>();
        private final SetMultimap<String, Field.FieldType> noRepeatNames = HashMultimap.create();
        private @Nullable String documentId;
        private @Nullable Locale locale;
        private @Nullable Integer rank;

        protected Builder() {
        }

        public Builder setId(String documentId) {
            if (documentId != null) {
                this.documentId = DocumentChecker.checkDocumentId(documentId);
            }
            return this;
        }

        public Builder addField(Field.Builder builder) {
            Preconditions.checkNotNull(builder, "field builder cannot be null");
            return this.addField(builder.build());
        }

        public Builder addField(Field field) {
            Preconditions.checkNotNull(field, "field cannot be null");
            Field.FieldType type = field.getType();
            if (!(type != Field.FieldType.DATE && type != Field.FieldType.NUMBER && type != Field.FieldType.VECTOR || this.noRepeatNames.put(field.getName(), type))) {
                if (type == Field.FieldType.VECTOR) {
                    throw new IllegalArgumentException("Vector fields cannot be repeated.");
                }
                throw new IllegalArgumentException("Number and date fields cannot be repeated.");
            }
            this.fields.add(field);
            List<Field> fieldsForName = this.fieldMap.get(field.getName());
            if (fieldsForName == null) {
                fieldsForName = new ArrayList<Field>();
                this.fieldMap.put(field.getName(), fieldsForName);
            }
            fieldsForName.add(field);
            return this;
        }

        public Builder addFacet(Facet facet) {
            Preconditions.checkNotNull(facet, "facet cannot be null");
            this.facets.add(facet);
            return this;
        }

        public Builder setLocale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Builder setRank(int rank) {
            this.rank = rank;
            return this;
        }

        public Document build() {
            return new Document(this);
        }
    }
}

