/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.utils;

import org.jspecify.annotations.Nullable;

public class SystemProperty {
    public static final Environment environment = new Environment();
    public static final SystemProperty version = new SystemProperty("com.google.appengine.runtime.version");
    public static final SystemProperty applicationId = new SystemProperty("com.google.appengine.application.id");
    public static final SystemProperty applicationVersion = new SystemProperty("com.google.appengine.application.version");
    @Deprecated
    public static final SystemProperty instanceReplicaId = new SystemProperty("deprecated");
    private final String key;

    private SystemProperty(String key) {
        this.key = key;
    }

    public String key() {
        return this.key;
    }

    public @Nullable String get() {
        return System.getProperty(this.key());
    }

    public void set(String value) {
        System.setProperty(this.key(), value);
    }

    public static class Environment
    extends SystemProperty {
        private Environment() {
            super("com.google.appengine.runtime.environment");
        }

        public @Nullable Value value() {
            try {
                String propertyValue = this.get();
                return propertyValue != null ? Value.valueOf(propertyValue) : null;
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public void set(Value value) {
            this.set(value.value());
        }

        public static enum Value {
            Production,
            Development;


            public String value() {
                return this.toString();
            }
        }
    }
}

