/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.setup;

import com.google.appengine.setup.AppLogsWriter;
import com.google.appengine.setup.RequestThreadFactory;
import com.google.appengine.setup.timer.Timer;
import com.google.appengine.setup.utils.http.HttpRequest;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.logservice.LogServicePb;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;

public class ApiProxyEnvironment
implements ApiProxy.Environment {
    static final String GAE_APPLICATION = "GAE_APPLICATION";
    static final String GAE_SERVICE = "GAE_SERVICE";
    static final String GAE_VERSION = "GAE_VERSION";
    static final String GAE_INSTANCE = "GAE_INSTANCE";
    public static final String TICKET_HEADER = "X-AppEngine-Api-Ticket";
    public static final String EMAIL_HEADER = "X-AppEngine-User-Email";
    public static final String IS_ADMIN_HEADER = "X-AppEngine-User-Is-Admin";
    public static final String AUTH_DOMAIN_HEADER = "X-AppEngine-Auth-Domain";
    public static final String BACKEND_ID_KEY = "com.google.appengine.backend.id";
    public static final String INSTANCE_ID_KEY = "com.google.appengine.instance.id";
    public static final String REQUEST_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.REQUEST_THREAD_FACTORY";
    public static final String BACKGROUND_THREAD_FACTORY_ATTR = "com.google.appengine.api.ThreadManager.BACKGROUND_THREAD_FACTORY";
    public static final String IS_FEDERATED_USER_KEY = "com.google.appengine.api.users.UserService.is_federated_user";
    public static final String IS_TRUSTED_IP_KEY = "com.google.appengine.runtime.is_trusted_ip";
    public static final String IS_TRUSTED_IP_HEADER = "X-AppEngine-Trusted-IP-Request";
    private static final long DEFAULT_FLUSH_APP_LOGS_EVERY_BYTE_COUNT = 0x100000L;
    private static final int MAX_LOG_FLUSH_SECONDS = 60;
    private static final int DEFAULT_MAX_LOG_LINE_SIZE = 8192;
    static final int MAX_CONCURRENT_API_CALLS = 100;
    static final int MAX_PENDING_API_CALLS = 1000;
    private final String server;
    private final String ticket;
    private final String appId;
    private final String service;
    private final String version;
    private final String email;
    private final boolean admin;
    private final String authDomain;
    private final Map<String, Object> attributes;
    private final Timer wallTimer;
    private final Long millisUntilSoftDeadline;
    private final AppLogsWriter appLogsWriter;
    final Semaphore pendingApiCallSemaphore;
    final Semaphore runningApiCallSemaphore;

    private static String getEnvOrMetadata(Map<String, String> environmentMap, String envKey) {
        return environmentMap.get(envKey);
    }

    public static ApiProxyEnvironment createFromHeaders(Map<String, String> envMap, HttpRequest request, String server, Timer wallTimer, Long millisUntilSoftDeadline) {
        String appId = ApiProxyEnvironment.getEnvOrMetadata(envMap, GAE_APPLICATION);
        String module = ApiProxyEnvironment.getEnvOrMetadata(envMap, GAE_SERVICE);
        String majorVersion = ApiProxyEnvironment.getEnvOrMetadata(envMap, GAE_VERSION);
        String instance = ApiProxyEnvironment.getEnvOrMetadata(envMap, GAE_INSTANCE);
        String ticket = request.getHeader(TICKET_HEADER);
        String email = request.getHeader(EMAIL_HEADER);
        boolean admin = false;
        String value = request.getHeader(IS_ADMIN_HEADER);
        if (value != null && !value.trim().isEmpty()) {
            try {
                admin = Integer.parseInt(value.trim()) != 0;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        }
        String authDomain = request.getHeader(AUTH_DOMAIN_HEADER);
        boolean trustedApp = request.getHeader(IS_TRUSTED_IP_HEADER) != null;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        for (AttributeMapping mapping : AttributeMapping.values()) {
            if (mapping.trustedAppOnly && !trustedApp) continue;
            String headerValue = request.getHeader(mapping.headerKey);
            if (headerValue != null) {
                attributes.put(mapping.attributeKey, headerValue);
                continue;
            }
            if (mapping.defaultValue == null) continue;
            attributes.put(mapping.attributeKey, mapping.defaultValue);
        }
        boolean federatedId = request.getHeader(AttributeMapping.FEDERATED_IDENTITY.headerKey) != null;
        attributes.put(IS_FEDERATED_USER_KEY, federatedId);
        attributes.put(BACKEND_ID_KEY, module);
        attributes.put(INSTANCE_ID_KEY, instance);
        if (trustedApp) {
            boolean trustedIp = "1".equals(request.getHeader(IS_TRUSTED_IP_HEADER));
            attributes.put(IS_TRUSTED_IP_KEY, trustedIp);
        }
        ApiProxyEnvironment requestEnvironment = new ApiProxyEnvironment(server, ticket, appId, module, majorVersion, instance, email, admin, authDomain, wallTimer, millisUntilSoftDeadline, attributes);
        attributes.put(REQUEST_THREAD_FACTORY_ATTR, new RequestThreadFactory(requestEnvironment));
        attributes.put(BACKGROUND_THREAD_FACTORY_ATTR, Executors.defaultThreadFactory());
        return requestEnvironment;
    }

    public ApiProxyEnvironment(String server, String ticket, String appId, String service, String version, String instance, String email, boolean admin, String authDomain, Timer wallTimer, Long millisUntilSoftDeadline, Map<String, Object> attributes) {
        if (server == null || server.isEmpty()) {
            throw new IllegalArgumentException("proxy server host:port must be specified");
        }
        if (millisUntilSoftDeadline != null && wallTimer == null) {
            throw new IllegalArgumentException("wallTimer required when setting millisUntilSoftDeadline");
        }
        if (ticket == null || ticket.isEmpty()) {
            if (appId == null || appId.isEmpty() || service == null || service.isEmpty() || version == null || version.isEmpty() || instance == null || instance.isEmpty()) {
                throw new IllegalArgumentException("When ticket == null the following must be specified: appId=" + appId + ", module=" + service + ", version=" + version + "instance=" + instance);
            }
            String escapedAppId = appId.replace(':', '_').replace('.', '_');
            this.ticket = escapedAppId + '/' + service + '.' + version + "." + instance;
        } else {
            this.ticket = ticket;
        }
        this.server = server;
        this.appId = appId;
        this.service = service == null ? "default" : service;
        this.version = version;
        this.email = email == null ? "" : email;
        this.admin = admin;
        this.authDomain = authDomain == null ? "" : authDomain;
        this.wallTimer = wallTimer;
        this.millisUntilSoftDeadline = millisUntilSoftDeadline;
        this.attributes = Collections.synchronizedMap(attributes);
        this.appLogsWriter = new AppLogsWriter(new LinkedList<LogServicePb.UserAppLogLine>(), 0x100000L, 8192, 60);
        this.pendingApiCallSemaphore = new Semaphore(1000);
        this.runningApiCallSemaphore = new Semaphore(100);
    }

    public void addLogRecord(ApiProxy.LogRecord record) {
        this.appLogsWriter.addLogRecordAndMaybeFlush(record);
    }

    public void flushLogs() {
        this.appLogsWriter.flushAndWait();
    }

    public String getServer() {
        return this.server;
    }

    public String getTicket() {
        return this.ticket;
    }

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public String getModuleId() {
        return this.service;
    }

    @Override
    public String getVersionId() {
        return this.version;
    }

    @Override
    public String getEmail() {
        return this.email;
    }

    @Override
    public boolean isLoggedIn() {
        return this.getEmail() != null && !this.getEmail().trim().isEmpty();
    }

    @Override
    public boolean isAdmin() {
        return this.admin;
    }

    @Override
    public String getAuthDomain() {
        return this.authDomain;
    }

    @Override
    @Deprecated
    public String getRequestNamespace() {
        Object currentNamespace = this.attributes.get(AttributeMapping.CURRENT_NAMESPACE_HEADER.attributeKey);
        if (currentNamespace instanceof String) {
            return (String)currentNamespace;
        }
        return "";
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public long getRemainingMillis() {
        if (this.millisUntilSoftDeadline == null) {
            return Long.MAX_VALUE;
        }
        return this.millisUntilSoftDeadline - this.wallTimer.getNanoseconds() / 1000000L;
    }

    public void aSyncApiCallAdded(long maxWaitMs) throws ApiProxy.ApiProxyException {
        try {
            if (this.pendingApiCallSemaphore.tryAcquire(maxWaitMs, TimeUnit.MILLISECONDS)) {
                return;
            }
            throw new ApiProxy.ApiProxyException("Timed out while acquiring a pending API call semaphore.");
        }
        catch (InterruptedException e) {
            throw new ApiProxy.ApiProxyException("Thread interrupted while acquiring a pending API call semaphore.");
        }
    }

    public void apiCallStarted(long maxWaitMs, boolean releasePendingCall) throws ApiProxy.ApiProxyException {
        try {
            if (this.runningApiCallSemaphore.tryAcquire(maxWaitMs, TimeUnit.MILLISECONDS)) {
                return;
            }
            try {
                throw new ApiProxy.ApiProxyException("Timed out while acquiring an API call semaphore.");
            }
            catch (InterruptedException e) {
                throw new ApiProxy.ApiProxyException("Thread interrupted while acquiring an API call semaphore.");
            }
        }
        finally {
            if (releasePendingCall) {
                this.pendingApiCallSemaphore.release();
            }
        }
    }

    public void apiCallCompleted() {
        this.runningApiCallSemaphore.release();
    }

    static enum AttributeMapping {
        USER_ID("X-AppEngine-User-Id", "com.google.appengine.api.users.UserService.user_id_key", "", false),
        USER_ORGANIZATION("X-AppEngine-User-Organization", "com.google.appengine.api.users.UserService.user_organization", "", false),
        FEDERATED_IDENTITY("X-AppEngine-Federated-Identity", "com.google.appengine.api.users.UserService.federated_identity", "", false),
        FEDERATED_PROVIDER("X-AppEngine-Federated-Provider", "com.google.appengine.api.users.UserService.federated_authority", "", false),
        DATACENTER("X-AppEngine-Datacenter", "com.google.apphosting.api.ApiProxy.datacenter", "", false),
        REQUEST_ID_HASH("X-AppEngine-Request-Id-Hash", "com.google.apphosting.api.ApiProxy.request_id_hash", null, false),
        REQUEST_LOG_ID("X-AppEngine-Request-Log-Id", "com.google.appengine.runtime.request_log_id", null, false),
        DAPPER_ID("X-Google-DapperTraceInfo", "com.google.appengine.runtime.dapper_id", null, false),
        DEFAULT_VERSION_HOSTNAME("X-AppEngine-Default-Version-Hostname", "com.google.appengine.runtime.default_version_hostname", null, false),
        DEFAULT_NAMESPACE_HEADER("X-AppEngine-Default-Namespace", "com.google.appengine.api.NamespaceManager.appsNamespace", null, false),
        CURRENT_NAMESPACE_HEADER("X-AppEngine-Current-Namespace", "com.google.appengine.api.NamespaceManager.currentNamespace", null, false),
        LOAS_PEER_USERNAME("X-AppEngine-LOAS-Peer-Username", "com.google.net.base.peer.loas_peer_username", "", true),
        GAIA_ID("X-AppEngine-Gaia-Id", "com.google.appengine.runtime.gaia_id", "", true),
        GAIA_AUTHUSER("X-AppEngine-Gaia-Authuser", "com.google.appengine.runtime.gaia_authuser", "", true),
        GAIA_SESSION("X-AppEngine-Gaia-Session", "com.google.appengine.runtime.gaia_session", "", true),
        APPSERVER_DATACENTER("X-AppEngine-Appserver-Datacenter", "com.google.appengine.runtime.appserver_datacenter", "", true),
        APPSERVER_TASK_BNS("X-AppEngine-Appserver-Task-Bns", "com.google.appengine.runtime.appserver_task_bns", "", true);

        String headerKey;
        String attributeKey;
        Object defaultValue;
        private boolean trustedAppOnly;

        private AttributeMapping(String headerKey, String attributeKey, Object defaultValue, boolean trustedAppOnly) {
            this.headerKey = headerKey;
            this.attributeKey = attributeKey;
            this.defaultValue = defaultValue;
            this.trustedAppOnly = trustedAppOnly;
        }
    }
}

