/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseEntityComparator;
import com.google.appengine.api.datastore.DataTypeTranslator;
import com.google.appengine.api.datastore.FilterMatcher;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class EntityProtoComparators {
    public static final Comparator<Comparable<Object>> MULTI_TYPE_COMPARATOR = BaseEntityComparator.MULTI_TYPE_COMPARATOR;

    private EntityProtoComparators() {
    }

    public static final class EntityProtoComparator
    extends BaseEntityComparator<OnestoreEntity.EntityProto> {
        public EntityProtoComparator(List<DatastorePb.Query.Order> orders) {
            super(orders, Collections.emptyList());
        }

        public EntityProtoComparator(List<DatastorePb.Query.Order> orders, List<DatastorePb.Query.Filter> filters) {
            super(orders, filters);
        }

        public List<DatastorePb.Query.Order> getAdjustedOrders() {
            return Collections.unmodifiableList(this.orders);
        }

        public boolean matches(OnestoreEntity.EntityProto proto) {
            for (String property : this.filters.keySet()) {
                List<Comparable<Object>> values = this.getComparablePropertyValues(proto, property);
                if (values != null && ((FilterMatcher)this.filters.get(property)).matches(values)) continue;
                return false;
            }
            return true;
        }

        public boolean matches(OnestoreEntity.Property prop) {
            FilterMatcher filter = (FilterMatcher)this.filters.get(prop.getName());
            if (filter == null) {
                return true;
            }
            return filter.matches(Collections.singletonList(DataTypeTranslator.getComparablePropertyValue(prop)));
        }

        @Override
        @Nullable List<Comparable<Object>> getComparablePropertyValues(OnestoreEntity.EntityProto entityProto, String propertyName) {
            Collection<OnestoreEntity.Property> entityProperties = DataTypeTranslator.findIndexedPropertiesOnPb(entityProto, propertyName);
            if (entityProperties.isEmpty()) {
                return null;
            }
            if (propertyName.equals("__key__") && !entityProto.hasKey()) {
                return null;
            }
            ArrayList<Comparable<Object>> values = new ArrayList<Comparable<Object>>(entityProperties.size());
            for (OnestoreEntity.Property prop : entityProperties) {
                values.add(DataTypeTranslator.getComparablePropertyValue(prop));
            }
            return values;
        }
    }
}

