/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.common.flags;

import com.google.appengine.repackaged.com.google.common.flags.DocLevel;
import com.google.appengine.repackaged.com.google.common.flags.FlagDescription;
import com.google.appengine.repackaged.com.google.common.flags.FlagSpec;
import com.google.appengine.repackaged.com.google.common.flags.MalformedFlagDescriptionException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jspecify.nullness.Nullable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

final class XmlSupport {
    static final Pattern TYPENAME_RE = Pattern.compile("com.google.appengine.repackaged.com.google.common.flags.Flag<(.*)>");
    private static final Pattern ESCAPE_RE = Pattern.compile("(&)|(<)|(>)|(\")");
    private static final String[] ESCAPE_SUBS = new String[]{"&amp;", "&lt;", "&gt;", "&quot;"};

    private XmlSupport() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void fromXml(InputStream xmlStream, Map<String, FlagDescription> map) {
        FlagDescription.checkNotNull(map);
        FlagDescriptionHandler flagHandler = new FlagDescriptionHandler(map);
        Class<XmlSupport> clazz = XmlSupport.class;
        synchronized (XmlSupport.class) {
            XMLReader xmlParser = XMLParserHolder.xmlParser;
            xmlParser.setContentHandler(flagHandler);
            xmlParser.setErrorHandler(flagHandler);
            try {
                xmlParser.parse(new InputSource(xmlStream));
            }
            catch (SAXException e) {
                throw new MalformedFlagDescriptionException(e);
            }
            catch (IOException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                xmlParser.setContentHandler(null);
                xmlParser.setErrorHandler(null);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    static Set<FlagDescription> discoverFlags(String className) {
        Class<?> cl;
        HashSet<FlagDescription> flags = new HashSet<FlagDescription>();
        try {
            cl = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return flags;
        }
        for (Field f : cl.getDeclaredFields()) {
            FlagSpec spec = f.getAnnotation(FlagSpec.class);
            if (spec == null) continue;
            String type = f.getGenericType().toString();
            Matcher matcher = TYPENAME_RE.matcher(type);
            if (matcher.matches()) {
                type = FlagDescription.checkStateNotNull(matcher.group(1));
            }
            String string = f.getDeclaringClass().getName();
            String string2 = f.getName();
            String flagName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(".").append(string2).toString();
            boolean isDeprecated = f.isAnnotationPresent(Deprecated.class);
            flags.add(FlagDescription.createFlagFromField(flagName).shortFlagName(spec.name()).doc(spec.help()).altName(spec.altName()).docLevel(spec.docLevel()).type(type).isDeprecated(isDeprecated).build());
        }
        return flags;
    }

    static String serializeOneFlag(FlagDescription desc) {
        StringBuilder b = new StringBuilder();
        b.append("<flag>");
        b.append(XmlSupport.toXmlElement("name", desc.getFullyQualifiedFieldName()));
        b.append(XmlSupport.toXmlElement("shortname", desc.getShortFlagName()));
        b.append(XmlSupport.toXmlElement("doc", desc.getDoc()));
        b.append(XmlSupport.toXmlElement("doclevel", desc.getDocLevel().toString()));
        String altName = desc.getAltName();
        if (altName != null) {
            b.append(XmlSupport.toXmlElement("altname", altName));
        }
        b.append(XmlSupport.toXmlElement("type", desc.getType()));
        if (desc.isDeprecated()) {
            b.append(XmlSupport.toXmlElement("deprecated", "true"));
        }
        b.append("</flag>\n");
        return b.toString();
    }

    static String toXml(Collection<FlagDescription> flags) {
        StringBuilder b = new StringBuilder();
        b.append("<flags>");
        for (FlagDescription d : flags) {
            b.append(XmlSupport.serializeOneFlag(FlagDescription.checkStateNotNull(d)));
        }
        b.append("</flags>");
        return b.toString();
    }

    static String toXmlElement(String name, String content) {
        String string = XmlSupport.xmlEscape(content);
        return new StringBuilder(5 + String.valueOf(name).length() + String.valueOf(string).length() + String.valueOf(name).length()).append("<").append(name).append(">").append(string).append("</").append(name).append(">").toString();
    }

    static String xmlEscape(String s) {
        int position = XmlSupport.requiresEscape(s);
        if (position >= 0) {
            s = XmlSupport.replaceMatches(s, position, ESCAPE_RE, ESCAPE_SUBS);
        }
        return s;
    }

    private static int requiresEscape(String s) {
        for (int i = 0; i < s.length(); ++i) {
            switch (s.charAt(i)) {
                case '\"': 
                case '&': 
                case '<': 
                case '>': {
                    return i;
                }
            }
        }
        return -1;
    }

    private static String replaceMatches(String s, int position, Pattern pattern, String[] subs) {
        if (position < 0) {
            throw new IllegalArgumentException();
        }
        Matcher m = pattern.matcher(s);
        StringBuffer sb = new StringBuffer(s.length() * 2);
        m.find(position);
        block0: do {
            for (int group = 0; group < subs.length; ++group) {
                if (m.group(group + 1) == null) continue;
                m.appendReplacement(sb, subs[group]);
                continue block0;
            }
        } while (m.find());
        m.appendTail(sb);
        return sb.toString();
    }

    private static class FlagDescriptionHandler
    extends DefaultHandler {
        private static final String[] flagNodeChildren = new String[]{"name", "shortname", "doc", "doclevel", "altname", "type", "deprecated"};
        private final Map<String, FlagDescription> flagDescriptions;
        private final List<String> flagContainers = new ArrayList<String>();
        private ParseState parseState = ParseState.FLAGS;
        private final StringBuilder nodeData = new StringBuilder();
        private final Map<String, @Nullable String> flagFields = new HashMap<String, String>();

        public FlagDescriptionHandler(Map<String, FlagDescription> map) {
            this.flagDescriptions = map;
            this.clearFlagFields();
        }

        private void clearFlagFields() {
            for (String elementName : flagNodeChildren) {
                this.flagFields.put(elementName, null);
            }
        }

        @Override
        public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
            switch (this.parseState) {
                case FLAGS: {
                    if ("flag".equals(qName)) {
                        this.parseState = ParseState.FLAG;
                        break;
                    }
                    if (!"flagcontainer".equals(qName)) break;
                    this.parseState = ParseState.FLAG_CONTAINER;
                    break;
                }
                case FLAG: {
                    if (this.flagFields.get(qName) != null) {
                        String string = this.currentFlagName();
                        throw new MalformedFlagDescriptionException(new StringBuilder(51 + String.valueOf(string).length() + String.valueOf(qName).length()).append("Duplicate element encountered while parsing flag ").append(string).append(": ").append(qName).toString());
                    }
                    this.parseState = ParseState.FLAG_CHILD;
                    break;
                }
                case FLAG_CONTAINER: 
                case FLAG_CHILD: {
                    throw new MalformedFlagDescriptionException("Unexpected parse state");
                }
            }
        }

        private String currentFlagName() {
            String flagName = this.flagFields.get("name");
            return flagName == null ? "<unknown>" : flagName;
        }

        @Override
        public void characters(char[] chunk, int offset, int length) {
            if (this.parseState == ParseState.FLAGS) {
                return;
            }
            this.nodeData.append(chunk, offset, length);
        }

        @Override
        public void endElement(String uri, String localName, String qName) {
            switch (this.parseState) {
                case FLAGS: {
                    break;
                }
                case FLAG: {
                    FlagDescription d = this.makeFlagDescription();
                    if (!this.flagDescriptions.containsKey(d.getLongFlagName())) {
                        this.flagDescriptions.put(d.getLongFlagName(), d);
                    }
                    this.clearFlagFields();
                    this.parseState = ParseState.FLAGS;
                    break;
                }
                case FLAG_CHILD: {
                    if (!this.flagFields.containsKey(qName)) {
                        String string = this.currentFlagName();
                        throw new MalformedFlagDescriptionException(new StringBuilder(55 + String.valueOf(string).length() + String.valueOf(qName).length()).append("Unknown element encountered while parsing flag named ").append(string).append(": ").append(qName).toString());
                    }
                    this.flagFields.put(qName, this.nodeData.toString().trim());
                    this.parseState = ParseState.FLAG;
                    break;
                }
                case FLAG_CONTAINER: {
                    this.flagContainers.add(this.nodeData.toString().trim());
                    this.parseState = ParseState.FLAGS;
                }
            }
            this.nodeData.setLength(0);
        }

        private FlagDescription makeFlagDescription() {
            DocLevel docLevel;
            String fullyQualifiedFieldName = this.flagFields.get("name");
            if (fullyQualifiedFieldName == null) {
                throw new MalformedFlagDescriptionException("name missing");
            }
            String level = this.flagFields.get("doclevel");
            if (level == null) {
                String string = String.valueOf("doclevel missing for flag ");
                String string2 = String.valueOf(fullyQualifiedFieldName);
                throw new MalformedFlagDescriptionException(string2.length() != 0 ? string.concat(string2) : new String(string));
            }
            try {
                docLevel = DocLevel.valueOf(level);
            }
            catch (IllegalArgumentException e) {
                throw new MalformedFlagDescriptionException(new StringBuilder(28 + String.valueOf(fullyQualifiedFieldName).length() + String.valueOf(level).length()).append("Illegal doclevel for flag ").append(fullyQualifiedFieldName).append(": ").append(level).toString());
            }
            String doc = this.flagFields.get("doc");
            if (doc == null) {
                String string = String.valueOf("doc missing for flag ");
                String string3 = String.valueOf(fullyQualifiedFieldName);
                throw new MalformedFlagDescriptionException(string3.length() != 0 ? string.concat(string3) : new String(string));
            }
            String type = this.flagFields.get("type");
            if (type == null) {
                String string = String.valueOf("type missing for flag ");
                String string4 = String.valueOf(fullyQualifiedFieldName);
                throw new MalformedFlagDescriptionException(string4.length() != 0 ? string.concat(string4) : new String(string));
            }
            boolean deprecated = Boolean.parseBoolean(this.flagFields.get("deprecated"));
            return FlagDescription.createFlagFromField(fullyQualifiedFieldName).shortFlagName(this.flagFields.get("shortname")).doc(doc).altName(this.flagFields.get("altname")).docLevel(docLevel).type(type).isDeprecated(deprecated).build();
        }

        @Override
        public void endDocument() {
            for (String className : this.flagContainers) {
                Set<FlagDescription> flags = XmlSupport.discoverFlags(FlagDescription.checkStateNotNull(className));
                for (FlagDescription d : flags) {
                    if (this.flagDescriptions.containsKey(d.getLongFlagName())) continue;
                    this.flagDescriptions.put(d.getLongFlagName(), d);
                }
            }
        }
    }

    private static class FlagElementName {
        private static final String NAME = "name";
        private static final String SHORTNAME = "shortname";
        private static final String ALTNAME = "altname";
        private static final String TYPE = "type";
        private static final String DOC = "doc";
        private static final String DOCLEVEL = "doclevel";
        private static final String DEPRECATED = "deprecated";

        private FlagElementName() {
        }
    }

    private static enum ParseState {
        FLAGS,
        FLAG,
        FLAG_CHILD,
        FLAG_CONTAINER;

    }

    private static class XMLParserHolder {
        public static final XMLReader xmlParser = XMLParserHolder.createXMLParser();

        private XMLParserHolder() {
        }

        private static XMLReader createXMLParser() {
            try {
                return XMLReaderFactory.createXMLReader();
            }
            catch (SAXException e) {
                throw new AssertionError((Object)e);
            }
        }
    }
}

