/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.protocol;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;

public final class UnbufferedReader
extends BufferedReader {
    private static final int BUFSIZE_INITIAL = 1024;
    private static final int BUFSIZE_MAX = 65536;
    private InputStream in;
    private String enc;
    private byte[] buffer;
    private int bufferSize;
    private byte[] eol;
    private boolean eight_bit_char;

    public UnbufferedReader(InputStream in, String encoding, byte[] eol) {
        super(new StringReader(""));
        this.in = in;
        this.enc = encoding;
        this.buffer = new byte[1024];
        this.bufferSize = 1024;
        this.eol = eol;
        this.eight_bit_char = "ISO-8859-1".equals(this.enc) || "US-ASCII".equals(this.enc);
    }

    public UnbufferedReader(InputStream in, String encoding) {
        this(in, encoding, new byte[]{10});
    }

    @Override
    public int read() throws IOException {
        return this.in.read();
    }

    @Override
    public int read(char[] cbuf, int off, int len) throws IOException, UnsupportedOperationException {
        if (!this.eight_bit_char) {
            throw new UnsupportedOperationException();
        }
        byte[] b = new byte[len];
        int size = this.in.read(b, 0, len);
        int i = 0;
        int j = off;
        while (i < size) {
            cbuf[j] = (char)b[i];
            ++i;
            ++j;
        }
        return size;
    }

    @Override
    public String readLine() throws IOException {
        int byteOrEOF;
        int bytesRead = 0;
        int eolBytesRead = 0;
        while ((byteOrEOF = this.in.read()) != -1) {
            byte b = (byte)byteOrEOF;
            if (b == this.eol[eolBytesRead]) {
                if (++eolBytesRead == this.eol.length) {
                    if (eolBytesRead == 1 && b == 10 && bytesRead > 0 && this.buffer[bytesRead - 1] == 13) {
                        bytesRead -= eolBytesRead;
                        break;
                    }
                    bytesRead -= eolBytesRead - 1;
                    break;
                }
            } else {
                eolBytesRead = b == this.eol[0] ? 1 : 0;
            }
            if (bytesRead >= this.bufferSize) {
                if (this.bufferSize * 2 > 65536) {
                    throw new IOException("readLine() buffer overflow: line too long");
                }
                this.bufferSize *= 2;
                byte[] newBuf = new byte[this.bufferSize];
                System.arraycopy(this.buffer, 0, newBuf, 0, bytesRead);
                this.buffer = newBuf;
            }
            this.buffer[bytesRead++] = b;
        }
        if (bytesRead > 0 || eolBytesRead > 0) {
            return new String(this.buffer, 0, bytesRead, this.enc);
        }
        return null;
    }

    @Override
    public long skip(long n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean ready() throws IOException {
        return this.in.available() > 0;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public void mark(int readAheadLimit) throws IOException {
        throw new IOException();
    }

    @Override
    public void reset() throws IOException {
        throw new IOException();
    }

    @Override
    public void close() {
    }

    public static void main(String[] args) throws IOException, UnsupportedEncodingException {
        String enc = "UTF8";
        String a = "resum\u00e9";
        String eol = "\r\n";
        String b = new StringBuilder(String.valueOf(a).length() + String.valueOf(eol).length() + String.valueOf(eol).length() + String.valueOf(a).length() + String.valueOf(a).length() + String.valueOf(eol).length() + String.valueOf(a).length()).append(a).append(eol).append(eol).append(a).append(a).append(eol).append(a).toString();
        byte[] ba = b.getBytes(enc);
        ByteArrayInputStream bais = new ByteArrayInputStream(ba);
        UnbufferedReader r = new UnbufferedReader(bais, enc, eol.getBytes());
        System.out.println(r.readLine());
        System.out.println(r.readLine());
        System.out.println(r.readLine());
        System.out.println(r.readLine());
        System.out.println(r.readLine());
    }
}

