/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/datastore/v1/datastore.proto

package com.google.datastore.v1;

/**
 *
 *
 * <pre>
 * The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
 * </pre>
 *
 * Protobuf type {@code google.datastore.v1.RunQueryRequest}
 */
public final class RunQueryRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.datastore.v1.RunQueryRequest)
    RunQueryRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use RunQueryRequest.newBuilder() to construct.
  private RunQueryRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RunQueryRequest() {
    projectId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RunQueryRequest();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private RunQueryRequest(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              com.google.datastore.v1.ReadOptions.Builder subBuilder = null;
              if (readOptions_ != null) {
                subBuilder = readOptions_.toBuilder();
              }
              readOptions_ =
                  input.readMessage(
                      com.google.datastore.v1.ReadOptions.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(readOptions_);
                readOptions_ = subBuilder.buildPartial();
              }

              break;
            }
          case 18:
            {
              com.google.datastore.v1.PartitionId.Builder subBuilder = null;
              if (partitionId_ != null) {
                subBuilder = partitionId_.toBuilder();
              }
              partitionId_ =
                  input.readMessage(
                      com.google.datastore.v1.PartitionId.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom(partitionId_);
                partitionId_ = subBuilder.buildPartial();
              }

              break;
            }
          case 26:
            {
              com.google.datastore.v1.Query.Builder subBuilder = null;
              if (queryTypeCase_ == 3) {
                subBuilder = ((com.google.datastore.v1.Query) queryType_).toBuilder();
              }
              queryType_ =
                  input.readMessage(com.google.datastore.v1.Query.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.Query) queryType_);
                queryType_ = subBuilder.buildPartial();
              }
              queryTypeCase_ = 3;
              break;
            }
          case 58:
            {
              com.google.datastore.v1.GqlQuery.Builder subBuilder = null;
              if (queryTypeCase_ == 7) {
                subBuilder = ((com.google.datastore.v1.GqlQuery) queryType_).toBuilder();
              }
              queryType_ =
                  input.readMessage(com.google.datastore.v1.GqlQuery.parser(), extensionRegistry);
              if (subBuilder != null) {
                subBuilder.mergeFrom((com.google.datastore.v1.GqlQuery) queryType_);
                queryType_ = subBuilder.buildPartial();
              }
              queryTypeCase_ = 7;
              break;
            }
          case 66:
            {
              java.lang.String s = input.readStringRequireUtf8();

              projectId_ = s;
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (com.google.protobuf.UninitializedMessageException e) {
      throw e.asInvalidProtocolBufferException().setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_RunQueryRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.datastore.v1.DatastoreProto
        .internal_static_google_datastore_v1_RunQueryRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.datastore.v1.RunQueryRequest.class,
            com.google.datastore.v1.RunQueryRequest.Builder.class);
  }

  private int queryTypeCase_ = 0;
  private java.lang.Object queryType_;

  public enum QueryTypeCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    QUERY(3),
    GQL_QUERY(7),
    QUERYTYPE_NOT_SET(0);
    private final int value;

    private QueryTypeCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static QueryTypeCase valueOf(int value) {
      return forNumber(value);
    }

    public static QueryTypeCase forNumber(int value) {
      switch (value) {
        case 3:
          return QUERY;
        case 7:
          return GQL_QUERY;
        case 0:
          return QUERYTYPE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public QueryTypeCase getQueryTypeCase() {
    return QueryTypeCase.forNumber(queryTypeCase_);
  }

  public static final int PROJECT_ID_FIELD_NUMBER = 8;
  private volatile java.lang.Object projectId_;
  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The projectId.
   */
  @java.lang.Override
  public java.lang.String getProjectId() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      projectId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the project against which to make the request.
   * </pre>
   *
   * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for projectId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getProjectIdBytes() {
    java.lang.Object ref = projectId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      projectId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PARTITION_ID_FIELD_NUMBER = 2;
  private com.google.datastore.v1.PartitionId partitionId_;
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   *
   * @return Whether the partitionId field is set.
   */
  @java.lang.Override
  public boolean hasPartitionId() {
    return partitionId_ != null;
  }
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   *
   * @return The partitionId.
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionId getPartitionId() {
    return partitionId_ == null
        ? com.google.datastore.v1.PartitionId.getDefaultInstance()
        : partitionId_;
  }
  /**
   *
   *
   * <pre>
   * Entities are partitioned into subsets, identified by a partition ID.
   * Queries are scoped to a single partition.
   * This partition ID is normalized with the standard default context
   * partition ID.
   * </pre>
   *
   * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
    return getPartitionId();
  }

  public static final int READ_OPTIONS_FIELD_NUMBER = 1;
  private com.google.datastore.v1.ReadOptions readOptions_;
  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   *
   * @return Whether the readOptions field is set.
   */
  @java.lang.Override
  public boolean hasReadOptions() {
    return readOptions_ != null;
  }
  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   *
   * @return The readOptions.
   */
  @java.lang.Override
  public com.google.datastore.v1.ReadOptions getReadOptions() {
    return readOptions_ == null
        ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
        : readOptions_;
  }
  /**
   *
   *
   * <pre>
   * The options for this query.
   * </pre>
   *
   * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.ReadOptionsOrBuilder getReadOptionsOrBuilder() {
    return getReadOptions();
  }

  public static final int QUERY_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.Query query = 3;</code>
   *
   * @return Whether the query field is set.
   */
  @java.lang.Override
  public boolean hasQuery() {
    return queryTypeCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.Query query = 3;</code>
   *
   * @return The query.
   */
  @java.lang.Override
  public com.google.datastore.v1.Query getQuery() {
    if (queryTypeCase_ == 3) {
      return (com.google.datastore.v1.Query) queryType_;
    }
    return com.google.datastore.v1.Query.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.Query query = 3;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.QueryOrBuilder getQueryOrBuilder() {
    if (queryTypeCase_ == 3) {
      return (com.google.datastore.v1.Query) queryType_;
    }
    return com.google.datastore.v1.Query.getDefaultInstance();
  }

  public static final int GQL_QUERY_FIELD_NUMBER = 7;
  /**
   *
   *
   * <pre>
   * The GQL query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   *
   * @return Whether the gqlQuery field is set.
   */
  @java.lang.Override
  public boolean hasGqlQuery() {
    return queryTypeCase_ == 7;
  }
  /**
   *
   *
   * <pre>
   * The GQL query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   *
   * @return The gqlQuery.
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQuery getGqlQuery() {
    if (queryTypeCase_ == 7) {
      return (com.google.datastore.v1.GqlQuery) queryType_;
    }
    return com.google.datastore.v1.GqlQuery.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The GQL query to run.
   * </pre>
   *
   * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
   */
  @java.lang.Override
  public com.google.datastore.v1.GqlQueryOrBuilder getGqlQueryOrBuilder() {
    if (queryTypeCase_ == 7) {
      return (com.google.datastore.v1.GqlQuery) queryType_;
    }
    return com.google.datastore.v1.GqlQuery.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (readOptions_ != null) {
      output.writeMessage(1, getReadOptions());
    }
    if (partitionId_ != null) {
      output.writeMessage(2, getPartitionId());
    }
    if (queryTypeCase_ == 3) {
      output.writeMessage(3, (com.google.datastore.v1.Query) queryType_);
    }
    if (queryTypeCase_ == 7) {
      output.writeMessage(7, (com.google.datastore.v1.GqlQuery) queryType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, projectId_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (readOptions_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getReadOptions());
    }
    if (partitionId_ != null) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPartitionId());
    }
    if (queryTypeCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.datastore.v1.Query) queryType_);
    }
    if (queryTypeCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7, (com.google.datastore.v1.GqlQuery) queryType_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(projectId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, projectId_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.datastore.v1.RunQueryRequest)) {
      return super.equals(obj);
    }
    com.google.datastore.v1.RunQueryRequest other = (com.google.datastore.v1.RunQueryRequest) obj;

    if (!getProjectId().equals(other.getProjectId())) return false;
    if (hasPartitionId() != other.hasPartitionId()) return false;
    if (hasPartitionId()) {
      if (!getPartitionId().equals(other.getPartitionId())) return false;
    }
    if (hasReadOptions() != other.hasReadOptions()) return false;
    if (hasReadOptions()) {
      if (!getReadOptions().equals(other.getReadOptions())) return false;
    }
    if (!getQueryTypeCase().equals(other.getQueryTypeCase())) return false;
    switch (queryTypeCase_) {
      case 3:
        if (!getQuery().equals(other.getQuery())) return false;
        break;
      case 7:
        if (!getGqlQuery().equals(other.getGqlQuery())) return false;
        break;
      case 0:
      default:
    }
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PROJECT_ID_FIELD_NUMBER;
    hash = (53 * hash) + getProjectId().hashCode();
    if (hasPartitionId()) {
      hash = (37 * hash) + PARTITION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getPartitionId().hashCode();
    }
    if (hasReadOptions()) {
      hash = (37 * hash) + READ_OPTIONS_FIELD_NUMBER;
      hash = (53 * hash) + getReadOptions().hashCode();
    }
    switch (queryTypeCase_) {
      case 3:
        hash = (37 * hash) + QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getQuery().hashCode();
        break;
      case 7:
        hash = (37 * hash) + GQL_QUERY_FIELD_NUMBER;
        hash = (53 * hash) + getGqlQuery().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.RunQueryRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunQueryRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.datastore.v1.RunQueryRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.datastore.v1.RunQueryRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * The request for [Datastore.RunQuery][google.datastore.v1.Datastore.RunQuery].
   * </pre>
   *
   * Protobuf type {@code google.datastore.v1.RunQueryRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.datastore.v1.RunQueryRequest)
      com.google.datastore.v1.RunQueryRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunQueryRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunQueryRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.datastore.v1.RunQueryRequest.class,
              com.google.datastore.v1.RunQueryRequest.Builder.class);
    }

    // Construct using com.google.datastore.v1.RunQueryRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      projectId_ = "";

      if (partitionIdBuilder_ == null) {
        partitionId_ = null;
      } else {
        partitionId_ = null;
        partitionIdBuilder_ = null;
      }
      if (readOptionsBuilder_ == null) {
        readOptions_ = null;
      } else {
        readOptions_ = null;
        readOptionsBuilder_ = null;
      }
      queryTypeCase_ = 0;
      queryType_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.datastore.v1.DatastoreProto
          .internal_static_google_datastore_v1_RunQueryRequest_descriptor;
    }

    @java.lang.Override
    public com.google.datastore.v1.RunQueryRequest getDefaultInstanceForType() {
      return com.google.datastore.v1.RunQueryRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.datastore.v1.RunQueryRequest build() {
      com.google.datastore.v1.RunQueryRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.datastore.v1.RunQueryRequest buildPartial() {
      com.google.datastore.v1.RunQueryRequest result =
          new com.google.datastore.v1.RunQueryRequest(this);
      result.projectId_ = projectId_;
      if (partitionIdBuilder_ == null) {
        result.partitionId_ = partitionId_;
      } else {
        result.partitionId_ = partitionIdBuilder_.build();
      }
      if (readOptionsBuilder_ == null) {
        result.readOptions_ = readOptions_;
      } else {
        result.readOptions_ = readOptionsBuilder_.build();
      }
      if (queryTypeCase_ == 3) {
        if (queryBuilder_ == null) {
          result.queryType_ = queryType_;
        } else {
          result.queryType_ = queryBuilder_.build();
        }
      }
      if (queryTypeCase_ == 7) {
        if (gqlQueryBuilder_ == null) {
          result.queryType_ = queryType_;
        } else {
          result.queryType_ = gqlQueryBuilder_.build();
        }
      }
      result.queryTypeCase_ = queryTypeCase_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.datastore.v1.RunQueryRequest) {
        return mergeFrom((com.google.datastore.v1.RunQueryRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.datastore.v1.RunQueryRequest other) {
      if (other == com.google.datastore.v1.RunQueryRequest.getDefaultInstance()) return this;
      if (!other.getProjectId().isEmpty()) {
        projectId_ = other.projectId_;
        onChanged();
      }
      if (other.hasPartitionId()) {
        mergePartitionId(other.getPartitionId());
      }
      if (other.hasReadOptions()) {
        mergeReadOptions(other.getReadOptions());
      }
      switch (other.getQueryTypeCase()) {
        case QUERY:
          {
            mergeQuery(other.getQuery());
            break;
          }
        case GQL_QUERY:
          {
            mergeGqlQuery(other.getGqlQuery());
            break;
          }
        case QUERYTYPE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.datastore.v1.RunQueryRequest parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.datastore.v1.RunQueryRequest) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int queryTypeCase_ = 0;
    private java.lang.Object queryType_;

    public QueryTypeCase getQueryTypeCase() {
      return QueryTypeCase.forNumber(queryTypeCase_);
    }

    public Builder clearQueryType() {
      queryTypeCase_ = 0;
      queryType_ = null;
      onChanged();
      return this;
    }

    private java.lang.Object projectId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The projectId.
     */
    public java.lang.String getProjectId() {
      java.lang.Object ref = projectId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        projectId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for projectId.
     */
    public com.google.protobuf.ByteString getProjectIdBytes() {
      java.lang.Object ref = projectId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        projectId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }

      projectId_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearProjectId() {

      projectId_ = getDefaultInstance().getProjectId();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the project against which to make the request.
     * </pre>
     *
     * <code>string project_id = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for projectId to set.
     * @return This builder for chaining.
     */
    public Builder setProjectIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);

      projectId_ = value;
      onChanged();
      return this;
    }

    private com.google.datastore.v1.PartitionId partitionId_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        partitionIdBuilder_;
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     *
     * @return Whether the partitionId field is set.
     */
    public boolean hasPartitionId() {
      return partitionIdBuilder_ != null || partitionId_ != null;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     *
     * @return The partitionId.
     */
    public com.google.datastore.v1.PartitionId getPartitionId() {
      if (partitionIdBuilder_ == null) {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      } else {
        return partitionIdBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        partitionId_ = value;
        onChanged();
      } else {
        partitionIdBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder setPartitionId(com.google.datastore.v1.PartitionId.Builder builderForValue) {
      if (partitionIdBuilder_ == null) {
        partitionId_ = builderForValue.build();
        onChanged();
      } else {
        partitionIdBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder mergePartitionId(com.google.datastore.v1.PartitionId value) {
      if (partitionIdBuilder_ == null) {
        if (partitionId_ != null) {
          partitionId_ =
              com.google.datastore.v1.PartitionId.newBuilder(partitionId_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          partitionId_ = value;
        }
        onChanged();
      } else {
        partitionIdBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public Builder clearPartitionId() {
      if (partitionIdBuilder_ == null) {
        partitionId_ = null;
        onChanged();
      } else {
        partitionId_ = null;
        partitionIdBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public com.google.datastore.v1.PartitionId.Builder getPartitionIdBuilder() {

      onChanged();
      return getPartitionIdFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    public com.google.datastore.v1.PartitionIdOrBuilder getPartitionIdOrBuilder() {
      if (partitionIdBuilder_ != null) {
        return partitionIdBuilder_.getMessageOrBuilder();
      } else {
        return partitionId_ == null
            ? com.google.datastore.v1.PartitionId.getDefaultInstance()
            : partitionId_;
      }
    }
    /**
     *
     *
     * <pre>
     * Entities are partitioned into subsets, identified by a partition ID.
     * Queries are scoped to a single partition.
     * This partition ID is normalized with the standard default context
     * partition ID.
     * </pre>
     *
     * <code>.google.datastore.v1.PartitionId partition_id = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.PartitionId,
            com.google.datastore.v1.PartitionId.Builder,
            com.google.datastore.v1.PartitionIdOrBuilder>
        getPartitionIdFieldBuilder() {
      if (partitionIdBuilder_ == null) {
        partitionIdBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.PartitionId,
                com.google.datastore.v1.PartitionId.Builder,
                com.google.datastore.v1.PartitionIdOrBuilder>(
                getPartitionId(), getParentForChildren(), isClean());
        partitionId_ = null;
      }
      return partitionIdBuilder_;
    }

    private com.google.datastore.v1.ReadOptions readOptions_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ReadOptions,
            com.google.datastore.v1.ReadOptions.Builder,
            com.google.datastore.v1.ReadOptionsOrBuilder>
        readOptionsBuilder_;
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     *
     * @return Whether the readOptions field is set.
     */
    public boolean hasReadOptions() {
      return readOptionsBuilder_ != null || readOptions_ != null;
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     *
     * @return The readOptions.
     */
    public com.google.datastore.v1.ReadOptions getReadOptions() {
      if (readOptionsBuilder_ == null) {
        return readOptions_ == null
            ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
            : readOptions_;
      } else {
        return readOptionsBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder setReadOptions(com.google.datastore.v1.ReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        readOptions_ = value;
        onChanged();
      } else {
        readOptionsBuilder_.setMessage(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder setReadOptions(com.google.datastore.v1.ReadOptions.Builder builderForValue) {
      if (readOptionsBuilder_ == null) {
        readOptions_ = builderForValue.build();
        onChanged();
      } else {
        readOptionsBuilder_.setMessage(builderForValue.build());
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder mergeReadOptions(com.google.datastore.v1.ReadOptions value) {
      if (readOptionsBuilder_ == null) {
        if (readOptions_ != null) {
          readOptions_ =
              com.google.datastore.v1.ReadOptions.newBuilder(readOptions_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          readOptions_ = value;
        }
        onChanged();
      } else {
        readOptionsBuilder_.mergeFrom(value);
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public Builder clearReadOptions() {
      if (readOptionsBuilder_ == null) {
        readOptions_ = null;
        onChanged();
      } else {
        readOptions_ = null;
        readOptionsBuilder_ = null;
      }

      return this;
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public com.google.datastore.v1.ReadOptions.Builder getReadOptionsBuilder() {

      onChanged();
      return getReadOptionsFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    public com.google.datastore.v1.ReadOptionsOrBuilder getReadOptionsOrBuilder() {
      if (readOptionsBuilder_ != null) {
        return readOptionsBuilder_.getMessageOrBuilder();
      } else {
        return readOptions_ == null
            ? com.google.datastore.v1.ReadOptions.getDefaultInstance()
            : readOptions_;
      }
    }
    /**
     *
     *
     * <pre>
     * The options for this query.
     * </pre>
     *
     * <code>.google.datastore.v1.ReadOptions read_options = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.ReadOptions,
            com.google.datastore.v1.ReadOptions.Builder,
            com.google.datastore.v1.ReadOptionsOrBuilder>
        getReadOptionsFieldBuilder() {
      if (readOptionsBuilder_ == null) {
        readOptionsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.ReadOptions,
                com.google.datastore.v1.ReadOptions.Builder,
                com.google.datastore.v1.ReadOptionsOrBuilder>(
                getReadOptions(), getParentForChildren(), isClean());
        readOptions_ = null;
      }
      return readOptionsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Query,
            com.google.datastore.v1.Query.Builder,
            com.google.datastore.v1.QueryOrBuilder>
        queryBuilder_;
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     *
     * @return Whether the query field is set.
     */
    @java.lang.Override
    public boolean hasQuery() {
      return queryTypeCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     *
     * @return The query.
     */
    @java.lang.Override
    public com.google.datastore.v1.Query getQuery() {
      if (queryBuilder_ == null) {
        if (queryTypeCase_ == 3) {
          return (com.google.datastore.v1.Query) queryType_;
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 3) {
          return queryBuilder_.getMessage();
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    public Builder setQuery(com.google.datastore.v1.Query value) {
      if (queryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        queryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    public Builder setQuery(com.google.datastore.v1.Query.Builder builderForValue) {
      if (queryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        queryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    public Builder mergeQuery(com.google.datastore.v1.Query value) {
      if (queryBuilder_ == null) {
        if (queryTypeCase_ == 3
            && queryType_ != com.google.datastore.v1.Query.getDefaultInstance()) {
          queryType_ =
              com.google.datastore.v1.Query.newBuilder((com.google.datastore.v1.Query) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 3) {
          queryBuilder_.mergeFrom(value);
        } else {
          queryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    public Builder clearQuery() {
      if (queryBuilder_ == null) {
        if (queryTypeCase_ == 3) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 3) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        queryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    public com.google.datastore.v1.Query.Builder getQueryBuilder() {
      return getQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.QueryOrBuilder getQueryOrBuilder() {
      if ((queryTypeCase_ == 3) && (queryBuilder_ != null)) {
        return queryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 3) {
          return (com.google.datastore.v1.Query) queryType_;
        }
        return com.google.datastore.v1.Query.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.Query query = 3;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.Query,
            com.google.datastore.v1.Query.Builder,
            com.google.datastore.v1.QueryOrBuilder>
        getQueryFieldBuilder() {
      if (queryBuilder_ == null) {
        if (!(queryTypeCase_ == 3)) {
          queryType_ = com.google.datastore.v1.Query.getDefaultInstance();
        }
        queryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.Query,
                com.google.datastore.v1.Query.Builder,
                com.google.datastore.v1.QueryOrBuilder>(
                (com.google.datastore.v1.Query) queryType_, getParentForChildren(), isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 3;
      onChanged();
      ;
      return queryBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.GqlQuery,
            com.google.datastore.v1.GqlQuery.Builder,
            com.google.datastore.v1.GqlQueryOrBuilder>
        gqlQueryBuilder_;
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     *
     * @return Whether the gqlQuery field is set.
     */
    @java.lang.Override
    public boolean hasGqlQuery() {
      return queryTypeCase_ == 7;
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     *
     * @return The gqlQuery.
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQuery getGqlQuery() {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7) {
          return (com.google.datastore.v1.GqlQuery) queryType_;
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      } else {
        if (queryTypeCase_ == 7) {
          return gqlQueryBuilder_.getMessage();
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder setGqlQuery(com.google.datastore.v1.GqlQuery value) {
      if (gqlQueryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        queryType_ = value;
        onChanged();
      } else {
        gqlQueryBuilder_.setMessage(value);
      }
      queryTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder setGqlQuery(com.google.datastore.v1.GqlQuery.Builder builderForValue) {
      if (gqlQueryBuilder_ == null) {
        queryType_ = builderForValue.build();
        onChanged();
      } else {
        gqlQueryBuilder_.setMessage(builderForValue.build());
      }
      queryTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder mergeGqlQuery(com.google.datastore.v1.GqlQuery value) {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7
            && queryType_ != com.google.datastore.v1.GqlQuery.getDefaultInstance()) {
          queryType_ =
              com.google.datastore.v1.GqlQuery.newBuilder(
                      (com.google.datastore.v1.GqlQuery) queryType_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          queryType_ = value;
        }
        onChanged();
      } else {
        if (queryTypeCase_ == 7) {
          gqlQueryBuilder_.mergeFrom(value);
        } else {
          gqlQueryBuilder_.setMessage(value);
        }
      }
      queryTypeCase_ = 7;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public Builder clearGqlQuery() {
      if (gqlQueryBuilder_ == null) {
        if (queryTypeCase_ == 7) {
          queryTypeCase_ = 0;
          queryType_ = null;
          onChanged();
        }
      } else {
        if (queryTypeCase_ == 7) {
          queryTypeCase_ = 0;
          queryType_ = null;
        }
        gqlQueryBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    public com.google.datastore.v1.GqlQuery.Builder getGqlQueryBuilder() {
      return getGqlQueryFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    @java.lang.Override
    public com.google.datastore.v1.GqlQueryOrBuilder getGqlQueryOrBuilder() {
      if ((queryTypeCase_ == 7) && (gqlQueryBuilder_ != null)) {
        return gqlQueryBuilder_.getMessageOrBuilder();
      } else {
        if (queryTypeCase_ == 7) {
          return (com.google.datastore.v1.GqlQuery) queryType_;
        }
        return com.google.datastore.v1.GqlQuery.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The GQL query to run.
     * </pre>
     *
     * <code>.google.datastore.v1.GqlQuery gql_query = 7;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.datastore.v1.GqlQuery,
            com.google.datastore.v1.GqlQuery.Builder,
            com.google.datastore.v1.GqlQueryOrBuilder>
        getGqlQueryFieldBuilder() {
      if (gqlQueryBuilder_ == null) {
        if (!(queryTypeCase_ == 7)) {
          queryType_ = com.google.datastore.v1.GqlQuery.getDefaultInstance();
        }
        gqlQueryBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.datastore.v1.GqlQuery,
                com.google.datastore.v1.GqlQuery.Builder,
                com.google.datastore.v1.GqlQueryOrBuilder>(
                (com.google.datastore.v1.GqlQuery) queryType_, getParentForChildren(), isClean());
        queryType_ = null;
      }
      queryTypeCase_ = 7;
      onChanged();
      ;
      return gqlQueryBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.datastore.v1.RunQueryRequest)
  }

  // @@protoc_insertion_point(class_scope:google.datastore.v1.RunQueryRequest)
  private static final com.google.datastore.v1.RunQueryRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.datastore.v1.RunQueryRequest();
  }

  public static com.google.datastore.v1.RunQueryRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RunQueryRequest> PARSER =
      new com.google.protobuf.AbstractParser<RunQueryRequest>() {
        @java.lang.Override
        public RunQueryRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new RunQueryRequest(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<RunQueryRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RunQueryRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.datastore.v1.RunQueryRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
