/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.BaseQuerySplitter;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QuerySplitComponent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

class NotEqualQuerySplitter
extends BaseQuerySplitter {
    NotEqualQuerySplitter() {
    }

    @Override
    public List<QuerySplitComponent> split(List<Query.FilterPredicate> remainingFilters, List<Query.SortPredicate> sorts) {
        String propertyName = null;
        ArrayList<BaseQuerySplitter.ComparableValue> values = new ArrayList<BaseQuerySplitter.ComparableValue>();
        Iterator<Query.FilterPredicate> itr = remainingFilters.iterator();
        while (itr.hasNext()) {
            Query.FilterPredicate filter = itr.next();
            if (filter.getOperator() != Query.FilterOperator.NOT_EQUAL) continue;
            if (propertyName == null) {
                propertyName = filter.getPropertyName();
            } else if (!propertyName.equals(filter.getPropertyName())) {
                throw new IllegalArgumentException("Queries with NOT_EQUAL filters on different properties are not supported.");
            }
            values.add(new BaseQuerySplitter.ComparableValue(filter.getValue()));
            itr.remove();
        }
        if (!values.isEmpty()) {
            ArrayList<QuerySplitComponent> result = new ArrayList<QuerySplitComponent>(values.size() + 1);
            result.add(this.makeComponent(propertyName, values, sorts));
            return result;
        }
        return Collections.emptyList();
    }

    private QuerySplitComponent makeComponent(String propertyName, List<BaseQuerySplitter.ComparableValue> values, List<Query.SortPredicate> sorts) {
        QuerySplitComponent result = new QuerySplitComponent(propertyName, sorts);
        if (!sorts.isEmpty() && result.getSortIndex() != 0) {
            throw new IllegalArgumentException("The first sort order must be on the same property as the NOT_EQUAL filter");
        }
        Collections.sort(values, NotEqualQuerySplitter.getValueComparator(result.getDirection()));
        Object first = values.get(0).getValue();
        Object last = values.get(values.size() - 1).getValue();
        if (result.getDirection() == Query.SortDirection.DESCENDING) {
            result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.GREATER_THAN, first));
            for (int i = 1; i < values.size(); ++i) {
                Object prev = values.get(i - 1).getValue();
                Object next = values.get(i).getValue();
                result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.LESS_THAN, prev), new Query.FilterPredicate(propertyName, Query.FilterOperator.GREATER_THAN, next));
            }
            if (last != null) {
                result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.LESS_THAN, last));
            }
        } else {
            if (first != null) {
                result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.LESS_THAN, first));
            }
            for (int i = 1; i < values.size(); ++i) {
                Object prev = values.get(i - 1).getValue();
                Object next = values.get(i).getValue();
                result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.GREATER_THAN, prev), new Query.FilterPredicate(propertyName, Query.FilterOperator.LESS_THAN, next));
            }
            result.addFilters(new Query.FilterPredicate(propertyName, Query.FilterOperator.GREATER_THAN, last));
        }
        return result;
    }
}

