/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.datastore.v1.client;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.http.HttpRequestFactory;
import com.google.appengine.repackaged.com.google.api.client.http.HttpTransport;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.Datastore;
import com.google.appengine.repackaged.com.google.datastore.v1.client.DatastoreOptions;
import com.google.appengine.repackaged.com.google.datastore.v1.client.RemoteRpc;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class DatastoreFactory {
    private static ConsoleHandler methodHandler;
    public static final String VERSION = "v1";
    public static final String DEFAULT_HOST = "https://datastore.googleapis.com";
    private static final DatastoreFactory INSTANCE;

    public static DatastoreFactory get() {
        return INSTANCE;
    }

    public Datastore create(DatastoreOptions options) {
        return new Datastore(this.newRemoteRpc(options));
    }

    public HttpRequestFactory makeClient(DatastoreOptions options) {
        Credential credential = options.getCredential();
        HttpTransport transport = options.getTransport();
        if (transport == null) {
            transport = credential == null ? new NetHttpTransport() : credential.getTransport();
            transport = transport == null ? new NetHttpTransport() : transport;
        }
        return transport.createRequestFactory(credential);
    }

    public static void logMethodCalls() {
        Logger logger = Logger.getLogger(Datastore.class.getName());
        logger.setLevel(Level.FINE);
        if (!Arrays.asList(logger.getHandlers()).contains(DatastoreFactory.getStreamHandler())) {
            logger.addHandler(DatastoreFactory.getStreamHandler());
        }
    }

    String buildProjectEndpoint(DatastoreOptions options) {
        if (options.getProjectEndpoint() != null) {
            return options.getProjectEndpoint();
        }
        String projectId = Preconditions.checkNotNull(options.getProjectId());
        if (options.getHost() != null) {
            return DatastoreFactory.validateUrl(String.format("https://%s/%s/projects/%s", options.getHost(), VERSION, projectId));
        }
        if (options.getLocalHost() != null) {
            return DatastoreFactory.validateUrl(String.format("http://%s/%s/projects/%s", options.getLocalHost(), VERSION, projectId));
        }
        return DatastoreFactory.validateUrl(String.format("%s/%s/projects/%s", DEFAULT_HOST, VERSION, projectId));
    }

    protected RemoteRpc newRemoteRpc(DatastoreOptions options) {
        Preconditions.checkNotNull(options);
        HttpRequestFactory client = this.makeClient(options);
        return new RemoteRpc(client, options.getInitializer(), this.buildProjectEndpoint(options));
    }

    private static String validateUrl(String url) {
        try {
            return new URI(url).toString();
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static synchronized StreamHandler getStreamHandler() {
        if (methodHandler == null) {
            methodHandler = new ConsoleHandler();
            methodHandler.setFormatter(new Formatter(){

                @Override
                public String format(LogRecord record) {
                    return record.getMessage() + "\n";
                }
            });
            methodHandler.setLevel(Level.FINE);
        }
        return methodHandler;
    }

    static {
        INSTANCE = new DatastoreFactory();
    }
}

