/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.search.query;

import com.google.appengine.api.search.SearchQueryException;
import com.google.appengine.api.search.query.QueryTreeContext;
import com.google.appengine.api.search.query.QueryTreeException;
import com.google.appengine.api.search.query.QueryTreeVisitor;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.org.antlr.runtime.tree.Tree;

public class QueryTreeWalker<T extends QueryTreeContext<T>> {
    private final QueryTreeVisitor<T> visitor;
    private static final ImmutableSet<String> QUERY_FUNCTION_NAMES = ImmutableSet.of("distance", "geopoint");

    public QueryTreeWalker(QueryTreeVisitor<T> visitor) {
        this.visitor = visitor;
    }

    public void walk(Tree tree, T context) throws QueryTreeException {
        tree = QueryTreeWalker.flatten(tree, null);
        QueryTreeWalker.validate(tree);
        this.walkInternal(tree, context);
    }

    private void walkInternal(Tree tree, T context) {
        switch (tree.getType()) {
            case 8: {
                ((QueryTreeContext)context).setInDisjunction(false);
                this.walkChildren(tree, context);
                this.visitor.visitConjunction(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 10: {
                ((QueryTreeContext)context).setInDisjunction(true);
                this.walkChildren(tree, context);
                this.visitor.visitDisjunction(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 39: {
                ((QueryTreeContext)context).setInDisjunction(false);
                this.walkChildren(tree, context);
                this.visitor.visitSequence(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 31: {
                this.walkChildren(tree, context);
                this.visitor.visitNegation(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 22: {
                this.walkChildren(tree, context);
                this.visitor.visitContains(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 12: {
                this.walkChildren(tree, context);
                this.visitor.visitEqual(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 30: {
                throw new SearchQueryException("!= comparison operator is not available");
            }
            case 25: {
                this.walkChildren(tree, context);
                this.visitor.visitLessThan(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 24: {
                this.walkChildren(tree, context);
                this.visitor.visitLessOrEqual(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 21: {
                this.walkChildren(tree, context);
                this.visitor.visitGreaterThan(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 19: {
                this.walkChildren(tree, context);
                this.visitor.visitGreaterOrEqual(tree, context);
                this.postBooleanExpression(context);
                break;
            }
            case 18: {
                this.walkInternal(tree.getChild(0), context);
                this.visitor.visitFuzzy(tree, context);
                break;
            }
            case 26: {
                this.walkInternal(tree.getChild(0), context);
                this.visitor.visitLiteral(tree, context);
                break;
            }
            case 45: {
                this.visitor.visitValue(tree, context);
                break;
            }
            case 17: {
                this.walkChildren(tree.getChild(1), context);
                this.visitor.visitFunction(tree, context);
                break;
            }
            case 20: {
                this.visitor.visitGlobal(tree, context);
                break;
            }
            default: {
                this.visitor.visitOther(tree, context);
            }
        }
    }

    protected void postBooleanExpression(T context) {
        ((QueryTreeContext)context).setReturnType(QueryTreeContext.Type.BOOL);
        ((QueryTreeContext)context).setKind(QueryTreeContext.Kind.EXPRESSION);
    }

    private void walkChildren(Tree parent, T context) {
        for (int i = 0; i < parent.getChildCount(); ++i) {
            this.walkInternal(parent.getChild(i), ((QueryTreeContext)context).addChild());
        }
    }

    private static void validate(Tree tree) throws QueryTreeException {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            QueryTreeWalker.validate(tree.getChild(i));
        }
        switch (tree.getType()) {
            case 17: {
                Tree name = tree.getChild(0);
                if (QUERY_FUNCTION_NAMES.contains(name.getText())) break;
                throw new QueryTreeException("unknown function '" + name.getText() + "'", name.getCharPositionInLine());
            }
        }
    }

    public static Tree simplify(Tree tree) {
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree optimized;
            Tree child = tree.getChild(i);
            if (child == (optimized = QueryTreeWalker.simplify(child))) continue;
            tree.setChild(i, optimized);
        }
        switch (tree.getType()) {
            case 8: 
            case 10: 
            case 39: {
                if (tree.getChildCount() != 1) break;
                return tree.getChild(0);
            }
        }
        return tree;
    }

    private static Tree flatten(Tree tree, Tree restriction) throws QueryTreeException {
        if (tree.getType() == 45) {
            return tree;
        }
        if (tree.getType() == 22 || tree.getType() == 12) {
            Tree rhs;
            Tree flattened;
            Tree lhs = tree.getChild(0);
            if (lhs.getType() == 45) {
                String myField = lhs.getChild(1).getText();
                if (restriction == null) {
                    restriction = lhs;
                } else {
                    String otherField = restriction.getChild(1).getText();
                    if (!myField.equals(otherField)) {
                        throw new QueryTreeException(String.format("Restriction on %s and %s", otherField, myField), lhs.getChild(1).getCharPositionInLine());
                    }
                }
            }
            if ((flattened = QueryTreeWalker.flatten(rhs = tree.getChild(1), restriction)).getType() == 22 || flattened.getType() == 12 || flattened.getType() == 8 || flattened.getType() == 10 || flattened.getType() == 39) {
                return flattened;
            }
            if (flattened != rhs) {
                tree.setChild(1, flattened);
            }
            if (restriction != lhs) {
                tree.setChild(0, restriction);
            }
            return tree;
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            Tree flattened;
            Tree original = tree.getChild(i);
            if (original == (flattened = QueryTreeWalker.flatten(tree.getChild(i), restriction))) continue;
            tree.setChild(i, flattened);
        }
        return tree;
    }
}

