/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.labs.datastore.overlay;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.datastore.AsyncDatastoreService;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.IDatastoreServiceFactory;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.labs.datastore.overlay.LazyAsyncDatastoreServiceAdapter;
import com.google.appengine.api.labs.datastore.overlay.NamespacePinnedAsyncDatastoreServiceImpl;
import com.google.appengine.api.labs.datastore.overlay.OverlayAsyncDatastoreService;
import com.google.appengine.api.labs.datastore.overlay.OverlayAsyncDatastoreServiceImpl;
import com.google.appengine.api.labs.datastore.overlay.OverlayDatastoreService;
import com.google.appengine.api.labs.datastore.overlay.SyncDatastoreServiceAdapter;
import com.google.appengine.api.labs.datastore.overlay.SyncOverlayDatastoreServiceAdapter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import java.util.concurrent.ThreadLocalRandom;

public final class OverlayDatastoreServiceFactory {
    private final IDatastoreServiceFactory baseFactory;
    private final NameFactory nameFactory;
    private static final String OVERLAY_METADATA_NAMESPACE = "_overlay_";
    private static final String OVERLAY_KIND = "_overlay_";

    public OverlayDatastoreServiceFactory() {
        this(new IDatastoreServiceFactory(){

            public DatastoreService getDatastoreService(DatastoreServiceConfig config) {
                return DatastoreServiceFactory.getDatastoreService((DatastoreServiceConfig)config);
            }

            public AsyncDatastoreService getAsyncDatastoreService(DatastoreServiceConfig config) {
                return DatastoreServiceFactory.getAsyncDatastoreService((DatastoreServiceConfig)config);
            }
        });
    }

    OverlayDatastoreServiceFactory(IDatastoreServiceFactory baseFactory) {
        this(baseFactory, new NameFactory());
    }

    OverlayDatastoreServiceFactory(IDatastoreServiceFactory baseFactory, NameFactory nameFactory) {
        this.baseFactory = baseFactory;
        this.nameFactory = nameFactory;
    }

    public OverlayDatastoreService createOverlayDatastoreService(DatastoreServiceConfig config) {
        Preconditions.checkNotNull(config);
        return this.createOverlayDatastoreService(this.baseFactory.getAsyncDatastoreService(config));
    }

    public OverlayDatastoreService createOverlayDatastoreService() {
        return this.createOverlayDatastoreService(this.baseFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDefaults()));
    }

    public OverlayDatastoreService createOverlayDatastoreService(String name) {
        return this.createOverlayDatastoreService(this.baseFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDefaults()), name);
    }

    public OverlayDatastoreService createOverlayDatastoreService(AsyncDatastoreService datastore) {
        Preconditions.checkNotNull(datastore);
        return new SyncOverlayDatastoreServiceAdapter(this.createOverlayAsyncDatastoreService(datastore));
    }

    public OverlayDatastoreService createOverlayDatastoreService(DatastoreService datastore) {
        Preconditions.checkNotNull(datastore);
        return this.createOverlayDatastoreService(new LazyAsyncDatastoreServiceAdapter(datastore));
    }

    public OverlayDatastoreService createOverlayDatastoreService(AsyncDatastoreService datastore, String name) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        return new SyncOverlayDatastoreServiceAdapter(this.createOverlayAsyncDatastoreService(datastore, name));
    }

    public OverlayDatastoreService createOverlayDatastoreService(DatastoreService datastore, String name) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        return this.createOverlayDatastoreService(new LazyAsyncDatastoreServiceAdapter(datastore), name);
    }

    public OverlayDatastoreService createOverlayDatastoreService(AsyncDatastoreService datastore, String name, boolean create) throws IllegalStateException {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        return new SyncOverlayDatastoreServiceAdapter(this.createOverlayAsyncDatastoreService(datastore, name, create));
    }

    public OverlayDatastoreService createOverlayDatastoreService(DatastoreService datastore, String name, boolean create) throws IllegalStateException {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        return this.createOverlayDatastoreService(new LazyAsyncDatastoreServiceAdapter(datastore), name, create);
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService(DatastoreServiceConfig config) {
        Preconditions.checkNotNull(config);
        return this.createOverlayAsyncDatastoreService(this.baseFactory.getAsyncDatastoreService(config));
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService() {
        return this.createOverlayAsyncDatastoreService(this.baseFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDefaults()));
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService(String name) {
        return this.createOverlayAsyncDatastoreService(this.baseFactory.getAsyncDatastoreService(DatastoreServiceConfig.Builder.withDefaults()), name);
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService(AsyncDatastoreService datastore) {
        Preconditions.checkNotNull(datastore);
        String name = this.getUniqueOverlayName(new SyncDatastoreServiceAdapter(datastore));
        return this.createOverlayAsyncDatastoreService(datastore, name);
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService(AsyncDatastoreService datastore, String name) {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        try {
            return this.createOverlayAsyncDatastoreService(datastore, name, true);
        }
        catch (IllegalStateException e) {
            throw new AssertionError("Unexpected IllegalStateException on overlay creation when create=true.", e);
        }
    }

    public OverlayAsyncDatastoreService createOverlayAsyncDatastoreService(AsyncDatastoreService datastore, String name, boolean create) throws IllegalStateException {
        Preconditions.checkNotNull(datastore);
        Preconditions.checkNotNull(name);
        SyncDatastoreServiceAdapter syncWrappedDatastore = new SyncDatastoreServiceAdapter(datastore);
        if (!OverlayDatastoreServiceFactory.overlayExists(syncWrappedDatastore, name, null)) {
            if (create) {
                OverlayDatastoreServiceFactory.registerOverlay(syncWrappedDatastore, name, null);
            } else {
                throw new IllegalStateException(new StringBuilder(26 + String.valueOf(name).length()).append("Overlay \"").append(name).append("\" does not exist.").toString());
            }
        }
        return new OverlayAsyncDatastoreServiceImpl(name, new NamespacePinnedAsyncDatastoreServiceImpl(datastore, OverlayDatastoreServiceFactory.getOverlayNamespace(name), true), datastore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getUniqueOverlayName(DatastoreService datastore) {
        while (true) {
            Transaction txn = datastore.beginTransaction();
            try {
                String name = this.nameFactory.getRandomName();
                if (OverlayDatastoreServiceFactory.overlayExists(datastore, name, txn)) continue;
                OverlayDatastoreServiceFactory.registerOverlay(datastore, name, txn);
                txn.commit();
                String string = name;
                return string;
            }
            finally {
                if (!txn.isActive()) continue;
                txn.rollback();
                continue;
            }
            break;
        }
    }

    private static String getOverlayNamespace(String suffix) {
        String string = String.valueOf("_overlay_");
        String string2 = String.valueOf(suffix);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void registerOverlay(DatastoreService datastore, String name, Transaction txn) {
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"_overlay_");
            Entity entity = new Entity("_overlay_", name);
            datastore.put(txn, entity);
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean overlayExists(DatastoreService datastore, String overlayName, Transaction txn) {
        String currentNamespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"_overlay_");
            Key key = KeyFactory.createKey((String)"_overlay_", (String)overlayName);
            datastore.get(txn, key);
            boolean bl = true;
            return bl;
        }
        catch (EntityNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            NamespaceManager.set((String)currentNamespace);
        }
    }

    static class NameFactory {
        private static final char[] ALPHA_NUMERIC_CHARS = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789".toCharArray();
        private static final int RANDOM_NAME_LENGTH = 8;

        NameFactory() {
        }

        public String getRandomName() {
            char[] buf = new char[8];
            ThreadLocalRandom random = ThreadLocalRandom.current();
            for (int i = 0; i < 8; ++i) {
                buf[i] = ALPHA_NUMERIC_CHARS[random.nextInt(ALPHA_NUMERIC_CHARS.length)];
            }
            return new String(buf);
        }
    }
}

