/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import java.util.Arrays;

final class Int2ObjectHashMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private static final Int2ObjectHashMap<Object> EMPTY_INSTANCE = new Int2ObjectHashMap(true);
    private int maxSize;
    private final float loadFactor;
    private int[] keys;
    private V[] values;
    private int size;
    private int mask;

    static <V> Int2ObjectHashMap<V> getEmptyInstance() {
        return EMPTY_INSTANCE;
    }

    public Int2ObjectHashMap() {
        this(8, 0.5f);
    }

    public Int2ObjectHashMap(int initialCapacity) {
        this(initialCapacity, 0.5f);
    }

    public Int2ObjectHashMap(int initialCapacity, float loadFactor) {
        if (initialCapacity < 1) {
            throw new IllegalArgumentException("initialCapacity must be >= 1");
        }
        if (loadFactor <= 0.0f || loadFactor > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = loadFactor;
        int capacity = Int2ObjectHashMap.findNextPositivePowerOfTwo(initialCapacity);
        this.mask = capacity - 1;
        this.keys = new int[capacity];
        Object[] temp = new Object[capacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(capacity);
    }

    private Int2ObjectHashMap(boolean immutable) {
        this.loadFactor = 0.5f;
        this.keys = null;
        this.values = null;
    }

    private void assertMutable() {
        if (this.keys == null) {
            throw new IllegalStateException("Trying to modify an immutable map.");
        }
    }

    private static <T> T toExternal(T value) {
        return value == NULL_VALUE ? null : (T)value;
    }

    private static <T> T toInternal(T value) {
        return (T)(value == null ? NULL_VALUE : value);
    }

    public V get(int key) {
        if (this.keys == null) {
            return null;
        }
        int index = this.indexOf(key);
        return index == -1 ? null : (V)Int2ObjectHashMap.toExternal(this.values[index]);
    }

    public V put(int key, V value) {
        int startIndex;
        this.assertMutable();
        int index = startIndex = this.hashIndex(key);
        do {
            if (this.values[index] == null) {
                this.keys[index] = key;
                this.values[index] = Int2ObjectHashMap.toInternal(value);
                this.growSize();
                return null;
            }
            if (this.keys[index] != key) continue;
            V previousValue = this.values[index];
            this.values[index] = Int2ObjectHashMap.toInternal(value);
            return Int2ObjectHashMap.toExternal(previousValue);
        } while ((index = this.probeNext(index)) != startIndex);
        throw new IllegalStateException("Unable to insert");
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void clear() {
        this.assertMutable();
        Arrays.fill(this.keys, 0);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    public boolean containsKey(int key) {
        return this.indexOf(key) >= 0;
    }

    public boolean containsValue(Object value) {
        Object v1 = Int2ObjectHashMap.toInternal(value);
        for (V v2 : this.values) {
            if (v2 == null || !v2.equals(v1)) continue;
            return true;
        }
        return false;
    }

    private int indexOf(int key) {
        int startIndex;
        int index = startIndex = this.hashIndex(key);
        do {
            if (this.values[index] == null) {
                return -1;
            }
            if (key != this.keys[index]) continue;
            return index;
        } while ((index = this.probeNext(index)) != startIndex);
        return -1;
    }

    private int hashIndex(int key) {
        return Int2ObjectHashMap.hashCode(key) & this.mask;
    }

    private static int hashCode(int key) {
        return key;
    }

    private int probeNext(int index) {
        return index + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                int n = this.size;
                throw new IllegalStateException(new StringBuilder(40).append("Max capacity reached at size=").append(n).toString());
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private int calcMaxSize(int capacity) {
        int upperBound = capacity - 1;
        return Math.min(upperBound, (int)((float)capacity * this.loadFactor));
    }

    private void rehash(int newCapacity) {
        int[] oldKeys = this.keys;
        V[] oldVals = this.values;
        this.keys = new int[newCapacity];
        Object[] temp = new Object[newCapacity];
        this.values = temp;
        this.maxSize = this.calcMaxSize(newCapacity);
        this.mask = newCapacity - 1;
        block0: for (int i = 0; i < oldVals.length; ++i) {
            V oldVal = oldVals[i];
            if (oldVal == null) continue;
            int oldKey = oldKeys[i];
            int index = this.hashIndex(oldKey);
            while (true) {
                if (this.values[index] == null) {
                    this.keys[index] = oldKey;
                    this.values[index] = oldVal;
                    continue block0;
                }
                index = this.probeNext(index);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder(4 * this.size);
        sb.append('{');
        boolean first = true;
        for (int i = 0; i < this.values.length; ++i) {
            V value = this.values[i];
            if (value == null) continue;
            if (!first) {
                sb.append(", ");
            }
            sb.append(this.keyToString(this.keys[i])).append('=').append((Object)(value == this ? "(this Map)" : Int2ObjectHashMap.toExternal(value)));
            first = false;
        }
        return sb.append('}').toString();
    }

    protected String keyToString(int key) {
        return Integer.toString(key);
    }

    private static int findNextPositivePowerOfTwo(int value) {
        if (value == Integer.MIN_VALUE) {
            throw new IllegalArgumentException(String.format("value (%s) cannot be Integer.MIN_VALUE", value));
        }
        if (value >= 0x40000000) {
            throw new IllegalArgumentException(String.format("value (%s) cannot be >= 2^30", value));
        }
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }
}

