/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.appstats;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Maps;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.tools.appstats.StatsProtos;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

class StatsUtil {
    private static final double MCYCLES_PER_SECOND = 1200.0;
    private static final BigDecimal ONE_HUNDRED = new BigDecimal(100);
    private static final Comparator<List<Object>> BY_FIRST_ELEMENT = StatsUtil.makeComparator(0, 1, 2);
    private static final Comparator<List<Object>> BY_SECOND_ELEMENT = StatsUtil.makeComparator(1, 0, 2);
    private static final Comparator<Map.Entry<String, ? extends BaseStats>> BY_NUM_RPCS = new Comparator<Map.Entry<String, ? extends BaseStats>>(){

        @Override
        public int compare(Map.Entry<String, ? extends BaseStats> o1, Map.Entry<String, ? extends BaseStats> o2) {
            int c = -o1.getValue().numRpcs.compareTo(o2.getValue().numRpcs);
            if (c == 0) {
                c = o1.getKey().compareTo(o2.getKey());
            }
            return c;
        }
    };

    private StatsUtil() {
    }

    private static String extractKey(StatsProtos.RequestStatProto summary) {
        String result = summary.getHttpPath();
        if (!summary.getHttpMethod().equals("GET")) {
            String string = summary.getHttpMethod();
            String string2 = result;
            result = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" ").append(string2).toString();
        }
        return result;
    }

    static long megaCyclesToMilliseconds(long megaCycles) {
        return (long)((double)(1000L * megaCycles) / 1200.0);
    }

    private static Map<String, Object> toMap(Message proto) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Descriptors.FieldDescriptor field : proto.getDescriptorForType().getFields()) {
            Object value = proto.getField(field);
            if (value == null) continue;
            result.put(field.getName(), value);
            if (!(value instanceof List)) continue;
            result.put(String.valueOf(field.getName()).concat("_list"), value);
            result.put(String.valueOf(field.getName()).concat("_size"), ((List)value).size());
        }
        return result;
    }

    private static Map<String, Object> augmentProto(StatsProtos.RequestStatProto proto) {
        List<StatsProtos.IndividualRpcStatsProto> individualRpcs = proto.getIndividualStatsList();
        Map<String, Object> result = StatsUtil.toMap(proto);
        result.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getApiMcycles()));
        result.put("processor_milliseconds", StatsUtil.megaCyclesToMilliseconds(proto.getProcessorMcycles()));
        result.put("start_time_formatted", new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS").format(new Date(proto.getStartTimestampMilliseconds())));
        ArrayList<Map<String, Object>> sublist = new ArrayList<Map<String, Object>>();
        BilledOpMap cumulativeBilledOpMap = new BilledOpMap();
        for (StatsProtos.IndividualRpcStatsProto stat : individualRpcs) {
            Map<String, Object> subMap = StatsUtil.toMap(stat);
            subMap.put("api_milliseconds", StatsUtil.megaCyclesToMilliseconds(stat.getApiMcycles()));
            BilledOpMap bopMap = new BilledOpMap();
            StatsUtil.updateBilledOps(bopMap, stat.getBilledOpsList());
            subMap.put("billed_ops_str", bopMap.toString());
            sublist.add(subMap);
        }
        result.put("individual_stats", sublist);
        result.put("individual_stats_list", sublist);
        long count = 0L;
        long costInMicropennies = 0L;
        ArrayList<Map<String, Object>> aggregateStatsList = new ArrayList<Map<String, Object>>();
        for (StatsProtos.AggregateRpcStatsProto stat : proto.getRpcStatsList()) {
            Map<String, Object> aggregateStatMap = StatsUtil.toMap(stat);
            aggregateStatsList.add(aggregateStatMap);
            count += stat.getTotalAmountOfCalls();
            costInMicropennies += stat.getTotalCostOfCallsMicrodollars();
            BilledOpMap bopMap = new BilledOpMap();
            StatsUtil.updateBilledOps(bopMap, stat.getTotalBilledOpsList());
            StatsUtil.updateBilledOps(cumulativeBilledOpMap, stat.getTotalBilledOpsList());
            aggregateStatMap.put("total_billed_ops_str", bopMap.toString());
        }
        result.put("rpc_stats_list", aggregateStatsList);
        result.put("combined_rpc_count", count);
        result.put("combined_rpc_cost_micropennies", costInMicropennies);
        result.put("combined_rpc_billed_ops", cumulativeBilledOpMap);
        return result;
    }

    private static List<List<Object>> asTupleOrderedByNumRpcs(Map<String, ? extends BaseStats> elements, BigDecimal totalRpcCostsMicropennies) {
        ArrayList<Map.Entry<String, ? extends BaseStats>> sorted = new ArrayList<Map.Entry<String, ? extends BaseStats>>(elements.entrySet());
        Collections.sort(sorted, BY_NUM_RPCS);
        ArrayList<List<Object>> result = new ArrayList<List<Object>>(sorted.size());
        for (Map.Entry entry : sorted) {
            BaseStats baseStats = (BaseStats)entry.getValue();
            result.add(Arrays.asList(entry.getKey(), baseStats.numRpcs, baseStats.rpcCostMicropennies, baseStats.billedOps, StatsUtil.asPercentageOf(baseStats.rpcCostMicropennies, totalRpcCostsMicropennies)));
        }
        return result;
    }

    static double asPercentageOf(long costMicropennies, BigDecimal totalCostMicropennies) {
        return totalCostMicropennies.longValue() == 0L ? 0.0 : new BigDecimal(costMicropennies).divide(totalCostMicropennies, 3, RoundingMode.HALF_UP).multiply(ONE_HUNDRED).setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    private static Comparator<List<Object>> makeComparator(final int ... fieldOrder) {
        return new Comparator<List<Object>>(){

            @Override
            public int compare(List<Object> o1, List<Object> o2) {
                int result = 0;
                for (int i : fieldOrder) {
                    Comparable c1 = (Comparable)o1.get(i);
                    Comparable c2 = (Comparable)o2.get(i);
                    int n = result = c1 instanceof Number ? -c1.compareTo(c2) : c1.compareTo(c2);
                    if (result == 0) continue;
                    return result;
                }
                return result;
            }
        };
    }

    static Map<String, Object> createSummaryStats(List<StatsProtos.RequestStatProto> records) {
        records = new ArrayList<StatsProtos.RequestStatProto>(records);
        Collections.sort(records, new Comparator<StatsProtos.RequestStatProto>(){

            @Override
            public int compare(StatsProtos.RequestStatProto o1, StatsProtos.RequestStatProto o2) {
                Long l1 = o1.getStartTimestampMilliseconds();
                Long l2 = o2.getStartTimestampMilliseconds();
                return -l1.compareTo(l2);
            }
        });
        ArrayList<Map<String, Object>> augmented = new ArrayList<Map<String, Object>>(records.size());
        for (StatsProtos.RequestStatProto proto : records) {
            augmented.add(StatsUtil.augmentProto(proto));
        }
        HashMap<String, PathStats> statsByPath = new HashMap<String, PathStats>();
        HashMap<String, RpcStats> statsByRpc = new HashMap<String, RpcStats>();
        BigDecimal totalCostMicropennies = new BigDecimal(0);
        for (int i = 0; i < records.size(); ++i) {
            StatsProtos.RequestStatProto requestStat = records.get(i);
            String pathKey = StatsUtil.extractKey(requestStat);
            PathStats pathStats = (PathStats)statsByPath.get(pathKey);
            if (pathStats == null) {
                pathStats = new PathStats(pathKey);
                statsByPath.put(pathKey, pathStats);
            }
            if (pathStats.requestIds.size() >= 10) {
                if ((Integer)pathStats.requestIds.get(pathStats.requestIds.size() - 1) != 0) {
                    pathStats.requestIds.add(0);
                }
            } else {
                pathStats.requestIds.add(i + 1);
            }
            for (StatsProtos.AggregateRpcStatsProto aggregateStat : requestStat.getRpcStatsList()) {
                String rpcKey = aggregateStat.getServiceCallName();
                long totalCalls = aggregateStat.getTotalAmountOfCalls();
                long costMicropennies = aggregateStat.getTotalCostOfCallsMicrodollars();
                totalCostMicropennies = totalCostMicropennies.add(new BigDecimal(costMicropennies));
                RpcStats rpcStats = (RpcStats)statsByRpc.get(rpcKey);
                if (rpcStats == null) {
                    rpcStats = new RpcStats(rpcKey);
                    statsByRpc.put(rpcKey, rpcStats);
                }
                BaseStats baseStats = pathStats;
                Long.valueOf(baseStats.numRpcs + totalCalls);
                baseStats.numRpcs = baseStats.numRpcs;
                pathStats.rpcCostMicropennies += costMicropennies;
                baseStats = rpcStats;
                Long.valueOf(((RpcStats)baseStats).numRpcs + totalCalls);
                ((RpcStats)baseStats).numRpcs = ((RpcStats)baseStats).numRpcs;
                rpcStats.rpcCostMicropennies += costMicropennies;
                RpcStats rpcStatsForPath = (RpcStats)pathStats.rpcStats.get(rpcKey);
                if (rpcStatsForPath == null) {
                    rpcStatsForPath = new RpcStats(rpcKey);
                    pathStats.rpcStats.put(rpcKey, rpcStatsForPath);
                }
                RpcStats rpcStats2 = rpcStatsForPath;
                Long.valueOf(rpcStats2.numRpcs + totalCalls);
                rpcStats2.numRpcs = rpcStats2.numRpcs;
                rpcStatsForPath.rpcCostMicropennies += costMicropennies;
                PathStats pathStatsForRpc = (PathStats)rpcStats.pathStats.get(pathKey);
                if (pathStatsForRpc == null) {
                    pathStatsForRpc = new PathStats(pathKey);
                    rpcStats.pathStats.put(pathKey, pathStatsForRpc);
                }
                PathStats pathStats2 = pathStatsForRpc;
                Long.valueOf(pathStats2.numRpcs + totalCalls);
                pathStats2.numRpcs = pathStats2.numRpcs;
                pathStatsForRpc.rpcCostMicropennies += costMicropennies;
                StatsUtil.updateBilledOps(pathStats.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(rpcStats.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(rpcStatsForPath.billedOps, aggregateStat.getTotalBilledOpsList());
                StatsUtil.updateBilledOps(pathStatsForRpc.billedOps, aggregateStat.getTotalBilledOpsList());
            }
        }
        ArrayList rpcStatsTuples = new ArrayList();
        for (RpcStats rpcStats : statsByRpc.values()) {
            List<List<Object>> pathStatsTupleOrderedByRpc = StatsUtil.asTupleOrderedByNumRpcs(rpcStats.pathStats, totalCostMicropennies);
            ArrayList rpcStatTuple = new ArrayList();
            Collections.addAll(rpcStatTuple, rpcStats.rpcName, rpcStats.numRpcs, rpcStats.rpcCostMicropennies, rpcStats.billedOps, StatsUtil.asPercentageOf(rpcStats.rpcCostMicropennies, totalCostMicropennies), pathStatsTupleOrderedByRpc);
            rpcStatsTuples.add(rpcStatTuple);
        }
        Collections.sort(rpcStatsTuples, BY_FIRST_ELEMENT);
        ArrayList rpcStatsTuplesOrderedByRpcCount = new ArrayList(rpcStatsTuples);
        Collections.sort(rpcStatsTuplesOrderedByRpcCount, BY_SECOND_ELEMENT);
        ArrayList pathStatsTuples = new ArrayList();
        for (PathStats pathStats : statsByPath.values()) {
            List<List<Object>> rpcStatsTupleOrderedByPath = StatsUtil.asTupleOrderedByNumRpcs(pathStats.rpcStats, totalCostMicropennies);
            long rpcCount = 0L;
            long rpcCostMicropennies = 0L;
            for (List<Object> rpcStatsTuple : rpcStatsTupleOrderedByPath) {
                rpcCount += ((Long)rpcStatsTuple.get(1)).longValue();
                rpcCostMicropennies += ((Long)rpcStatsTuple.get(2)).longValue();
            }
            ArrayList pathStatTuple = new ArrayList();
            Collections.addAll(pathStatTuple, pathStats.path, rpcCount, rpcCostMicropennies, pathStats.billedOps, StatsUtil.asPercentageOf(rpcCostMicropennies, totalCostMicropennies), pathStats.requestIds.size(), pathStats.requestIds, rpcStatsTupleOrderedByPath);
            pathStatsTuples.add(pathStatTuple);
        }
        Collections.sort(pathStatsTuples, BY_FIRST_ELEMENT);
        ArrayList pathStatsTuplesOrderedByRpcCount = new ArrayList(pathStatsTuples);
        Collections.sort(pathStatsTuplesOrderedByRpcCount, BY_SECOND_ELEMENT);
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("requests", augmented);
        values.put("allstats_by_count", rpcStatsTuplesOrderedByRpcCount);
        values.put("pathstats_by_count", pathStatsTuplesOrderedByRpcCount);
        values.put("has_cost_data", Boolean.TRUE);
        return values;
    }

    static Map<String, Object> createDetailedStats(StatsProtos.RequestStatProto data) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("record", StatsUtil.augmentProto(data));
        parameters.put("file_url", false);
        HashMap<String, DetailedRpcStats> statsByRpc = new HashMap<String, DetailedRpcStats>();
        for (StatsProtos.IndividualRpcStatsProto rpcStat : data.getIndividualStatsList()) {
            String rpcName = rpcStat.getServiceCallName();
            DetailedRpcStats statsForRpc = (DetailedRpcStats)statsByRpc.get(rpcName);
            if (statsForRpc == null) {
                statsForRpc = new DetailedRpcStats(rpcName);
                statsByRpc.put(rpcName, statsForRpc);
            }
            DetailedRpcStats detailedRpcStats = statsForRpc;
            Long l = detailedRpcStats.numRpcs;
            Long l2 = detailedRpcStats.numRpcs = Long.valueOf(detailedRpcStats.numRpcs + 1L);
            statsForRpc.durationMillis += rpcStat.getDurationMilliseconds();
            statsForRpc.apiMcycles += rpcStat.getApiMcycles();
            statsForRpc.rpcCostMicropennies += rpcStat.getCallCostMicrodollars();
            StatsUtil.updateBilledOps(statsForRpc.billedOps, rpcStat.getBilledOpsList());
        }
        ArrayList rpcStatsSortedByCount = new ArrayList();
        for (Map.Entry entry : statsByRpc.entrySet()) {
            ArrayList tuple = new ArrayList();
            tuple.add(entry.getKey());
            DetailedRpcStats detailedStats = (DetailedRpcStats)entry.getValue();
            Collections.addAll(tuple, detailedStats.numRpcs, detailedStats.durationMillis, StatsUtil.megaCyclesToMilliseconds(detailedStats.apiMcycles), detailedStats.rpcCostMicropennies, detailedStats.billedOps);
            rpcStatsSortedByCount.add(tuple);
        }
        Collections.sort(rpcStatsSortedByCount, BY_SECOND_ELEMENT);
        parameters.put("rpcstats_by_count", rpcStatsSortedByCount);
        long realTotal = 0L;
        long apiTotalMcycles = 0L;
        for (StatsProtos.IndividualRpcStatsProto stat : data.getIndividualStatsList()) {
            realTotal += stat.getDurationMilliseconds();
            apiTotalMcycles += stat.getApiMcycles();
        }
        long apiTotal = StatsUtil.megaCyclesToMilliseconds(apiTotalMcycles);
        long chargedTotal = StatsUtil.megaCyclesToMilliseconds(data.getProcessorMcycles() + apiTotalMcycles);
        parameters.put("real_total", realTotal);
        parameters.put("api_total", apiTotal);
        parameters.put("charged_total", chargedTotal);
        parameters.put("has_cost_data", Boolean.TRUE);
        return parameters;
    }

    private static Map<StatsProtos.BilledOpProto.BilledOp, Integer> updateBilledOps(Map<StatsProtos.BilledOpProto.BilledOp, Integer> billedOps, List<StatsProtos.BilledOpProto> billedOpsList) {
        for (StatsProtos.BilledOpProto proto : billedOpsList) {
            if (billedOps.get(proto.getOp()) == null) {
                billedOps.put(proto.getOp(), 0);
            }
            billedOps.put(proto.getOp(), billedOps.get(proto.getOp()) + proto.getNumOps());
        }
        return billedOps;
    }

    private static final class BilledOpMap
    extends TreeMap<StatsProtos.BilledOpProto.BilledOp, Integer> {
        private BilledOpMap() {
        }

        @Override
        public String toString() {
            return Joiner.on(", ").join(Iterables.transform(this.entrySet(), new Function<Map.Entry<StatsProtos.BilledOpProto.BilledOp, Integer>, String>(this){

                @Override
                public String apply(Map.Entry<StatsProtos.BilledOpProto.BilledOp, Integer> entry) {
                    return String.format("%s:%d", entry.getKey(), entry.getValue());
                }
            }));
        }
    }

    private static class DetailedRpcStats
    extends RpcStats {
        long durationMillis;
        long apiMcycles;

        private DetailedRpcStats(String rpcName) {
            super(rpcName);
        }
    }

    private static class RpcStats
    extends BaseStats {
        private final String rpcName;
        private final Map<String, PathStats> pathStats = Maps.newHashMap();

        private RpcStats(String rpcName) {
            this.rpcName = rpcName;
        }
    }

    private static class PathStats
    extends BaseStats {
        private final String path;
        private final List<Integer> requestIds = new ArrayList<Integer>();
        private final Map<String, RpcStats> rpcStats = Maps.newHashMap();

        private PathStats(String path) {
            this.path = path;
        }
    }

    private static class BaseStats {
        Long numRpcs = 0L;
        long rpcCostMicropennies;
        final Map<StatsProtos.BilledOpProto.BilledOp, Integer> billedOps = new BilledOpMap();

        private BaseStats() {
        }
    }
}

