/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.benchmark;

import java.io.File;
import java.net.URL;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpVersion;
import org.apache.commons.httpclient.contrib.benchmark.BenchmarkWorker;
import org.apache.commons.httpclient.contrib.benchmark.Stats;
import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
import org.apache.commons.httpclient.methods.FileRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;

public class HttpBenchmark {
    private static HttpClient createRequestExecutor() {
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setVersion(HttpVersion.HTTP_1_1);
        httpClient.getParams().setBooleanParameter("http.protocol.expect-continue", false);
        httpClient.getHttpConnectionManager().getParams().setStaleCheckingEnabled(false);
        return httpClient;
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        PosixParser posixParser;
        CommandLine commandLine;
        Option option = new Option("i", false, "Do HEAD requests instead of GET.");
        option.setRequired(false);
        Option option2 = new Option("k", false, "Enable the HTTP KeepAlive feature, i.e., perform multiple requests within one HTTP session. Default is no KeepAlive");
        option2.setRequired(false);
        Option option3 = new Option("n", true, "Number of requests to perform for the benchmarking session. The default is to just perform a single request which usually leads to non-representative benchmarking results.");
        option3.setRequired(false);
        option3.setArgName("requests");
        Option option4 = new Option("p", true, "File containing data to POST.");
        option4.setRequired(false);
        option4.setArgName("POST-file");
        Option option5 = new Option("T", true, "Content-type header to use for POST data.");
        option5.setRequired(false);
        option5.setArgName("content-type");
        Option option6 = new Option("v", true, "Set verbosity level - 4 and above prints information on headers, 3 and above prints response codes (404, 200, etc.), 2 and above prints warnings and info.");
        option6.setRequired(false);
        option6.setArgName("verbosity");
        Option option7 = new Option("h", false, "Display usage information.");
        option3.setRequired(false);
        Options options = new Options();
        options.addOption(option);
        options.addOption(option2);
        options.addOption(option3);
        options.addOption(option4);
        options.addOption(option5);
        options.addOption(option6);
        options.addOption(option7);
        if (stringArray.length == 0) {
            HttpBenchmark.showUsage(options);
            System.exit(1);
        }
        if ((commandLine = (posixParser = new PosixParser()).parse(options, stringArray)).hasOption('h')) {
            HttpBenchmark.showUsage(options);
            System.exit(1);
        }
        int n = 0;
        if (commandLine.hasOption('v')) {
            String string = commandLine.getOptionValue('v');
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid verbosity level: " + string);
                HttpBenchmark.showUsage(options);
                System.exit(-1);
            }
        }
        boolean bl = false;
        if (commandLine.hasOption('k')) {
            bl = true;
        }
        int n2 = 1;
        if (commandLine.hasOption('n')) {
            object4 = commandLine.getOptionValue('n');
            try {
                n2 = Integer.parseInt((String)object4);
            }
            catch (NumberFormatException numberFormatException) {
                System.err.println("Invalid number of requests: " + (String)object4);
                HttpBenchmark.showUsage(options);
                System.exit(-1);
            }
        }
        if ((stringArray = commandLine.getArgs()).length != 1) {
            HttpBenchmark.showUsage(options);
            System.exit(-1);
        }
        object4 = new URL(stringArray[0]);
        HostConfiguration hostConfiguration = new HostConfiguration();
        hostConfiguration.setHost(((URL)object4).getHost(), ((URL)object4).getPort(), ((URL)object4).getProtocol());
        Object object5 = null;
        if (commandLine.hasOption('p')) {
            object3 = new PostMethod(((URL)object4).getPath());
            object2 = new File(commandLine.getOptionValue('p'));
            if (!((File)object2).exists()) {
                System.err.println("File not found: " + object2);
                System.exit(-1);
            }
            object = null;
            if (commandLine.hasOption('T')) {
                object = commandLine.getOptionValue('T');
            }
            FileRequestEntity fileRequestEntity = new FileRequestEntity((File)object2, (String)object);
            ((EntityEnclosingMethod)object3).setRequestEntity(fileRequestEntity);
            if (((File)object2).length() > 100000L) {
                ((EntityEnclosingMethod)object3).setContentChunked(true);
            }
            object5 = object3;
        } else {
            object5 = commandLine.hasOption('i') ? (object3 = new HeadMethod(((URL)object4).getPath())) : (object3 = new GetMethod(((URL)object4).getPath()));
        }
        if (!bl) {
            object5.addRequestHeader("Connection", "close");
        }
        object3 = HttpBenchmark.createRequestExecutor();
        object2 = new BenchmarkWorker((HttpClient)object3, n);
        object = ((BenchmarkWorker)object2).execute(hostConfiguration, (HttpMethod)object5, n2, bl);
        float f = (float)((Stats)object).getDuration() / 1000.0f;
        float f2 = (float)((Stats)object).getSuccessCount() / f;
        float f3 = (float)((Stats)object).getDuration() / (float)((Stats)object).getSuccessCount();
        System.out.print("Server Software:\t");
        System.out.println(((Stats)object).getServerName());
        System.out.print("Server Hostname:\t");
        System.out.println(hostConfiguration.getHost());
        System.out.print("Server Port:\t\t");
        if (hostConfiguration.getPort() > 0) {
            System.out.println(hostConfiguration.getPort());
        } else {
            System.out.println(hostConfiguration.getProtocol().getDefaultPort());
        }
        System.out.println();
        System.out.print("Document Path:\t\t");
        System.out.println(object5.getURI());
        System.out.print("Document Length:\t");
        System.out.print(((Stats)object).getContentLength());
        System.out.println(" bytes");
        System.out.println();
        System.out.print("Time taken for tests:\t");
        System.out.print(f);
        System.out.println(" seconds");
        System.out.print("Complete requests:\t");
        System.out.println(((Stats)object).getSuccessCount());
        System.out.print("Failed requests:\t");
        System.out.println(((Stats)object).getFailureCount());
        System.out.print("Content transferred:\t");
        System.out.print(((Stats)object).getTotal());
        System.out.println(" bytes");
        System.out.print("Requests per second:\t");
        System.out.print(f2);
        System.out.println(" [#/sec] (mean)");
        System.out.print("Time per request:\t");
        System.out.print(f3);
        System.out.println(" [ms] (mean)");
    }

    private static void showUsage(Options options) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp("HttpBenchmark [options] [http://]hostname[:port]/path", options);
    }
}

