/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.images.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.images.ImagesServicePb;
import com.google.appengine.tools.development.ApiProxyLocal;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.awt.AlphaComposite;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalImagesService
implements LocalRpcService {
    private static final Logger log = Logger.getLogger(LocalImagesService.class.getCanonicalName());
    private String hostPrefix;
    public static final String PACKAGE = "images";
    private BlobStorage blobStorage;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        ImageIO.scanForPlugins();
        String[] inputFormats = new String[]{"png", "jpg", "gif", "bmp", "ico", "tif"};
        String[] outputFormats = new String[]{"png", "jpg"};
        for (String format : inputFormats) {
            if (ImageIO.getImageReadersByFormatName(format).hasNext()) continue;
            log.warning("No image reader found for format \"" + format + "\"." + " An ImageIO plugin must be installed to use this format" + " with the DevAppServer.");
        }
        for (String format : outputFormats) {
            if (ImageIO.getImageWritersByFormatName(format).hasNext()) continue;
            log.warning("No image writer found for format \"" + format + "\"." + " An ImageIO plugin must be installed to use this format" + " with the DevAppServer.");
        }
        ApiProxyLocal local = (ApiProxyLocal)ApiProxy.getDelegate();
        LocalRpcService service = local.getService("blobstore");
        this.blobStorage = BlobStorageFactory.getBlobStorage();
        if (context != null) {
            LocalServerEnvironment env = context.getLocalServerEnvironment();
            this.hostPrefix = "http://" + env.getAddress() + ":" + env.getPort();
        } else {
            this.hostPrefix = "";
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public ImagesServicePb.ImagesTransformResponse transform(final LocalRpcService.Status status, final ImagesServicePb.ImagesTransformRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesTransformResponse>(){

            @Override
            public ImagesServicePb.ImagesTransformResponse run() {
                BufferedImage img = LocalImagesService.this.openImage(request.getImage(), status);
                if (request.transformSize() > 10) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), String.format("%d transforms were supplied; the maximum allowed is %d.", request.transformSize(), 10));
                }
                for (ImagesServicePb.Transform transform : request.transforms()) {
                    img = LocalImagesService.this.processTransform(img, transform, status);
                }
                ImagesServicePb.ImagesTransformResponse response = new ImagesServicePb.ImagesTransformResponse();
                response.setImage(new ImagesServicePb.ImageData().setContentAsBytes(LocalImagesService.this.saveImage(img, request.getOutput().getMimeTypeEnum(), status)));
                status.setSuccessful(true);
                return response;
            }
        });
    }

    public ImagesServicePb.ImagesCompositeResponse composite(final LocalRpcService.Status status, final ImagesServicePb.ImagesCompositeRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesCompositeResponse>(){

            @Override
            public ImagesServicePb.ImagesCompositeResponse run() {
                int i;
                ArrayList<BufferedImage> images = new ArrayList<BufferedImage>(request.imageSize());
                for (int i2 = 0; i2 < request.imageSize(); ++i2) {
                    images.add(LocalImagesService.this.openImage(request.getImage(i2), status));
                }
                if (request.optionsSize() > 16) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), String.format("%d composites were supplied; the maximum allowed is %d.", request.optionsSize(), 16));
                }
                int width = request.getCanvas().getWidth();
                int height = request.getCanvas().getHeight();
                int color = request.getCanvas().getColor();
                BufferedImage canvas = new BufferedImage(width, height, 2);
                for (i = 0; i < height; ++i) {
                    for (int j = 0; j < width; ++j) {
                        canvas.setRGB(j, i, color);
                    }
                }
                for (i = 0; i < request.optionsSize(); ++i) {
                    ImagesServicePb.CompositeImageOptions options = request.getOptions(i);
                    if (options.getSourceIndex() < 0 || options.getSourceIndex() >= request.imageSize()) {
                        throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), String.format("Invalid source image index %d", options.getSourceIndex()));
                    }
                    LocalImagesService.this.processComposite(canvas, options, (BufferedImage)images.get(options.getSourceIndex()), status);
                }
                ImagesServicePb.ImagesCompositeResponse response = new ImagesServicePb.ImagesCompositeResponse();
                response.setImage(new ImagesServicePb.ImageData().setContentAsBytes(LocalImagesService.this.saveImage(canvas, request.getCanvas().getOutput().getMimeTypeEnum(), status)));
                status.setSuccessful(true);
                return response;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BufferedImage openImage(ImagesServicePb.ImageData imageData, LocalRpcService.Status status) {
        InputStream in = null;
        try {
            BufferedImage img;
            try {
                in = this.extractImageData(imageData);
            }
            catch (IOException ex) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.INVALID_BLOB_KEY.getValue(), "Could not read blob.");
            }
            try {
                img = ImageIO.read(in);
            }
            catch (IOException ex) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getValue(), "Failed to read image");
            }
            if (img == null) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.NOT_IMAGE.getValue(), "Failed to read image");
            }
            BufferedImage bufferedImage = img;
            return bufferedImage;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    byte[] saveImage(BufferedImage image, ImagesServicePb.OutputSettings.MIME_TYPE mimeType, LocalRpcService.Status status) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            if (mimeType == ImagesServicePb.OutputSettings.MIME_TYPE.JPEG) {
                ImageIO.write((RenderedImage)image, "jpg", out);
            } else {
                ImageIO.write((RenderedImage)image, "png", out);
            }
        }
        catch (IOException ex) {
            status.setSuccessful(false);
            status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR.getValue());
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.UNSPECIFIED_ERROR.getValue(), "Failed to encode image");
        }
        return out.toByteArray();
    }

    public ImagesServicePb.ImagesHistogramResponse histogram(final LocalRpcService.Status status, final ImagesServicePb.ImagesHistogramRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesHistogramResponse>(){

            @Override
            public ImagesServicePb.ImagesHistogramResponse run() {
                BufferedImage img = LocalImagesService.this.openImage(request.getImage(), status);
                int[] red = new int[256];
                int[] green = new int[256];
                int[] blue = new int[256];
                for (int i = 0; i < img.getHeight(); ++i) {
                    for (int j = 0; j < img.getWidth(); ++j) {
                        int pixel = img.getRGB(j, i);
                        int n = (pixel >> 16 & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        red[n] = red[n] + 1;
                        int n2 = (pixel >> 8 & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        green[n2] = green[n2] + 1;
                        int n3 = (pixel & 0xFF) * (pixel >> 24 & 0xFF) / 255;
                        blue[n3] = blue[n3] + 1;
                    }
                }
                ImagesServicePb.ImagesHistogramResponse response = new ImagesServicePb.ImagesHistogramResponse();
                ImagesServicePb.ImagesHistogram imageHistogram = response.getHistogram();
                for (int i = 0; i < 256; ++i) {
                    imageHistogram.addRed(red[i]);
                    imageHistogram.addGreen(green[i]);
                    imageHistogram.addBlue(blue[i]);
                }
                return response;
            }
        });
    }

    public ImagesServicePb.ImagesGetUrlBaseResponse getUrlBase(LocalRpcService.Status status, final ImagesServicePb.ImagesGetUrlBaseRequest request) {
        return AccessController.doPrivileged(new PrivilegedAction<ImagesServicePb.ImagesGetUrlBaseResponse>(){

            @Override
            public ImagesServicePb.ImagesGetUrlBaseResponse run() {
                LocalRpcService.Status unusedStatus = new LocalRpcService.Status();
                ImagesServicePb.ImageData imageData = new ImagesServicePb.ImageData();
                imageData.setBlobKey(request.getBlobKey());
                imageData.setContentAsBytes(new byte[0]);
                LocalImagesService.this.openImage(imageData, unusedStatus);
                ImagesServicePb.ImagesGetUrlBaseResponse response = new ImagesServicePb.ImagesGetUrlBaseResponse();
                response.setUrl(LocalImagesService.this.hostPrefix + "/_ah/img/" + request.getBlobKey());
                return response;
            }
        });
    }

    BufferedImage processTransform(BufferedImage image, ImagesServicePb.Transform transform, LocalRpcService.Status status) {
        AffineTransform affine = null;
        BufferedImage constraintImage = null;
        if (transform.hasWidth() || transform.hasHeight()) {
            double transformFactor;
            double yFactor;
            if (transform.getWidth() < 0 || transform.getHeight() < 0 || transform.getWidth() > 4000 || transform.getHeight() > 4000) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), String.format("Invalid resize: width and height must be in range [0,%d]", 4000));
            }
            if (transform.getWidth() == 0 && transform.getHeight() == 0) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), "Invalid resize: width and height cannot both be 0.");
            }
            double aspectRatio = (double)image.getWidth() / (double)image.getHeight();
            double xFactor = (double)transform.getWidth() / (double)image.getWidth();
            if (xFactor < (yFactor = (double)transform.getHeight() / (double)image.getHeight()) && xFactor != 0.0) {
                transformFactor = xFactor;
                constraintImage = new BufferedImage(transform.getWidth(), (int)Math.round((double)transform.getWidth() / aspectRatio), image.getType());
            } else {
                transformFactor = yFactor;
                constraintImage = new BufferedImage((int)Math.round((double)transform.getHeight() * aspectRatio), transform.getHeight(), image.getType());
            }
            affine = AffineTransform.getScaleInstance(transformFactor, transformFactor);
        } else if (transform.hasRotate()) {
            if (transform.getRotate() % 90 != 0 || transform.getRotate() >= 360 || transform.getRotate() < 0) {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), "Invalid rotate.");
            }
            affine = AffineTransform.getRotateInstance((double)transform.getRotate() * Math.PI / 180.0);
            if (transform.getRotate() == 90) {
                affine.translate(0.0, -image.getHeight());
            } else if (transform.getRotate() == 180) {
                affine.translate(-image.getWidth(), -image.getHeight());
            } else if (transform.getRotate() == 270) {
                affine.translate(-image.getWidth(), 0.0);
            }
        } else if (transform.hasHorizontalFlip()) {
            affine = new AffineTransform(-1.0, 0.0, 0.0, 1.0, (double)(image.getWidth() - 1), 0.0);
        } else if (transform.hasVerticalFlip()) {
            affine = new AffineTransform(1.0, 0.0, 0.0, -1.0, 0.0, (double)(image.getHeight() - 1));
        } else {
            if (transform.hasCropLeftX() || transform.hasCropTopY() || transform.hasCropRightX() || transform.hasCropBottomY()) {
                if (!this.validCropArgs(transform)) {
                    status.setSuccessful(false);
                    status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                    throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), "Invalid crop.");
                }
                return image.getSubimage((int)(transform.getCropLeftX() * (float)image.getWidth()), (int)(transform.getCropTopY() * (float)image.getHeight()), (int)((transform.getCropRightX() - transform.getCropLeftX()) * (float)image.getWidth()), (int)((transform.getCropBottomY() - transform.getCropTopY()) * (float)image.getHeight()));
            }
            if (transform.hasAutolevels()) {
                log.warning("I'm Feeling Lucky is not available in the SDK.");
            } else {
                status.setSuccessful(false);
                status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
                throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
            }
        }
        if (affine != null) {
            AffineTransformOp op = new AffineTransformOp(affine, 1);
            return op.filter(image, constraintImage);
        }
        return image;
    }

    private BufferedImage processComposite(BufferedImage canvas, ImagesServicePb.CompositeImageOptions options, BufferedImage image, LocalRpcService.Status status) {
        float opacity = options.getOpacity();
        if (opacity < 0.0f || opacity > 1.0f) {
            status.setSuccessful(false);
            status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), "Opacity must be in range [0.0, 1.0]");
        }
        if (opacity == 0.0f) {
            return canvas;
        }
        if (options.getAnchorEnum() == null) {
            status.setSuccessful(false);
            status.setErrorCode(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue());
            throw new ApiProxy.ApplicationException(ImagesServicePb.ImagesServiceError.ErrorCode.BAD_TRANSFORM_DATA.getValue(), "Invalid anchor position.");
        }
        float xAnchor = (float)(options.getAnchor() % 3) * 0.5f;
        float yAnchor = (float)(options.getAnchor() / 3) * 0.5f;
        int xOffset = (int)((float)options.getXOffset() + xAnchor * (float)(canvas.getWidth() - image.getWidth()));
        int yOffset = (int)((float)options.getYOffset() + yAnchor * (float)(canvas.getHeight() - image.getHeight()));
        int yStart = Math.max(0, -yOffset);
        int xStart = Math.max(0, -xOffset);
        int yEnd = Math.min(image.getHeight(), canvas.getHeight() - yOffset);
        int xEnd = Math.min(image.getWidth(), canvas.getWidth() - xOffset);
        if (xStart >= xEnd || yStart >= yEnd) {
            return canvas;
        }
        BufferedImage positionedImage = new BufferedImage(xEnd + xOffset, yEnd + yOffset, 2);
        for (int i = yStart; i < yEnd; ++i) {
            for (int j = xStart; j < xEnd; ++j) {
                positionedImage.setRGB(j + xOffset, i + yOffset, image.getRGB(j, i) | 0xFF000000);
            }
        }
        AlphaComposite composite = AlphaComposite.getInstance(3, opacity);
        composite.createContext(positionedImage.getColorModel(), canvas.getColorModel(), null).compose(positionedImage.getRaster(), canvas.getRaster(), canvas.getRaster());
        return canvas;
    }

    private boolean validCropArgs(ImagesServicePb.Transform transform) {
        return this.validCropArgument(transform.getCropLeftX()) && this.validCropArgument(transform.getCropTopY()) && this.validCropArgument(transform.getCropRightX()) && this.validCropArgument(transform.getCropBottomY()) && transform.getCropLeftX() < transform.getCropRightX() && transform.getCropTopY() < transform.getCropBottomY();
    }

    private boolean validCropArgument(float arg) {
        return arg >= 0.0f && arg <= 1.0f;
    }

    BlobStorage getBlobStorage() {
        return this.blobStorage;
    }

    private InputStream extractImageData(ImagesServicePb.ImageData imageData) throws IOException {
        if (imageData.hasBlobKey()) {
            return this.getBlobStorage().fetchBlob(new BlobKey(imageData.getBlobKey()));
        }
        return new ByteArrayInputStream(imageData.getContentAsBytes());
    }
}

