/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.xmpp.dev;

import com.google.appengine.api.xmpp.XMPPServicePb;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalXMPPService
implements LocalRpcService {
    public static final String PACKAGE = "xmpp";

    public void start() {
    }

    public void stop() {
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public String getPackage() {
        return PACKAGE;
    }

    public XMPPServicePb.PresenceResponse getPresence(LocalRpcService.Status status, XMPPServicePb.PresenceRequest request) {
        XMPPServicePb.PresenceResponse response = new XMPPServicePb.PresenceResponse();
        if (request.getJid().charAt(0) < 'm') {
            response.setIsAvailable(true);
        } else {
            response.setIsAvailable(false);
        }
        return response;
    }

    public XMPPServicePb.XmppMessageResponse sendMessage(LocalRpcService.Status status, XMPPServicePb.XmppMessageRequest request) {
        System.out.println("Sending an XMPP Message:");
        System.out.println("    Body:");
        System.out.println("        " + request.getBody());
        System.out.println("    Type:");
        System.out.println("        " + request.getType());
        System.out.println("    RawXml:");
        System.out.println("        " + request.isRawXml());
        if (request.hasFromJid()) {
            System.out.println("    FromJid:");
            System.out.println("        " + request.getFromJid());
        }
        System.out.println("    To JIDs:");
        for (String jid : request.jids()) {
            System.out.println("        " + jid);
        }
        XMPPServicePb.XmppMessageResponse response = new XMPPServicePb.XmppMessageResponse();
        for (String jid : request.jids()) {
            response.addStatus(XMPPServicePb.XmppMessageResponse.XmppMessageStatus.NO_ERROR.getValue());
        }
        return response;
    }

    public XMPPServicePb.XmppInviteResponse sendInvite(LocalRpcService.Status status, XMPPServicePb.XmppInviteRequest request) {
        System.out.println("Sending an XMPP Invitation:");
        System.out.println("    To JID:");
        System.out.println("        " + request.getJid());
        XMPPServicePb.XmppInviteResponse response = new XMPPServicePb.XmppInviteResponse();
        return response;
    }
}

