/*
 * Decompiled with CFR 0.152.
 */
package org.quartz.plugins.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.jobs.FileScanJob;
import org.quartz.jobs.FileScanListener;
import org.quartz.spi.SchedulerPlugin;
import org.quartz.xml.JobSchedulingDataProcessor;

public class JobInitializationPluginMultiple
implements SchedulerPlugin,
FileScanListener {
    private String name;
    private Scheduler scheduler;
    private boolean overWriteExistingJobs = true;
    private boolean failOnFileNotFound = true;
    private String fileName = "quartz_jobs.xml";
    private Vector files = new Vector();
    private boolean useContextClassLoader = true;
    private boolean validating = true;
    private boolean validatingSchema = true;
    private long scanInterval = 0L;
    boolean initializing = true;
    boolean started = false;
    static /* synthetic */ Class class$org$quartz$plugins$xml$JobInitializationPluginMultiple;
    static /* synthetic */ Class class$org$quartz$jobs$FileScanJob;

    public boolean isOverWriteExistingJobs() {
        return this.overWriteExistingJobs;
    }

    public void setOverWriteExistingJobs(boolean overWriteExistingJobs) {
        this.overWriteExistingJobs = overWriteExistingJobs;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public long getScanInterval() {
        return this.scanInterval / 1000L;
    }

    public void setScanInterval(long scanInterval) {
        this.scanInterval = scanInterval * 1000L;
    }

    public boolean isFailOnFileNotFound() {
        return this.failOnFileNotFound;
    }

    public void setFailOnFileNotFound(boolean failOnFileNotFound) {
        this.failOnFileNotFound = failOnFileNotFound;
    }

    public boolean isUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean useContextClassLoader) {
        this.useContextClassLoader = useContextClassLoader;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public boolean isValidatingSchema() {
        return this.validatingSchema;
    }

    public void setValidatingSchema(boolean validatingSchema) {
        this.validatingSchema = validatingSchema;
    }

    protected static Log getLog() {
        return LogFactory.getLog(class$org$quartz$plugins$xml$JobInitializationPluginMultiple == null ? (class$org$quartz$plugins$xml$JobInitializationPluginMultiple = JobInitializationPluginMultiple.class$("org.quartz.plugins.xml.JobInitializationPluginMultiple")) : class$org$quartz$plugins$xml$JobInitializationPluginMultiple);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(String name, Scheduler scheduler) throws SchedulerException {
        this.initializing = true;
        try {
            this.name = name;
            this.scheduler = scheduler;
            JobInitializationPluginMultiple.getLog().info("Registering Quartz Job Initialization Plug-in.");
            this.updateJobFileList();
        }
        finally {
            this.initializing = false;
        }
    }

    private void updateJobFileList() {
        StringTokenizer stok = new StringTokenizer(this.fileName, ",");
        while (stok.hasMoreTokens()) {
            JobFile jobFile = new JobFile(stok.nextToken());
            this.files.add(jobFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (this.scanInterval > 0L) {
            try {
                Iterator iterator = this.files.iterator();
                while (iterator.hasNext()) {
                    JobFile jobFile = (JobFile)iterator.next();
                    SimpleTrigger trig = new SimpleTrigger("JobInitializationPluginMultiple_" + this.name, "JobInitializationPluginMultiple", new Date(), null, SimpleTrigger.REPEAT_INDEFINITELY, this.scanInterval);
                    trig.setVolatility(true);
                    JobDetail job = new JobDetail("JobInitializationPluginMultiple_" + this.name, "JobInitializationPluginMultiple", class$org$quartz$jobs$FileScanJob == null ? JobInitializationPluginMultiple.class$("org.quartz.jobs.FileScanJob") : class$org$quartz$jobs$FileScanJob);
                    job.setVolatility(true);
                    job.getJobDataMap().put(FileScanJob.FILE_NAME, jobFile.getFilePath());
                    job.getJobDataMap().put(FileScanJob.FILE_SCAN_LISTENER_NAME, "JobInitializationPluginMultiple_" + this.name);
                    this.scheduler.getContext().put((Object)("JobInitializationPluginMultiple_" + this.name), this);
                    this.scheduler.scheduleJob(job, trig);
                }
            }
            catch (SchedulerException se) {
                JobInitializationPluginMultiple.getLog().error("Error starting background-task for watching jobs file.", se);
            }
        }
        try {
            this.processFiles();
        }
        finally {
            this.started = true;
        }
    }

    public void shutdown() {
    }

    public void processFiles() {
        JobSchedulingDataProcessor processor = new JobSchedulingDataProcessor(this.isUseContextClassLoader(), this.isValidating(), this.isValidatingSchema());
        Iterator iterator = this.files.iterator();
        while (iterator.hasNext()) {
            JobFile jobFile = (JobFile)iterator.next();
            try {
                if (!jobFile.getFileFound()) continue;
                processor.processFileAndScheduleJobs(jobFile.getFileName(), this.scheduler, this.isOverWriteExistingJobs());
            }
            catch (Exception e) {
                JobInitializationPluginMultiple.getLog().error("Error scheduling jobs: " + e.getMessage(), e);
            }
        }
    }

    public void fileUpdated(String fileName) {
        if (this.started) {
            this.processFiles();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class JobFile {
        private String fileName = null;
        private String filePath = null;
        private boolean fileFound = false;

        protected JobFile(String fileName) {
            this.fileName = fileName;
        }

        protected String getFileName() {
            return this.fileName;
        }

        protected boolean getFileFound() throws SchedulerException {
            if (this.filePath == null) {
                this.findFile();
            }
            return this.fileFound;
        }

        protected String getFilePath() throws SchedulerException {
            if (this.filePath == null) {
                this.findFile();
            }
            return this.filePath;
        }

        private void findFile() throws SchedulerException {
            URL url;
            FileInputStream f = null;
            File file = new File(this.fileName);
            if (!(file != null && file.exists() || (url = Thread.currentThread().getContextClassLoader().getResource(this.fileName)) == null)) {
                file = new File(url.getPath());
            }
            try {
                f = new FileInputStream(file);
            }
            catch (FileNotFoundException e) {
                // empty catch block
            }
            if (f == null && JobInitializationPluginMultiple.this.isFailOnFileNotFound()) {
                throw new SchedulerException("File named '" + this.fileName + "' does not exist.");
            }
            if (f == null) {
                JobInitializationPluginMultiple.getLog().warn("File named '" + this.fileName + "' does not exist.");
            } else {
                this.fileFound = true;
                try {
                    this.filePath = file.getPath();
                    ((InputStream)f).close();
                }
                catch (IOException ioe) {
                    JobInitializationPluginMultiple.getLog().warn("Error closing file named '" + this.fileName, ioe);
                }
            }
        }
    }
}

