/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.Channel;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChannelManager {
    public static final String CLIENT_ID_FORMAT = "channel-%s-%s";
    private static ChannelManager instance;
    private final Map<String, Channel> channels;
    private final Map<String, String> clientIdToApplicationKey;
    private Random rng = new SecureRandom();

    private ChannelManager() {
        this.channels = new ConcurrentHashMap<String, Channel>();
        this.clientIdToApplicationKey = new HashMap<String, String>();
    }

    void setRng(Random rng) {
        this.rng = rng;
    }

    Map<String, Channel> getChannels() {
        return this.channels;
    }

    Channel getChannel(String applicationKey) {
        if (applicationKey != null && this.channels.containsKey(applicationKey)) {
            return this.channels.get(applicationKey);
        }
        throw new LocalChannelFailureException("Channel for application key " + applicationKey + " not found.");
    }

    Channel getClientChannel(String clientId) {
        String applicationKey = this.clientIdToApplicationKey.get(clientId);
        return this.getChannel(applicationKey);
    }

    public String createChannel(String applicationKey) {
        String randomNoise = Integer.toString(this.rng.nextInt(), 36);
        String clientId = String.format(CLIENT_ID_FORMAT, randomNoise, applicationKey);
        this.clientIdToApplicationKey.put(clientId, applicationKey);
        if (!this.channels.containsKey(applicationKey)) {
            this.channels.put(applicationKey, new Channel(applicationKey));
        }
        return clientId;
    }

    public void sendMessage(String applicationKey, String message) {
        this.getChannel(applicationKey).sendMessage(message);
    }

    public String connectClient(String clientId) {
        Channel channel = this.getClientChannel(clientId);
        return channel.connectClient();
    }

    public void disconnectClient(String clientId, String connectionId) {
        Channel channel = this.getClientChannel(clientId);
        channel.disconnectClient(connectionId);
    }

    public String getNextClientMessage(String clientId, String connectionId) {
        Channel channel = this.getClientChannel(clientId);
        return channel.getClientMessageQueue(connectionId).poll();
    }

    public static synchronized ChannelManager getInstance() {
        if (instance == null) {
            instance = new ChannelManager();
        }
        return instance;
    }

    static synchronized void clearInstance() {
        instance = null;
    }
}

