/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.KeyFilteredPseudoKind;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class KindPseudoKind
extends KeyFilteredPseudoKind {
    KindPseudoKind(LocalDatastoreService localDatastore) {
        super(localDatastore);
    }

    @Override
    public String getKindName() {
        return "__kind__";
    }

    private String kindKeyToString(Key key) {
        if (key == null) {
            return null;
        }
        this.checkRequest(key.getParent() == null, String.format("Key filter on %s is invalid (key has parent) - received %s", "__kind__", key));
        this.checkRequest(key.getKind().equals("__kind__") && key.getName() != null, String.format("Key filter on %s is invalid (must be a named key for %s) - received %s", "__kind__", "__kind__", key));
        return key.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query, Key startKey, boolean startInclusive, Key endKey, boolean endInclusive) {
        this.checkRequest(!query.hasAncestor(), "ancestor queries on __kind__ not allowed");
        String app = query.getApp();
        String namespace = query.getNameSpace();
        String startKind = this.kindKeyToString(startKey);
        String endKind = this.kindKeyToString(endKey);
        LocalDatastoreService.Profile profile = this.getDatastore().getOrCreateProfile(app);
        Map<String, LocalDatastoreService.Extent> extents = profile.getExtents();
        ArrayList<OnestoreEntity.EntityProto> schema = new ArrayList<OnestoreEntity.EntityProto>();
        Map<String, LocalDatastoreService.Extent> map = extents;
        synchronized (map) {
            for (Map.Entry<String, LocalDatastoreService.Extent> entry : extents.entrySet()) {
                int kindsCompared;
                String kind = entry.getKey();
                if (startKind != null) {
                    kindsCompared = kind.compareTo(startKind);
                    if (startInclusive && kindsCompared < 0 || !startInclusive && kindsCompared <= 0) continue;
                }
                if (endKind != null) {
                    kindsCompared = kind.compareTo(endKind);
                    if (endInclusive && kindsCompared > 0 || !endInclusive && kindsCompared >= 0) continue;
                }
                if (entry.getValue().getEntities().isEmpty()) continue;
                boolean inCurrentNamespace = false;
                for (OnestoreEntity.EntityProto entity : entry.getValue().getEntities().values()) {
                    if (!entity.getKey().getNameSpace().equals(namespace)) continue;
                    inCurrentNamespace = true;
                    break;
                }
                if (!inCurrentNamespace) continue;
                OnestoreEntity.EntityProto allPropsProto = new OnestoreEntity.EntityProto();
                schema.add(allPropsProto);
                OnestoreEntity.Path path = new OnestoreEntity.Path();
                path.addElement().setType("__kind__").setName(kind);
                OnestoreEntity.Reference key = new OnestoreEntity.Reference().setApp(app).setPath(path);
                if (namespace.length() > 0) {
                    key.setNameSpace(namespace);
                }
                allPropsProto.setKey(key);
                allPropsProto.getMutableEntityGroup().addElement(path.getElement(0));
            }
        }
        return schema;
    }
}

