/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.KeyFilteredPseudoKind;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.LocalDatastoreService;
import com.google.appengine.repackaged.com.google.common.collect.TreeMultimap;
import com.google.apphosting.api.DatastorePb;
import com.google.storage.onestore.PropertyType;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PropertyPseudoKind
extends KeyFilteredPseudoKind {
    PropertyPseudoKind(LocalDatastoreService localDatastore) {
        super(localDatastore);
    }

    @Override
    public String getKindName() {
        return "__property__";
    }

    private KindProperty propertyKeyToKindProperty(Key key) {
        if (key == null) {
            return new KindProperty(null, null);
        }
        Key parent = key.getParent();
        if (parent == null) {
            this.checkRequest(key.getKind().equals("__kind__") && key.getName() != null, String.format("Key filter on %s is invalid (parent must be a named key for %s) - received %s", "__property__", "__kind__", key));
            return new KindProperty(key.getName(), "");
        }
        this.checkRequest(parent.getParent() == null, String.format("Key filter on %s is invalid (must have no parent or %s parent) - received %s", "__property__", "__kind__", key));
        this.checkRequest(parent.getKind().equals("__kind__") && parent.getName() != null, String.format("Key filter on %s is invalid (parent must be named key for %s) - received %s", "__property__", "__kind__", key));
        this.checkRequest(key.getKind().equals("__property__") && key.getName() != null, String.format("Key filter on %s is invalid (must be named key for %s) - received %s", "__property__", "__property__", key));
        return new KindProperty(parent.getName(), key.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    List<OnestoreEntity.EntityProto> runQuery(DatastorePb.Query query, Key startKey, boolean startInclusive, Key endKey, boolean endInclusive) {
        this.checkRequest(!query.hasTransaction(), "transactional queries on __property__ not allowed");
        String app = query.getApp();
        String namespace = query.getNameSpace();
        boolean keysOnly = query.isKeysOnly();
        KindProperty start = this.propertyKeyToKindProperty(startKey);
        KindProperty end = this.propertyKeyToKindProperty(endKey);
        LocalDatastoreService.Profile profile = this.getDatastore().getOrCreateProfile(app);
        Map<String, LocalDatastoreService.Extent> extents = profile.getExtents();
        ArrayList<OnestoreEntity.EntityProto> schema = new ArrayList<OnestoreEntity.EntityProto>();
        if (query.hasAncestor()) {
            KindProperty ancestor = this.propertyKeyToKindProperty(LocalCompositeIndexManager.KeyTranslator.createFromPb((OnestoreEntity.Reference)query.getAncestor()));
            if (start.kind == null && end.kind == null) {
                start.kind = ancestor.kind;
                if (!ancestor.property.equals("")) {
                    end.kind = ancestor.kind;
                    start.property = end.property = ancestor.property;
                    endInclusive = true;
                    startInclusive = true;
                } else {
                    char[] zero = new char[]{'\u0000'};
                    end.kind = ancestor.kind + zero;
                    end.property = "";
                    start.property = "";
                }
                query.clearAncestor();
            }
        }
        Map<String, LocalDatastoreService.Extent> map = extents;
        synchronized (map) {
            for (Map.Entry<String, LocalDatastoreService.Extent> entry : extents.entrySet()) {
                int kindsCompared;
                String kind = entry.getKey();
                boolean startKindEqual = false;
                boolean endKindEqual = false;
                if (start.kind != null) {
                    kindsCompared = kind.compareTo(start.kind);
                    boolean bl = startKindEqual = kindsCompared == 0;
                    if (kindsCompared < 0) continue;
                }
                if (end.kind != null) {
                    kindsCompared = kind.compareTo(end.kind);
                    boolean bl = endKindEqual = kindsCompared == 0;
                    if (kindsCompared > 0) continue;
                }
                if (entry.getValue().getEntities().isEmpty()) continue;
                ArrayList<OnestoreEntity.EntityProto> entities = new ArrayList<OnestoreEntity.EntityProto>(entry.getValue().getEntities().size());
                for (OnestoreEntity.EntityProto entity : entry.getValue().getEntities().values()) {
                    if (!entity.getKey().getNameSpace().equals(namespace)) continue;
                    entities.add(entity);
                }
                if (entities.isEmpty()) continue;
                TreeMultimap allProps = TreeMultimap.create();
                for (OnestoreEntity.EntityProto entity : entities) {
                    for (OnestoreEntity.Property prop : entity.propertys()) {
                        int propertysCompared;
                        String name = prop.getName();
                        PropertyType type = PropertyType.getType((OnestoreEntity.PropertyValue)prop.getValue());
                        if (startKindEqual) {
                            propertysCompared = name.compareTo(start.property);
                            if (startInclusive && propertysCompared < 0 || !startInclusive && propertysCompared <= 0) continue;
                        }
                        if (endKindEqual) {
                            propertysCompared = name.compareTo(end.property);
                            if (endInclusive && propertysCompared > 0 || !endInclusive && propertysCompared >= 0) continue;
                        }
                        allProps.put((Object)name, (Object)type.name());
                    }
                }
                for (String prop : allProps.keySet()) {
                    OnestoreEntity.EntityProto propEntity = new OnestoreEntity.EntityProto();
                    schema.add(propEntity);
                    OnestoreEntity.Path path = new OnestoreEntity.Path();
                    path.addElement().setType("__kind__").setName(kind);
                    path.addElement().setType("__property__").setName(prop);
                    OnestoreEntity.Reference key = new OnestoreEntity.Reference().setApp(app).setPath(path);
                    if (!namespace.isEmpty()) {
                        key.setNameSpace(namespace);
                    }
                    propEntity.setKey(key);
                    propEntity.getMutableEntityGroup().addElement(path.getElement(0));
                    if (keysOnly) continue;
                    for (String rep : allProps.get((Object)prop)) {
                        OnestoreEntity.PropertyValue repValue = new OnestoreEntity.PropertyValue().setStringValue(rep);
                        propEntity.addProperty().setName("property_representation").setValue(repValue).setMultiple(true);
                    }
                }
            }
        }
        return schema;
    }

    private class KindProperty {
        String kind;
        String property;

        KindProperty(String kind, String property) {
            this.kind = kind;
            this.property = property;
        }
    }
}

