/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.auth;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthChallengeException;
import org.apache.commons.httpclient.auth.AuthScheme;
import org.apache.commons.httpclient.auth.AuthenticationException;
import org.apache.commons.httpclient.auth.CredentialsNotAvailableException;
import org.apache.commons.httpclient.auth.InvalidCredentialsException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

public class NegotiateScheme
implements AuthScheme {
    private static final Log LOG = LogFactory.getLog(NegotiateScheme.class);
    private String challenge = null;
    private static final int UNINITIATED = 0;
    private static final int INITIATED = 1;
    private static final int NEGOTIATING = 3;
    private static final int ESTABLISHED = 4;
    private static final int FAILED = Integer.MAX_VALUE;
    private GSSContext context = null;
    private int state;
    byte[] token = new byte[0];

    protected void init(String string) throws GSSException {
        LOG.debug("init " + string);
        Oid oid = new Oid("1.2.840.113554.1.2.2");
        GSSManager gSSManager = GSSManager.getInstance();
        GSSName gSSName = gSSManager.createName("HTTP/" + string, null);
        this.context = gSSManager.createContext(gSSName, oid, null, 0);
        this.context.requestMutualAuth(true);
        this.context.requestCredDeleg(true);
        this.state = 1;
    }

    public NegotiateScheme() {
        this.state = 0;
    }

    public NegotiateScheme(String string) {
        LOG.debug("enter NegotiateScheme(" + string + ")");
        this.processChallenge(string);
    }

    public void processChallenge(String string) {
        LOG.debug("enter processChallenge(challenge=\"" + string + "\")");
        if (string.startsWith("Negotiate")) {
            if (!this.isComplete()) {
                this.state = 3;
            }
            this.token = string.startsWith("Negotiate ") ? new Base64().decode(string.substring(10).getBytes()) : new byte[0];
        }
    }

    public boolean isComplete() {
        LOG.debug("enter isComplete()");
        return this.state == 4 || this.state == Integer.MAX_VALUE;
    }

    public String getSchemeName() {
        return "Negotiate";
    }

    public String getRealm() {
        return null;
    }

    public String getID() {
        LOG.debug("enter getID(): " + this.challenge);
        return this.challenge;
    }

    public String getParameter(String string) {
        LOG.debug("enter getParameter(" + string + ")");
        if (string == null) {
            throw new IllegalArgumentException("Parameter name may not be null");
        }
        return null;
    }

    public boolean isConnectionBased() {
        LOG.info("enter isConnectionBased()");
        return true;
    }

    public String authenticate(Credentials credentials, String string, String string2) throws AuthenticationException {
        throw new AuthenticationException("method not supported by Negotiate scheme");
    }

    public String authenticate(Credentials credentials, HttpMethod httpMethod) throws AuthenticationException {
        LOG.debug("enter NegotiateScheme.authenticate(Credentials, HttpMethod)");
        if (this.state == 0) {
            throw new IllegalStateException("Negotiation authentication process has not been initiated");
        }
        try {
            try {
                if (this.context == null) {
                    LOG.info("host: " + httpMethod.getURI().getHost());
                    this.init(httpMethod.getURI().getHost());
                }
            }
            catch (URIException uRIException) {
                LOG.error(uRIException.getMessage());
                this.state = Integer.MAX_VALUE;
                throw new AuthenticationException(uRIException.getMessage());
            }
            this.token = this.context.initSecContext(this.token, 0, this.token.length);
            LOG.info("got token, sending " + this.token.length + " to server");
        }
        catch (GSSException gSSException) {
            LOG.fatal(gSSException.getMessage());
            this.state = Integer.MAX_VALUE;
            if (gSSException.getMajor() == 9 || gSSException.getMajor() == 8) {
                throw new InvalidCredentialsException(gSSException.getMessage(), gSSException);
            }
            if (gSSException.getMajor() == 13) {
                throw new CredentialsNotAvailableException(gSSException.getMessage(), gSSException);
            }
            if (gSSException.getMajor() == 10 || gSSException.getMajor() == 19 || gSSException.getMajor() == 20) {
                throw new AuthChallengeException(gSSException.getMessage(), gSSException);
            }
            throw new AuthenticationException(gSSException.getMessage());
        }
        return "Negotiate " + new String(new Base64().encode(this.token));
    }
}

