/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.contrib.proxy;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Properties;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.contrib.proxy.ProxyDetectionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PluginProxyUtil {
    private static final Log LOG = LogFactory.getLog(PluginProxyUtil.class);
    private static final ProxyHost NO_PROXY_HOST = new ProxyHost("", 80);
    private static final String PLUGIN_PROXY_CONFIG_PROP = "javaplugin.proxy.config.list";

    public static ProxyHost detectProxy(URL uRL) throws ProxyDetectionException {
        ProxyHost proxyHost = null;
        String string = System.getProperty("java.runtime.version");
        if (LOG.isDebugEnabled()) {
            LOG.debug("About to attempt auto proxy detection under Java version:" + string);
        }
        boolean bl = false;
        if (string.startsWith("1.3")) {
            proxyHost = PluginProxyUtil.detectProxySettingsJDK13(uRL);
            if (proxyHost == null) {
                bl = true;
            }
        } else if (string.startsWith("1.4") || string.startsWith("1.5") || string.startsWith("1.6")) {
            proxyHost = PluginProxyUtil.detectProxySettingsJDK14_JDK15_JDK16(uRL);
            if (proxyHost == null) {
                bl = true;
            }
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Sun Plugin reported java version not 1.3.X, 1.4.X, 1.5.X or 1.6.X - trying failover detection...");
            }
            bl = true;
        }
        if (bl) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using failover proxy detection...");
            }
            proxyHost = PluginProxyUtil.getPluginProxyConfigSettings();
        }
        if (NO_PROXY_HOST.equals(proxyHost)) {
            proxyHost = null;
        }
        return proxyHost;
    }

    private static ProxyHost detectProxySettingsJDK13(URL uRL) throws ProxyDetectionException {
        ProxyHost proxyHost;
        block10: {
            proxyHost = null;
            try {
                Class<?> clazz = Class.forName("sun.plugin.protocol.PluginProxyHandler");
                Method method = clazz.getDeclaredMethod("getDefaultProxyHandler", null);
                Object object = method.invoke(null, null);
                if (object != null) {
                    Class<?> clazz2 = object.getClass();
                    Method method2 = clazz2.getDeclaredMethod("getProxyInfo", URL.class);
                    Object object2 = method2.invoke(object, uRL);
                    if (object2 != null) {
                        boolean bl;
                        Class<?> clazz3 = object2.getClass();
                        Method method3 = clazz3.getDeclaredMethod("getProxy", null);
                        boolean bl2 = bl = method3.invoke(object2, null) != null;
                        if (bl) {
                            String string = (String)method3.invoke(object2, null);
                            Method method4 = clazz3.getDeclaredMethod("getPort", null);
                            Integer n = (Integer)method4.invoke(object2, null);
                            int n2 = n;
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("1.3.X: proxy=" + string + " port=" + n2);
                            }
                            proxyHost = new ProxyHost(string, n2);
                        } else {
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("1.3.X reported NULL for proxyInfo.getProxy (no proxy assumed)");
                            }
                            proxyHost = NO_PROXY_HOST;
                        }
                    } else {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("NULL proxyInfo in 1.3.X auto proxy detection, (no proxy assumed)");
                        }
                        proxyHost = NO_PROXY_HOST;
                    }
                    break block10;
                }
                throw new ProxyDetectionException("Sun Plugin 1.3.X failed to provide a default proxy handler");
            }
            catch (Exception exception) {
                LOG.warn("Sun Plugin 1.3.X proxy detection class not found, will try failover detection, e:" + exception);
            }
        }
        return proxyHost;
    }

    private static ProxyHost detectProxySettingsJDK14_JDK15_JDK16(URL uRL) {
        ProxyHost proxyHost = null;
        try {
            Class<?> clazz = Class.forName("com.sun.java.browser.net.ProxyService");
            Method method = clazz.getDeclaredMethod("getProxyInfo", URL.class);
            Object object = method.invoke(null, uRL);
            if (object == null || Array.getLength(object) == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("1.4.X reported NULL proxy (no proxy assumed)");
                }
                proxyHost = NO_PROXY_HOST;
            } else {
                Object object2 = Array.get(object, 0);
                Class<?> clazz2 = object2.getClass();
                Method method2 = clazz2.getDeclaredMethod("getHost", null);
                String string = (String)method2.invoke(object2, null);
                Method method3 = clazz2.getDeclaredMethod("getPort", null);
                Integer n = (Integer)method3.invoke(object2, null);
                int n2 = n;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("1.4.X Proxy info geProxy:" + string + " get Port:" + n2);
                }
                proxyHost = new ProxyHost(string, n2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            LOG.warn("Sun Plugin 1.4.X proxy detection class not found, will try failover detection, e:" + exception);
        }
        return proxyHost;
    }

    private static ProxyHost getPluginProxyConfigSettings() throws ProxyDetectionException {
        ProxyHost proxyHost;
        block7: {
            proxyHost = null;
            try {
                boolean bl;
                Properties properties = System.getProperties();
                String string = properties.getProperty(PLUGIN_PROXY_CONFIG_PROP);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Plugin Proxy Config List Property:" + string);
                }
                boolean bl2 = bl = string != null;
                if (bl) {
                    string = string.toUpperCase();
                    String string2 = "";
                    string2 = string.indexOf("HTTP=") > -1 ? string.substring(string.indexOf("HTTP=") + 5, string.indexOf(":")) : string.substring(0, string.indexOf(":"));
                    int n = string.indexOf(",");
                    if (n < 1) {
                        n = string.length();
                    }
                    String string3 = string.substring(string.indexOf(":") + 1, n);
                    int n2 = Integer.parseInt(string3);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("proxy " + string2 + " port " + n2);
                    }
                    proxyHost = new ProxyHost(string2, n2);
                } else {
                    LOG.debug("No configured plugin proxy list");
                    proxyHost = NO_PROXY_HOST;
                }
            }
            catch (Exception exception) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.debug("Exception during failover auto proxy detection, , e:" + exception);
                throw new ProxyDetectionException("Encountered unexpected exception while attempting to parse proxy information stored in javaplugin.proxy.config.list", exception);
            }
        }
        return proxyHost;
    }
}

