/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.protos.speckle.Client;
import com.google.storage.speckle.jdbc.internal.SpeckleConnectionProperty;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    private Util() {
    }

    static Properties getUserNameAndPasswordProperties(Map<String, String> map) {
        String password;
        Properties p = new Properties();
        String user = map.get(SpeckleConnectionProperty.USER.key());
        if (user != null) {
            p.put(SpeckleConnectionProperty.USER.key(), user);
        }
        if ((password = map.get(SpeckleConnectionProperty.PASSWORD.key())) != null) {
            p.put(SpeckleConnectionProperty.PASSWORD.key(), password);
        }
        return p;
    }

    static String getDatabase(Map<String, String> map) {
        return map.get(SpeckleConnectionProperty.DATABASE.key());
    }

    static Map<String, String> toPropertyMap(List<Client.Property> properties) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (Client.Property p : properties) {
            map.put(p.getKey(), p.getValue());
        }
        return map;
    }

    static Map<String, String> concat(Map<String, String> map1, Map<String, String> map2) {
        HashMap<String, String> result = new HashMap<String, String>(map1);
        result.putAll(map2);
        return result;
    }

    static Map<String, String> copyAndAdd(String key, String value, Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(key, value);
        result.putAll(map);
        return result;
    }

    static Client.SqlException toClientSqlException(SQLException e) {
        Client.SqlException.Builder builder = Client.SqlException.newBuilder();
        builder.setCode(e.getErrorCode());
        if (e.getSQLState() != null) {
            builder.setSqlState(e.getSQLState());
        }
        if (e.getMessage() != null) {
            builder.setMessage(e.getMessage());
        }
        return builder.build();
    }
}

