/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.dev.Channel;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import com.google.appengine.api.urlfetch.URLFetchServicePb;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServerEnvironment;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ChannelManager {
    public static final String TOKEN_FORMAT = "channel-%s-%s";
    private static final Logger logger = Logger.getLogger(ChannelManager.class.getName());
    private boolean channelPresenceEnabled = false;
    private final Map<String, Channel> channels;
    private final Map<String, String> tokenToClientId;
    private LocalURLFetchService fetchService;
    private final LocalServerEnvironment localServerEnvironment;
    private Random rng = new SecureRandom();

    public ChannelManager(LocalServerEnvironment localServerEnvironment, LocalURLFetchService fetchService) {
        this.channels = new ConcurrentHashMap<String, Channel>();
        this.tokenToClientId = new HashMap<String, String>();
        this.localServerEnvironment = localServerEnvironment;
        this.fetchService = fetchService;
    }

    @VisibleForTesting
    void setRng(Random rng) {
        this.rng = rng;
    }

    @VisibleForTesting
    void enableChannelPresence(boolean enable) {
        this.channelPresenceEnabled = enable;
    }

    @VisibleForTesting
    void setFetchService(LocalURLFetchService fetchService) {
        this.fetchService = fetchService;
    }

    Channel getChannel(String clientId) {
        if (clientId != null && this.channels.containsKey(clientId)) {
            return this.channels.get(clientId);
        }
        throw new LocalChannelFailureException("Channel for client id " + clientId + " not found.");
    }

    Channel getClientChannelFromToken(String token) {
        String clientId = this.tokenToClientId.get(token);
        return this.getChannel(clientId);
    }

    public String createChannel(String clientId) {
        String randomNoise = Integer.toString(this.rng.nextInt(), 36);
        String token = String.format(TOKEN_FORMAT, randomNoise, clientId);
        this.tokenToClientId.put(token, clientId);
        if (!this.channels.containsKey(clientId)) {
            this.channels.put(clientId, new Channel(clientId));
        }
        return token;
    }

    public void sendMessage(String clientId, String message) {
        if (null == clientId) {
            throw new IllegalArgumentException("clientId cannot be null");
        }
        if (this.channels.containsKey(clientId)) {
            this.getChannel(clientId).sendMessage(message);
        } else {
            logger.log(Level.WARNING, "Skipping message to unconnected channel: " + clientId);
        }
    }

    public String connectClient(String token) {
        Channel channel = this.getClientChannelFromToken(token);
        String id = channel.connectClient();
        this.sendChannelPost("connect", channel.getClientId());
        return id;
    }

    public void disconnectClient(String token, String connectionId) {
        Channel channel = this.getClientChannelFromToken(token);
        channel.disconnectClient(connectionId);
        this.sendChannelPost("disconnect", channel.getClientId());
    }

    public String getNextClientMessage(String token, String connectionId) {
        Channel channel = this.getClientChannelFromToken(token);
        return channel.getClientMessageQueue(connectionId).poll();
    }

    private void sendChannelPost(String path, String clientId) {
        if (!this.channelPresenceEnabled) {
            return;
        }
        String url = String.format("http://%s:%d/_ah/channel/post/%s", this.localServerEnvironment.getAddress(), this.localServerEnvironment.getPort(), path);
        URLFetchServicePb.URLFetchRequest.Builder requestProto = URLFetchServicePb.URLFetchRequest.newBuilder().setUrl(url).setMethod(URLFetchServicePb.URLFetchRequest.RequestMethod.POST);
        requestProto.addHeaderBuilder().setKey("clientid").setValue(clientId);
        LocalRpcService.Status status = new LocalRpcService.Status();
        this.fetchService.fetch(status, requestProto.build());
    }
}

