/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.channel.dev;

import com.google.appengine.api.channel.ChannelServicePb;
import com.google.appengine.api.channel.dev.ChannelManager;
import com.google.appengine.api.channel.dev.LocalChannelFailureException;
import com.google.appengine.api.urlfetch.dev.LocalURLFetchService;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalChannelService
extends AbstractLocalRpcService {
    public static final String PACKAGE = "channel";
    private ChannelManager channelManager;
    private LocalURLFetchService fetchService;

    public void start() {
    }

    public void stop() {
        this.channelManager = null;
        this.fetchService.stop();
        this.fetchService = null;
    }

    public ChannelManager getChannelManager() {
        return this.channelManager;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.fetchService = new LocalURLFetchService();
        this.fetchService.init(null, new HashMap<String, String>());
        this.fetchService.setTimeoutInMs(30000);
        this.channelManager = new ChannelManager(context.getLocalServerEnvironment(), this.fetchService);
    }

    public String getPackage() {
        return PACKAGE;
    }

    public ChannelServicePb.CreateChannelResponse createChannel(LocalRpcService.Status status, ChannelServicePb.CreateChannelRequest request) {
        if (!request.hasApplicationKey() || request.getApplicationKey().equals("")) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY.getValue());
        }
        ChannelServicePb.CreateChannelResponse response = new ChannelServicePb.CreateChannelResponse();
        response.setClientId(this.channelManager.createChannel(request.getApplicationKey()));
        return response;
    }

    public ApiBasePb.VoidProto sendChannelMessage(LocalRpcService.Status status, ChannelServicePb.SendMessageRequest request) {
        if (!request.hasMessage() || request.getMessage().equals("")) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.BAD_MESSAGE.getValue());
        }
        try {
            this.channelManager.sendMessage(request.getApplicationKey(), request.getMessage());
        }
        catch (LocalChannelFailureException e) {
            throw new ApiProxy.ApplicationException(ChannelServicePb.ChannelServiceError.ErrorCode.INVALID_CHANNEL_KEY.getValue());
        }
        ApiBasePb.VoidProto response = new ApiBasePb.VoidProto();
        return response;
    }
}

