/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalRdbms;
import com.google.appengine.api.rdbms.dev.LocalRdbmsProperties;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.apphosting.api.ApiProxy;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRdbmsServiceLocalDriver
extends AbstractLocalRpcService
implements LocalRdbms {
    private static final Logger logger = Logger.getLogger(LocalRdbmsServiceLocalDriver.class.getCanonicalName());
    private static final int[] EMPTY_ROWS_UPDATED = new int[0];
    LocalRdbmsProperties properties;
    private static Map<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> ROW_ID_LIFETIME_MAP = LocalRdbmsServiceLocalDriver.createRowIdLifetimeMap();
    static final Map<Client.MetadataType, Method> METADATA_TYPE_METHOD_MAP = new HashMap<Client.MetadataType, Method>();
    static final Set<Client.MetadataType> UNIMPLEMENTED_METADATA_TYPES;
    private final AtomicLong nextConnectionId = new AtomicLong(0L);
    private final AtomicLong nextStatementId = new AtomicLong(0L);
    final ConcurrentHashMap<String, LocalConnection> connectionMap = new ConcurrentHashMap();

    private static Map<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> createRowIdLifetimeMap() {
        HashMap<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime> map = new HashMap<RowIdLifetime, Client.JdbcDatabaseMetaDataProto.RowIdLifetime>();
        for (Client.JdbcDatabaseMetaDataProto.RowIdLifetime val : Client.JdbcDatabaseMetaDataProto.RowIdLifetime.values()) {
            map.put(com.google.cloud.sql.jdbc.DatabaseMetaData.toRowIdLifetime((Client.JdbcDatabaseMetaDataProto.RowIdLifetime)val), val);
        }
        return map;
    }

    public String getPackage() {
        throw new IllegalStateException("getPackage() not expected on this delegate");
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.properties = new LocalRdbmsProperties(properties).registerDriver();
    }

    public void start() {
    }

    public void stop() {
        for (Map.Entry<String, LocalConnection> entry : this.connectionMap.entrySet()) {
            logger.warning("java.sql.Connection with id " + entry.getKey() + " was not closed.");
            entry.getValue().closeAndClearStatements();
            try {
                entry.getValue().getConnection().close();
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, "Unable to close java.sql.Connection with id " + entry.getKey(), e);
            }
        }
        this.connectionMap.clear();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    @Override
    public OpenConnectionResponse openConnection(LocalRpcService.Status status, OpenConnectionRequest request) {
        try {
            Map<String, String> map = Util.toPropertyMap(request.getPropertyList());
            Connection conn = DriverManager.getConnection(this.properties.getUrl(), Util.getUserNameAndPasswordProperties(map));
            String database = Util.getDatabase(map);
            if (database != null && !database.isEmpty()) {
                conn.setCatalog(database);
            }
            long connectionId = this.nextConnectionId.getAndIncrement();
            this.connectionMap.put(request.getInstance() + connectionId, LocalConnection.create(conn));
            return OpenConnectionResponse.newBuilder().setConnectionId(ByteString.copyFromUtf8((String)Long.toString(connectionId))).build();
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Could not allocate a connection", e);
            return OpenConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(LocalRpcService.Status status, CloseConnectionRequest request) {
        LocalConnection conn = this.connectionMap.remove(request.getInstance() + request.getConnectionId().toStringUtf8());
        if (conn == null) {
            throw this.connectionNotFound();
        }
        try {
            conn.getConnection().close();
        }
        catch (SQLException e) {
            return CloseConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
        return CloseConnectionResponse.newBuilder().build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        conn = this.getConnectionById(request.getInstance(), request.getConnectionId());
        statement = null;
        rs = null;
        resultBuilder = Client.ResultProto.newBuilder();
        sqlException = null;
        updatedRows = LocalRdbmsServiceLocalDriver.EMPTY_ROWS_UPDATED;
        try {
            generatedKeys = LocalRdbmsServiceLocalDriver.getGeneratedKeys(conn, request);
            if (request.getStatementType() == ExecRequest.StatementType.CALLABLE_STATEMENT) {
                cs = this.buildCallableStatement(conn, request);
                executeResult = cs.execute();
                statement = cs;
                this.populateOutParameters(request, cs, resultBuilder);
            } else if (request.getStatementType() == ExecRequest.StatementType.PREPARED_STATEMENT) {
                ps = this.buildPreparedStatement(conn, request);
                if (LocalRdbmsServiceLocalDriver.isBatch(request)) {
                    updatedRows = ps.executeBatch();
                    executeResult = false;
                } else {
                    executeResult = ps.execute();
                }
                statement = ps;
            } else {
                statement = this.buildStatement(conn, request);
                if (LocalRdbmsServiceLocalDriver.isBatch(request)) {
                    updatedRows = statement.executeBatch();
                    executeResult = false;
                } else {
                    executeResult = generatedKeys != false ? statement.execute(request.getStatement(), 1) : statement.execute(request.getStatement());
                }
            }
            if (LocalRdbmsServiceLocalDriver.isBatch(request)) {
                for (int row : updatedRows) {
                    resultBuilder.addBatchRowsUpdated((long)row);
                }
            } else if (executeResult) {
                rs = statement.getResultSet();
                this.populateResultFromResultSet(resultBuilder, conn, statement, rs);
            } else {
                resultBuilder.setRowsUpdated((long)statement.getUpdateCount());
                if (generatedKeys) {
                    this.populateGeneratedKeys(statement, resultBuilder);
                }
            }
            this.populateSqlWarnings(statement, resultBuilder);
        }
        catch (SQLException e) {
            try {
                sqlException = e;
            }
            catch (Throwable var15_18) {
                v1 = closeException = resultBuilder.getMoreResults() != false ? LocalRdbmsServiceLocalDriver.closeAll(null, rs) : LocalRdbmsServiceLocalDriver.closeAll(statement, rs);
                if (sqlException == null) {
                    sqlException = closeException;
                }
                throw var15_18;
            }
            v2 = closeException = resultBuilder.getMoreResults() != false ? LocalRdbmsServiceLocalDriver.closeAll(null, rs) : LocalRdbmsServiceLocalDriver.closeAll(statement, rs);
            if (sqlException == null) {
                sqlException = closeException;
            } else {
                ** GOTO lbl61
            }
        }
        v0 = closeException = resultBuilder.getMoreResults() != false ? LocalRdbmsServiceLocalDriver.closeAll(null, rs) : LocalRdbmsServiceLocalDriver.closeAll(statement, rs);
        if (sqlException == null) {
            sqlException = closeException;
        }
        if (sqlException != null) {
            resultBuilder.setSqlException(Util.toClientSqlException(sqlException));
        }
        return ExecResponse.newBuilder().setResult(resultBuilder).build();
    }

    private void populateOutParameters(ExecRequest request, CallableStatement cs, Client.ResultProto.Builder resultBuilder) throws SQLException {
        for (Client.BindVariableProto bv : request.getBindVariableList()) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.IN) continue;
            Client.BindVariableProto.Builder outParamBuilder = Client.BindVariableProto.newBuilder((Client.BindVariableProto)bv).clearValue();
            if (!bv.hasPosition()) {
                throw Exceptions.newSqlException((String)"Missing position index in output parameter");
            }
            Object value = cs.getObject(bv.getPosition());
            if (!cs.wasNull()) {
                DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
                outParamBuilder.setValue(converter.toByteString(value));
            }
            resultBuilder.addOutputVariable(outParamBuilder);
        }
    }

    private ResultState checkForMoreResults(Statement statement) throws SQLException {
        if (statement.getMoreResults()) {
            return new ResultState(true, -1);
        }
        int updateCount = statement.getUpdateCount();
        return new ResultState(updateCount != -1, updateCount);
    }

    private long storeStatement(LocalConnection conn, Statement statement, List<Client.BindVariableProto> outParameters, int updateCount) {
        long statementId = this.nextStatementId.getAndIncrement();
        conn.storeStatement(statementId, new LocalStatement(statement, outParameters, updateCount));
        return statementId;
    }

    static SQLException closeAll(Statement statement, ResultSet rs) {
        SQLException exception;
        block6: {
            exception = null;
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "Could not close the ResultSet", e);
                    exception = e;
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException e) {
                    logger.log(Level.SEVERE, "Could not close the Statement", e);
                    if (exception != null) break block6;
                    exception = e;
                }
            }
        }
        return exception;
    }

    private void populateResultFromResultSet(Client.ResultProto.Builder resultBuilder, LocalConnection conn, Statement statement, ResultSet rs) throws SQLException {
        ResultState resultState;
        Client.RowSetProto.Builder rowSetBuilder = Client.RowSetProto.newBuilder();
        ResultSetMetaData rsmd = rs.getMetaData();
        for (int col = 1; col <= rsmd.getColumnCount(); ++col) {
            this.populateRowSetFromResultSetMetaData(rowSetBuilder, rsmd, col);
        }
        while (rs.next()) {
            this.populateRowSetFromResultSet(rowSetBuilder, rsmd, rs);
        }
        resultBuilder.setRows(rowSetBuilder);
        if (statement != null && conn != null && (resultState = this.checkForMoreResults(statement)).hasMore) {
            long statementId = this.storeStatement(conn, statement, resultBuilder.getOutputVariableList(), resultState.updateCount);
            resultBuilder.setStatementId(statementId);
            resultBuilder.setMoreResults(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateGeneratedKeys(Statement stmt, Client.ResultProto.Builder resultBuilder) throws SQLException {
        ResultSet rs = stmt.getGeneratedKeys();
        try {
            while (rs.next()) {
                resultBuilder.addGeneratedKeys(ByteString.copyFromUtf8((String)rs.getString(1)));
            }
        }
        finally {
            LocalRdbmsServiceLocalDriver.closeAll(null, rs);
        }
    }

    private void populateSqlWarnings(Statement stmt, Client.ResultProto.Builder resultBuilder) throws SQLException {
        for (SQLWarning warning = stmt.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            resultBuilder.addWarnings(Util.toClientSqlException(warning));
        }
    }

    private void populateRowSetFromResultSet(Client.RowSetProto.Builder rowSetBuilder, ResultSetMetaData rsmd, ResultSet rs) throws SQLException {
        Client.TupleProto.Builder tupleBuilder = Client.TupleProto.newBuilder();
        for (int colNum = 1; colNum <= rsmd.getColumnCount(); ++colNum) {
            JdbcType jdbcType = JdbcType.fromCode((int)rsmd.getColumnType(colNum));
            DataTypeConverter converter = jdbcType.getConverter();
            ByteString value = converter.toByteString(rs.getObject(colNum));
            if (rs.wasNull()) {
                tupleBuilder.addNulls(colNum - 1);
                continue;
            }
            tupleBuilder.addValues(value);
        }
        rowSetBuilder.addTuples(tupleBuilder);
    }

    private void populateRowSetFromResultSetMetaData(Client.RowSetProto.Builder rowSetBuilder, ResultSetMetaData rsmd, int col) throws SQLException {
        String catalogName;
        String schemaName;
        Client.ColumnProto.Builder columnBuilder = Client.ColumnProto.newBuilder();
        columnBuilder.setName(rsmd.getColumnName(col));
        String label = rsmd.getColumnLabel(col);
        if (label != null) {
            columnBuilder.setLabel(label);
        }
        JdbcType jdbcType = JdbcType.fromCode((int)rsmd.getColumnType(col));
        columnBuilder.setType(jdbcType.getCode());
        String tableName = rsmd.getTableName(col);
        if (tableName != null) {
            columnBuilder.setTableName(tableName);
        }
        if ((schemaName = rsmd.getSchemaName(col)) != null) {
            columnBuilder.setSchemaName(schemaName);
        }
        if ((catalogName = rsmd.getCatalogName(col)) != null) {
            columnBuilder.setCatalogName(catalogName);
        }
        columnBuilder.setPrecision(rsmd.getPrecision(col));
        columnBuilder.setScale(rsmd.getScale(col));
        columnBuilder.setNullable(1 == rsmd.isNullable(col));
        columnBuilder.setSearchable(rsmd.isSearchable(col));
        columnBuilder.setDisplaySize(rsmd.getColumnDisplaySize(col));
        columnBuilder.setAutoIncrement(rsmd.isAutoIncrement(col));
        columnBuilder.setCaseSensitive(rsmd.isCaseSensitive(col));
        columnBuilder.setCurrency(rsmd.isCurrency(col));
        columnBuilder.setDefinitelyWritable(rsmd.isDefinitelyWritable(col));
        columnBuilder.setReadOnly(rsmd.isReadOnly(col));
        columnBuilder.setSigned(rsmd.isSigned(col));
        columnBuilder.setWritable(rsmd.isWritable(col));
        String columnTypeName = rsmd.getColumnTypeName(col);
        if (columnTypeName != null) {
            columnBuilder.setColumnTypeName(columnTypeName);
        }
        rowSetBuilder.addColumns(columnBuilder);
    }

    private void bindInputVariables(ExecRequest request, PreparedStatement ps) throws SQLException {
        if (LocalRdbmsServiceLocalDriver.isBatch(request)) {
            for (Client.BatchBindVariableProto bbv : request.getBatch().getBatchBindVariableList()) {
                this.bindInputVariables(request, ps, bbv.getBindVariableList());
                ps.addBatch();
            }
        } else {
            this.bindInputVariables(request, ps, request.getBindVariableList());
        }
    }

    private void bindInputVariables(ExecRequest request, PreparedStatement ps, List<Client.BindVariableProto> bvs) throws SQLException {
        for (Client.BindVariableProto bv : bvs) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.OUT) continue;
            DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
            if (bv.hasValue()) {
                ps.setObject(bv.getPosition(), converter.toObject(bv.getValue()));
                continue;
            }
            ps.setNull(bv.getPosition(), bv.getType());
        }
    }

    private Statement buildStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        Statement stmt = conn.getConnection().createStatement();
        if (LocalRdbmsServiceLocalDriver.isBatch(request)) {
            for (String sql : request.getBatch().getStatementList()) {
                stmt.addBatch(sql);
            }
        }
        return stmt;
    }

    private PreparedStatement buildPreparedStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        PreparedStatement ps = LocalRdbmsServiceLocalDriver.getGeneratedKeys(conn, request) ? conn.getConnection().prepareStatement(request.getStatement(), 1) : conn.getConnection().prepareStatement(request.getStatement());
        this.bindInputVariables(request, ps);
        return ps;
    }

    private CallableStatement buildCallableStatement(LocalConnection conn, ExecRequest request) throws SQLException {
        CallableStatement cs = conn.getConnection().prepareCall(request.getStatement());
        this.bindInputVariables(request, cs);
        for (Client.BindVariableProto bv : request.getBindVariableList()) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.IN) continue;
            cs.registerOutParameter(bv.getPosition(), bv.getType());
        }
        return cs;
    }

    private static boolean isBatch(ExecRequest request) {
        if (request.hasBatch()) {
            Client.BatchProto batch = request.getBatch();
            return batch.getBatchBindVariableCount() > 0 || batch.getStatementCount() > 0;
        }
        return false;
    }

    private static boolean getGeneratedKeys(LocalConnection conn, ExecRequest request) throws SQLException {
        return request.getOptions().getIncludeGeneratedKeys() && conn.getMetaData().supportsGetGeneratedKeys();
    }

    @Override
    public ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        ExecOpResponse.Builder responseBuilder = ExecOpResponse.newBuilder();
        LocalConnection conn = this.getConnectionById(request.getInstance(), request.getConnectionId());
        Client.OpProto op = request.getOp();
        try {
            switch (op.getType()) {
                case NATIVE_SQL: {
                    String response = conn.getConnection().nativeSQL(op.getSql());
                    responseBuilder.setNativeSql(response);
                    break;
                }
                case ROLLBACK: {
                    if (op.hasSavepoint()) {
                        Savepoint savepoint = this.getSavepoint(conn, op);
                        conn.getConnection().rollback(savepoint);
                        break;
                    }
                    conn.getConnection().rollback();
                    break;
                }
                case SET_CATALOG: {
                    conn.getConnection().setCatalog(op.getCatalog());
                    break;
                }
                case SET_SAVEPOINT: {
                    Savepoint savepoint;
                    if (op.hasSavepoint() && op.getSavepoint().hasName()) {
                        savepoint = conn.getConnection().setSavepoint(op.getSavepoint().getName());
                        conn.getSavepointsByName().put(op.getSavepoint().getName(), savepoint);
                    } else {
                        savepoint = conn.getConnection().setSavepoint();
                        conn.getSavepointsById().put(Integer.valueOf(savepoint.getSavepointId()).longValue(), savepoint);
                    }
                    responseBuilder.setSavepoint(this.savepointAsClientSavepoint(savepoint));
                    break;
                }
                case SET_AUTO_COMMIT: {
                    conn.getConnection().setAutoCommit(op.getAutoCommit());
                    break;
                }
                case SET_READ_ONLY: {
                    conn.getConnection().setReadOnly(op.getReadOnly());
                    break;
                }
                case SET_TRANSACTION_ISOLATION_LEVEL: {
                    conn.getConnection().setTransactionIsolation(op.getTransactionIsolationLevel().getNumber());
                    break;
                }
                case CLOSE_STATEMENT: {
                    break;
                }
                case COMMIT: {
                    conn.getConnection().commit();
                    break;
                }
                case PING: {
                    try {
                        if (!conn.getConnection().isValid(5000)) {
                            responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("Connection not valid"));
                        }
                    }
                    catch (AbstractMethodError e) {}
                    break;
                }
                case NEXT_RESULT: {
                    this.getNextResult(op.getStatementId(), responseBuilder, conn);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported OpType " + op.getType());
                }
            }
        }
        catch (SQLException e) {
            logger.log(Level.SEVERE, "Could not perform the requested operation: " + op.getType(), e);
            responseBuilder.setSqlException(Util.toClientSqlException(e));
        }
        return responseBuilder.build();
    }

    private void getNextResult(long statementId, ExecOpResponse.Builder responseBuilder, LocalConnection conn) throws SQLException {
        LocalStatement localStmt = conn.getStatementById(statementId);
        if (localStmt == null) {
            responseBuilder.setSqlException(Client.SqlException.newBuilder().setCode(0).setMessage("There is no next result"));
            return;
        }
        Client.ResultProto.Builder resultBuilder = responseBuilder.getResultBuilder();
        responseBuilder.getResultBuilder().addAllOutputVariable((Iterable)localStmt.outParameters);
        if (localStmt.lastUpdateCount == -1L) {
            ResultSet rs = localStmt.statement.getResultSet();
            try {
                this.populateResultFromResultSet(resultBuilder, conn, localStmt.statement, rs);
            }
            catch (SQLException e) {
                LocalRdbmsServiceLocalDriver.closeAll(localStmt.statement, rs);
                conn.removeStatementById(statementId);
                throw e;
            }
            SQLException closeException = LocalRdbmsServiceLocalDriver.closeAll(null, rs);
            if (closeException != null) {
                LocalRdbmsServiceLocalDriver.closeAll(localStmt.statement, null);
                conn.removeStatementById(statementId);
                throw closeException;
            }
        } else {
            resultBuilder.setRowsUpdated(localStmt.lastUpdateCount);
        }
        try {
            ResultState resultState = this.checkForMoreResults(localStmt.statement);
            if (resultState.hasMore) {
                localStmt.lastUpdateCount = resultState.updateCount;
            }
            resultBuilder.setMoreResults(resultState.hasMore);
        }
        catch (SQLException e) {
            LocalRdbmsServiceLocalDriver.closeAll(localStmt.statement, null);
            conn.removeStatementById(statementId);
            throw e;
        }
        if (!resultBuilder.getMoreResults()) {
            LocalRdbmsServiceLocalDriver.closeAll(localStmt.statement, null);
            conn.removeStatementById(statementId);
        }
    }

    private Savepoint getSavepoint(LocalConnection conn, Client.OpProto op) throws SQLException {
        Client.SavePoint clientSavepoint = op.getSavepoint();
        Savepoint savepoint = clientSavepoint.hasId() ? conn.getSavepointsById().get(clientSavepoint.getId()) : conn.getSavepointsByName().get(clientSavepoint.getName());
        if (savepoint == null) {
            throw new SQLException("savepoint not found");
        }
        return savepoint;
    }

    private Client.SavePoint savepointAsClientSavepoint(Savepoint savepoint) throws SQLException {
        Client.SavePoint.Builder builder = Client.SavePoint.newBuilder();
        try {
            builder.setName(savepoint.getSavepointName());
        }
        catch (SQLException e) {
            builder.setId((long)savepoint.getSavepointId());
            builder.setName("");
        }
        return builder.build();
    }

    private <T> T bindVariableToObject(Client.BindVariableProto bv, Class<T> clazz) throws SQLException {
        DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
        if (bv.hasValue()) {
            return clazz.cast(converter.toObject(bv.getValue()));
        }
        return null;
    }

    private ResultSet invoke(DatabaseMetaData dmd, MetadataRequest request, Method m) throws SQLException {
        Object[] params = new Object[request.getBindVariableCount()];
        for (int i = 0; i < request.getBindVariableCount(); ++i) {
            params[i] = this.bindVariableToObject(request.getBindVariable(i), Object.class);
        }
        try {
            return (ResultSet)m.invoke((Object)dmd, params);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof SQLException) {
                throw (SQLException)targetException;
            }
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new RuntimeException("Unexpected exception type.", targetException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request) {
        MetadataResponse.Builder responseBuilder = MetadataResponse.newBuilder();
        LocalConnection conn = this.getConnectionById(request.getInstance(), request.getConnectionId());
        Client.ResultProto.Builder resultProtoBuilder = Client.ResultProto.newBuilder();
        ResultSet rs = null;
        SQLException sqlException = null;
        try {
            DatabaseMetaData dmd = conn.getMetaData();
            if (UNIMPLEMENTED_METADATA_TYPES.contains(request.getMetadata())) {
                sqlException = Exceptions.newNotYetImplementedException();
            } else if (request.getMetadata() == Client.MetadataType.METADATATYPE_DATABASE_METADATA_BASIC) {
                Client.JdbcDatabaseMetaDataProto metaDataProto = this.databaseMetaDataToMetaDataProto(dmd);
                responseBuilder.setJdbcDatabaseMetadata(metaDataProto);
            } else if (request.getMetadata() == Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLES) {
                String typesList;
                String catalog = this.bindVariableToObject(request.getBindVariable(0), String.class);
                String schemaPattern = this.bindVariableToObject(request.getBindVariable(1), String.class);
                String tablePattern = this.bindVariableToObject(request.getBindVariable(2), String.class);
                String[] types = null;
                if (request.getBindVariableCount() >= 4 && (typesList = this.bindVariableToObject(request.getBindVariable(3), String.class)) != null) {
                    types = typesList.split(",");
                }
                rs = dmd.getTables(catalog, schemaPattern, tablePattern, types);
            } else {
                Method m = METADATA_TYPE_METHOD_MAP.get(request.getMetadata());
                if (m == null) {
                    throw new UnsupportedOperationException("Unknown metadata operation " + request.getMetadata());
                }
                rs = this.invoke(dmd, request, m);
            }
            if (rs != null) {
                this.populateResultFromResultSet(resultProtoBuilder, null, null, rs);
            }
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            SQLException closeException = LocalRdbmsServiceLocalDriver.closeAll(null, rs);
            if (sqlException == null) {
                sqlException = closeException;
            }
        }
        if (sqlException != null) {
            logger.log(Level.SEVERE, "Could not get Metadata", sqlException);
            resultProtoBuilder.setSqlException(Util.toClientSqlException(sqlException));
        }
        if (resultProtoBuilder.hasRows() || resultProtoBuilder.hasSqlException()) {
            responseBuilder.setResult(resultProtoBuilder);
        }
        return responseBuilder.build();
    }

    private Client.JdbcDatabaseMetaDataProto databaseMetaDataToMetaDataProto(DatabaseMetaData dmd) throws SQLException {
        boolean hasJava6MethodImpls = this.hasJava6MethodImpls(dmd);
        Client.JdbcDatabaseMetaDataProto.Builder builder = Client.JdbcDatabaseMetaDataProto.newBuilder();
        builder.setAllProceduresAreCallable(dmd.allProceduresAreCallable());
        builder.setAllTablesAreSelectable(dmd.allTablesAreSelectable());
        if (hasJava6MethodImpls) {
            builder.setAutoCommitFailureClosesAllResultSets(dmd.autoCommitFailureClosesAllResultSets());
        }
        builder.setCatalogAtStart(dmd.isCatalogAtStart());
        builder.addAllCatalogs(LocalRdbmsServiceLocalDriver.singleColumnResultSetToStringList(dmd.getCatalogs()));
        builder.setCatalogSeparator(dmd.getCatalogSeparator());
        builder.setCatalogTerm(dmd.getCatalogTerm());
        builder.setDatabaseMajorVersion(dmd.getDatabaseMajorVersion());
        builder.setDatabaseMinorVersion(dmd.getDatabaseMinorVersion());
        builder.setDatabaseProductName("Speckle/" + dmd.getDatabaseProductName());
        builder.setDatabaseProductVersion(dmd.getDatabaseProductVersion());
        builder.setDataDefinitionCausesTransactionCommit(dmd.dataDefinitionCausesTransactionCommit());
        builder.setDataDefinitionIgnoredInTransactions(dmd.dataDefinitionIgnoredInTransactions());
        builder.setDefaultTransactionIsolation(Client.TransactionIsolationLevel.valueOf((int)dmd.getDefaultTransactionIsolation()));
        builder.setDoesMaxRowSizeIncludeBlobs(dmd.doesMaxRowSizeIncludeBlobs());
        builder.setExtraNameCharacters(dmd.getExtraNameCharacters());
        builder.setIdentifierQuoteString(dmd.getIdentifierQuoteString());
        builder.setJdbcMajorVersion(dmd.getJDBCMajorVersion());
        builder.setJdbcMinorVersion(dmd.getJDBCMinorVersion());
        builder.setLocatorsUpdateCopy(dmd.locatorsUpdateCopy());
        builder.setMaxBinaryLiteralLength(dmd.getMaxBinaryLiteralLength());
        builder.setMaxCatalogNameLength(dmd.getMaxCatalogNameLength());
        builder.setMaxCharLiteralLength(dmd.getMaxCharLiteralLength());
        builder.setMaxColumnNameLength(dmd.getMaxColumnNameLength());
        builder.setMaxColumnsInGroupBy(dmd.getMaxColumnsInGroupBy());
        builder.setMaxColumnsInIndex(dmd.getMaxColumnsInIndex());
        builder.setMaxColumnsInOrderBy(dmd.getMaxColumnsInOrderBy());
        builder.setMaxColumnsInSelect(dmd.getMaxColumnsInSelect());
        builder.setMaxColumnsInTable(dmd.getMaxColumnsInTable());
        builder.setMaxConnections(dmd.getMaxConnections());
        builder.setMaxCursorNameLength(dmd.getMaxCursorNameLength());
        builder.setMaxIndexLength(dmd.getMaxIndexLength());
        builder.setMaxProcedureNameLength(dmd.getMaxProcedureNameLength());
        builder.setMaxRowSize(dmd.getMaxRowSize());
        builder.setMaxSchemaNameLength(dmd.getMaxSchemaNameLength());
        builder.setMaxStatementLength(dmd.getMaxStatementLength());
        builder.setMaxStatements(dmd.getMaxStatements());
        builder.setMaxTableNameLength(dmd.getMaxTableNameLength());
        builder.setMaxTablesInSelect(dmd.getMaxTablesInSelect());
        builder.setMaxUserNameLength(dmd.getMaxUserNameLength());
        builder.setNullPlusNonNullIsNull(dmd.nullPlusNonNullIsNull());
        builder.setNullsAreSortedAtEnd(dmd.nullsAreSortedAtEnd());
        builder.setNullsAreSortedAtStart(dmd.nullsAreSortedAtStart());
        builder.setNullsAreSortedHigh(dmd.nullsAreSortedHigh());
        builder.setNullsAreSortedLow(dmd.nullsAreSortedLow());
        builder.setNumericFunctions(dmd.getNumericFunctions());
        builder.setProcedureTerm(dmd.getProcedureTerm());
        builder.setReadOnly(dmd.isReadOnly());
        builder.setResultsetHoldability(Client.ResultSetHoldability.valueOf((int)dmd.getResultSetHoldability()));
        if (hasJava6MethodImpls) {
            builder.setRowidLifetime(ROW_ID_LIFETIME_MAP.get((Object)dmd.getRowIdLifetime()));
        }
        builder.setSchemaTerm(dmd.getSchemaTerm());
        builder.setSearchStringEscape(dmd.getSearchStringEscape());
        builder.setSqlKeywords(dmd.getSQLKeywords());
        Client.JdbcDatabaseMetaDataProto.SqlStateType sqlStateType = this.sqlStateTypeToProtoVal(dmd.getSQLStateType());
        builder.setSqlStateType(sqlStateType);
        builder.setStoresLowerCaseIdentifiers(dmd.storesLowerCaseIdentifiers());
        builder.setStoresLowerCaseQuotedIdentifiers(dmd.storesLowerCaseQuotedIdentifiers());
        builder.setStoresMixedCaseIdentifiers(dmd.storesMixedCaseIdentifiers());
        builder.setStoresMixedCaseQuotedIdentifiers(dmd.storesMixedCaseQuotedIdentifiers());
        builder.setStoresUpperCaseIdentifiers(dmd.storesUpperCaseIdentifiers());
        builder.setStoresUpperCaseQuotedIdentifiers(dmd.storesUpperCaseQuotedIdentifiers());
        builder.setStringFunctions(dmd.getStringFunctions());
        builder.setSupportsAlterTableWithAddColumn(dmd.supportsAlterTableWithAddColumn());
        builder.setSupportsAlterTableWithDropColumn(dmd.supportsAlterTableWithDropColumn());
        builder.setSupportsAnsi92EntryLevelSql(dmd.supportsANSI92EntryLevelSQL());
        builder.setSupportsAnsi92FullSql(dmd.supportsANSI92FullSQL());
        builder.setSupportsAnsi92IntermediateSql(dmd.supportsANSI92IntermediateSQL());
        builder.setSupportsBatchUpdates(dmd.supportsBatchUpdates());
        builder.setSupportsCatalogsInDataManipulation(dmd.supportsCatalogsInDataManipulation());
        builder.setSupportsCatalogsInIndexDefinitions(dmd.supportsCatalogsInIndexDefinitions());
        builder.setSupportsCatalogsInPrivilegeDefinitions(dmd.supportsCatalogsInPrivilegeDefinitions());
        builder.setSupportsCatalogsInProcedureCalls(dmd.supportsCatalogsInProcedureCalls());
        builder.setSupportsCatalogsInTableDefinitions(dmd.supportsCatalogsInTableDefinitions());
        builder.setSupportsColumnAliasing(dmd.supportsColumnAliasing());
        builder.setSupportsConvert(dmd.supportsConvert());
        builder.setSupportsCoreSqlGrammar(dmd.supportsCoreSQLGrammar());
        builder.setSupportsCorrelatedSubqueries(dmd.supportsCorrelatedSubqueries());
        builder.setSupportsDataDefinitionAndDataManipulationTransactions(dmd.supportsDataDefinitionAndDataManipulationTransactions());
        builder.setSupportsDataManipulationTransactionsOnly(dmd.supportsDataManipulationTransactionsOnly());
        builder.setSupportsDifferentTableCorrelationNames(dmd.supportsDifferentTableCorrelationNames());
        builder.setSupportsExpressionsInOrderBy(dmd.supportsExpressionsInOrderBy());
        builder.setSupportsExtendedSqlGrammar(dmd.supportsExtendedSQLGrammar());
        builder.setSupportsFullOuterJoins(dmd.supportsFullOuterJoins());
        builder.setSupportsGetGeneratedKeys(dmd.supportsGetGeneratedKeys());
        builder.setSupportsGroupBy(dmd.supportsGroupBy());
        builder.setSupportsGroupByBeyondSelect(dmd.supportsGroupByBeyondSelect());
        builder.setSupportsGroupByUnrelated(dmd.supportsGroupByUnrelated());
        builder.setSupportsIntegrityEnhancementFacility(dmd.supportsIntegrityEnhancementFacility());
        builder.setSupportsLikeEscapeClause(dmd.supportsLikeEscapeClause());
        builder.setSupportsLimitedOuterJoins(dmd.supportsLimitedOuterJoins());
        builder.setSupportsMinimumSqlGrammar(dmd.supportsMinimumSQLGrammar());
        builder.setSupportsMixedCaseIdentifiers(dmd.supportsMixedCaseIdentifiers());
        builder.setSupportsMixedCaseQuotedIdentifiers(dmd.supportsMixedCaseQuotedIdentifiers());
        builder.setSupportsMultipleOpenResults(dmd.supportsMultipleOpenResults());
        builder.setSupportsMultipleResultSets(dmd.supportsMultipleResultSets());
        builder.setSupportsMultipleTransactions(dmd.supportsMultipleTransactions());
        builder.setSupportsNamedParameters(dmd.supportsNamedParameters());
        builder.setSupportsNonNullableColumns(dmd.supportsNonNullableColumns());
        builder.setSupportsOpenCursorsAcrossCommit(dmd.supportsOpenCursorsAcrossCommit());
        builder.setSupportsOpenCursorsAcrossRollback(dmd.supportsOpenCursorsAcrossRollback());
        builder.setSupportsOpenStatementsAcrossCommit(dmd.supportsOpenStatementsAcrossCommit());
        builder.setSupportsOpenStatementsAcrossRollback(dmd.supportsOpenStatementsAcrossRollback());
        builder.setSupportsOrderByUnrelated(dmd.supportsOrderByUnrelated());
        builder.setSupportsOuterJoins(dmd.supportsOuterJoins());
        builder.setSupportsPositionedDelete(dmd.supportsPositionedDelete());
        builder.setSupportsPositionedUpdate(dmd.supportsPositionedUpdate());
        builder.setSupportsSavepoints(dmd.supportsSavepoints());
        builder.setSupportsSchemasInDataManipulation(dmd.supportsSchemasInDataManipulation());
        builder.setSupportsSchemasInIndexDefinitions(dmd.supportsSchemasInIndexDefinitions());
        builder.setSupportsSchemasInPrivilegeDefinitions(dmd.supportsSchemasInPrivilegeDefinitions());
        builder.setSupportsSchemasInProcedureCalls(dmd.supportsSchemasInProcedureCalls());
        builder.setSupportsSchemasInTableDefinitions(dmd.supportsSchemasInTableDefinitions());
        builder.setSupportsSelectForUpdate(dmd.supportsSelectForUpdate());
        builder.setSupportsStatementPooling(dmd.supportsStatementPooling());
        if (hasJava6MethodImpls) {
            builder.setSupportsStoredFunctionsUsingCallSyntax(dmd.supportsStoredFunctionsUsingCallSyntax());
        }
        builder.setSupportsStoredProcedures(dmd.supportsStoredProcedures());
        builder.setSupportsSubqueriesInComparisons(dmd.supportsSubqueriesInComparisons());
        builder.setSupportsSubqueriesInExists(dmd.supportsSubqueriesInExists());
        builder.setSupportsSubqueriesInIns(dmd.supportsSubqueriesInIns());
        builder.setSupportsSubqueriesInQuantifieds(dmd.supportsSubqueriesInQuantifieds());
        builder.setSupportsTableCorrelationNames(dmd.supportsTableCorrelationNames());
        builder.setSupportsTransactions(dmd.supportsTransactions());
        builder.setSupportsUnion(dmd.supportsUnion());
        builder.setSupportsUnionAll(dmd.supportsUnionAll());
        builder.setSystemFunctions(dmd.getSystemFunctions());
        builder.addAllTableTypes(LocalRdbmsServiceLocalDriver.singleColumnResultSetToStringList(dmd.getTableTypes()));
        builder.setTimeDateFunctions(dmd.getTimeDateFunctions());
        builder.setUserName(dmd.getUserName());
        builder.setUsesLocalFilePerTable(dmd.usesLocalFilePerTable());
        builder.setUsesLocalFiles(dmd.usesLocalFiles());
        return builder.build();
    }

    private static List<String> singleColumnResultSetToStringList(ResultSet rs) throws SQLException {
        ArrayList<String> result = new ArrayList<String>();
        while (rs.next()) {
            result.add(rs.getString(1));
        }
        return result;
    }

    private boolean hasJava6MethodImpls(DatabaseMetaData dmd) {
        try {
            Class<?> clazz = dmd.getClass();
            clazz.getDeclaredMethod("autoCommitFailureClosesAllResultSets", new Class[0]);
            return true;
        }
        catch (SecurityException e) {
            return false;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private Client.JdbcDatabaseMetaDataProto.SqlStateType sqlStateTypeToProtoVal(int sqlStateType) {
        switch (sqlStateType) {
            case 2: {
                return Client.JdbcDatabaseMetaDataProto.SqlStateType.SQLSTATETYPE_SQL_STATE_SQL;
            }
            case 1: {
                return Client.JdbcDatabaseMetaDataProto.SqlStateType.SQLSTATETYPE_SQL_STATE_XOPEN;
            }
        }
        throw new IllegalArgumentException("Unknown sql state type constant: " + sqlStateType);
    }

    private LocalConnection getConnectionById(String instance, ByteString connectionId) {
        LocalConnection conn = this.connectionMap.get(instance + connectionId.toStringUtf8());
        if (conn == null) {
            throw this.connectionNotFound();
        }
        return conn;
    }

    ApiProxy.ApplicationException connectionNotFound() {
        return new ApiProxy.ApplicationException(1007, "Invalid connection id");
    }

    static {
        try {
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_ATTRIBUTES, DatabaseMetaData.class.getMethod("getAttributes", String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_BEST_ROW_IDENTIFIER, DatabaseMetaData.class.getMethod("getBestRowIdentifier", String.class, String.class, String.class, Integer.TYPE, Boolean.TYPE));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMN_PRIVILEGES, DatabaseMetaData.class.getMethod("getColumnPrivileges", String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMNS, DatabaseMetaData.class.getMethod("getColumns", String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_CROSS_REFERENCE, DatabaseMetaData.class.getMethod("getCrossReference", String.class, String.class, String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_EXPORTED_KEYS, DatabaseMetaData.class.getMethod("getExportedKeys", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTION_COLUMNS, DatabaseMetaData.class.getMethod("getFunctionColumns", String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTIONS, DatabaseMetaData.class.getMethod("getFunctions", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_IMPORTED_KEYS, DatabaseMetaData.class.getMethod("getImportedKeys", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_INDEX_INFO, DatabaseMetaData.class.getMethod("getIndexInfo", String.class, String.class, String.class, Boolean.TYPE, Boolean.TYPE));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PRIMARY_KEYS, DatabaseMetaData.class.getMethod("getPrimaryKeys", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURE_COLUMNS, DatabaseMetaData.class.getMethod("getProcedureColumns", String.class, String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURES, DatabaseMetaData.class.getMethod("getProcedures", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TABLES, DatabaseMetaData.class.getMethod("getSuperTables", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TYPES, DatabaseMetaData.class.getMethod("getSuperTypes", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLE_PRIVILEGES, DatabaseMetaData.class.getMethod("getTablePrivileges", String.class, String.class, String.class));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SCHEMAS, DatabaseMetaData.class.getMethod("getSchemas", new Class[0]));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TYPE_INFO, DatabaseMetaData.class.getMethod("getTypeInfo", new Class[0]));
            METADATA_TYPE_METHOD_MAP.put(Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_VERSION_COLUMNS, DatabaseMetaData.class.getMethod("getVersionColumns", String.class, String.class, String.class));
        }
        catch (NoSuchMethodException e) {
            logger.log(Level.SEVERE, "Could not initialize method map", e);
            throw new RuntimeException(e);
        }
        UNIMPLEMENTED_METADATA_TYPES = com.google.cloud.sql.jdbc.internal.Util.newHashSet((Comparable[])new Client.MetadataType[]{Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_BEST_ROW_IDENTIFIER, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_COLUMN_PRIVILEGES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTION_COLUMNS, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_FUNCTIONS, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURE_COLUMNS, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_PROCEDURES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SCHEMAS, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TABLES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_SUPER_TYPES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_TABLE_PRIVILEGES, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_UDTS, Client.MetadataType.METADATATYPE_DATABASE_METADATA_GET_VERSION_COLUMNS});
    }

    private static class ResultState {
        private final boolean hasMore;
        private final int updateCount;

        ResultState(boolean hasMore, int updateCount) {
            this.hasMore = hasMore;
            this.updateCount = updateCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LocalStatement {
        private final Statement statement;
        private final List<Client.BindVariableProto> outParameters;
        private long lastUpdateCount;

        LocalStatement(Statement statement, List<Client.BindVariableProto> outParameters, long lastUpdateCount) {
            this.statement = statement;
            this.outParameters = outParameters;
            this.lastUpdateCount = lastUpdateCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class LocalConnection {
        private final Connection connection;
        private final DatabaseMetaData dmd;
        private final Map<Long, Savepoint> savepointsById = new HashMap<Long, Savepoint>();
        private final Map<String, Savepoint> savepointsByName = new HashMap<String, Savepoint>();
        private final Map<Long, LocalStatement> statements = new HashMap<Long, LocalStatement>();

        static LocalConnection create(Connection connection) throws SQLException {
            return new LocalConnection(connection, connection.getMetaData());
        }

        private LocalConnection(Connection connection, DatabaseMetaData dmd) {
            this.connection = connection;
            this.dmd = dmd;
        }

        Connection getConnection() {
            return this.connection;
        }

        DatabaseMetaData getMetaData() {
            return this.dmd;
        }

        Map<Long, Savepoint> getSavepointsById() {
            return this.savepointsById;
        }

        Map<String, Savepoint> getSavepointsByName() {
            return this.savepointsByName;
        }

        void storeStatement(long statementId, LocalStatement statement) {
            this.statements.put(statementId, statement);
        }

        LocalStatement getStatementById(long statementId) {
            return this.statements.get(statementId);
        }

        void removeStatementById(long statementId) {
            this.statements.remove(statementId);
        }

        void closeAndClearStatements() {
            for (LocalStatement localStmt : this.statements.values()) {
                LocalRdbmsServiceLocalDriver.closeAll(localStmt.statement, null);
            }
            this.statements.clear();
        }
    }
}

