/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalRdbms;
import com.google.appengine.api.rdbms.dev.LocalRdbmsProperties;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.SqlState;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalRdbmsServiceRemoteDriver
extends AbstractLocalRpcService
implements LocalRdbms {
    private static final Logger logger = Logger.getLogger(LocalRdbmsServiceRemoteDriver.class.getCanonicalName());
    private static final String CLIENT_FACTORY_ERROR_MESSAGE = "Unable to create Client Factory. Make sure the jar file is located in APPENGINE_SDK_ROOT/lib/impl.";
    private static final String OAUTH2_REFRESH_TOKEN_NOT_FOUND = "OAuth2 refresh token not found. Please connect with the Google SQL Service SQL tool at least one time to enable access to your hosted instance.";
    private static final Client.SqlException CONNECTION_NOT_FOUND_EXCEPTION = Client.SqlException.newBuilder().setCode(1007).setSqlState(SqlState.forError((int)1007)).setMessage("Invalid connection id.").build();
    private SqlClientFactory clientFactory;
    final ConcurrentMap<ByteString, UrlAndRpc> connections = new ConcurrentHashMap<ByteString, UrlAndRpc>();
    LocalRdbmsProperties properties;

    public String getPackage() {
        throw new IllegalStateException("getPackage() not expected on this delegate");
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.properties = new LocalRdbmsProperties(Util.copyAndAdd("rdbms.driver", "com.google.cloud.sql.jdbc.internal.googleapi.GoogleApiDriver", properties)).registerDriver();
    }

    public void start() {
        try {
            this.clientFactory = Class.forName(this.properties.getClientFactoryClass()).asSubclass(SqlClientFactory.class).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Iterator iter = this.connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            try {
                ByteString id = (ByteString)entry.getKey();
                Url url = ((UrlAndRpc)entry.getValue()).url();
                SqlRpc rpc = ((UrlAndRpc)entry.getValue()).rpc();
                try {
                    rpc.closeConnection(SqlRpcOptions.defaultOptions((Url)url), CloseConnectionRequest.newBuilder().setConnectionId(id).setInstance(url.getInstance()).build());
                }
                catch (SQLException ex) {
                    logger.log(Level.FINE, MessageFormat.format("Unable to close connection id %s to instance %s", id, url.getInstance()), ex);
                }
                finally {
                    iter.remove();
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Unexpected exception closing connections.", e);
            }
        }
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    @Override
    public OpenConnectionResponse openConnection(LocalRpcService.Status status, OpenConnectionRequest request) {
        try {
            Map<String, String> props = this.properties.getExtraProperties();
            if (!props.containsKey(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key())) {
                System.out.println("extra properties = " + props);
                String params = props.get(ConnectionProperty.GOOGLEAPI_PARAMS.key());
                if (params == null || !params.contains("fakeUser=1")) {
                    throw new SQLException(OAUTH2_REFRESH_TOKEN_NOT_FOUND, SqlState.forError((int)1007));
                }
            }
            Url url = Url.createFromMap((String)String.format("%s//%s", "jdbc:google:rdbms:", request.getInstance()), Util.concat(Util.toPropertyMap(request.getPropertyList()), props));
            SqlRpc rpc = this.clientFactory.create(url).getRpc();
            OpenConnectionResponse response = rpc.openConnection(SqlRpcOptions.defaultOptions((Url)url), request);
            this.connections.put(response.getConnectionId(), new UrlAndRpc(url, rpc));
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "openConnection", e);
            return OpenConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(LocalRpcService.Status status, CloseConnectionRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.remove(request.getConnectionId());
            if (urlAndRpc == null) {
                return CloseConnectionResponse.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            CloseConnectionResponse response = rpc.closeConnection(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request);
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return CloseConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return ExecResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION)).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            ExecResponse response = rpc.exec(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request);
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return ExecResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(Util.toClientSqlException(e))).build();
        }
    }

    @Override
    public ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return ExecOpResponse.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            ExecOpResponse response = rpc.execOp(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request);
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return ExecOpResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return MetadataResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION)).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            MetadataResponse response = rpc.getMetadata(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request);
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return MetadataResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(Util.toClientSqlException(e))).build();
        }
    }

    static class UrlAndRpc {
        private final Url url;
        private final SqlRpc rpc;

        UrlAndRpc(Url url, SqlRpc rpc) {
            this.url = url;
            this.rpc = rpc;
        }

        Url url() {
            return this.url;
        }

        SqlRpc rpc() {
            return this.rpc;
        }
    }
}

