/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalConnection;
import com.google.appengine.api.rdbms.dev.ResultSets;
import com.google.appengine.api.rdbms.dev.ResultState;
import com.google.appengine.api.rdbms.dev.Statements;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.cloud.sql.jdbc.internal.DataTypeConverter;
import com.google.cloud.sql.jdbc.internal.Exceptions;
import com.google.cloud.sql.jdbc.internal.JdbcType;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class LocalStatement {
    private static final int[] EMPTY_ROWS_UPDATED = new int[0];
    private final long statementId;
    private final LocalConnection conn;
    private Statement statement;
    private ResultSet rs;
    private List<Client.BindVariableProto> outParameters = Collections.emptyList();
    private ResultState resultState = ResultState.noMoreResults();
    private long lastUpdateCount;
    private int fetchSize = -1;
    private boolean execAlreadyCalled;

    private LocalStatement(long statementId, LocalConnection conn) {
        this.statementId = statementId;
        this.conn = conn;
        this.fetchSize = -1;
    }

    static LocalStatement create(long statementId, LocalConnection conn) {
        return new LocalStatement(statementId, conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        if (this.execAlreadyCalled) {
            throw new IllegalStateException("exec can only be called once");
        }
        this.execAlreadyCalled = true;
        Client.ResultProto.Builder resultBuilder = Client.ResultProto.newBuilder();
        SQLException sqlException = null;
        int[] updatedRows = EMPTY_ROWS_UPDATED;
        try {
            boolean executeResult;
            boolean generatedKeys = Statements.getGeneratedKeys(this.conn, request);
            if (request.getStatementType() == ExecRequest.StatementType.CALLABLE_STATEMENT) {
                CallableStatement cs = Statements.buildCallableStatement(this.conn, request);
                executeResult = cs.execute();
                this.statement = cs;
                this.populateOutParameters(request, cs, resultBuilder);
            } else if (request.getStatementType() == ExecRequest.StatementType.PREPARED_STATEMENT) {
                PreparedStatement ps = Statements.buildPreparedStatement(this.conn, request);
                if (Statements.isBatch(request)) {
                    updatedRows = ps.executeBatch();
                    executeResult = false;
                } else {
                    executeResult = ps.execute();
                }
                this.statement = ps;
            } else {
                this.statement = Statements.buildStatement(this.conn, request);
                if (Statements.isBatch(request)) {
                    updatedRows = this.statement.executeBatch();
                    executeResult = false;
                } else {
                    executeResult = generatedKeys ? this.statement.execute(request.getStatement(), 1) : this.statement.execute(request.getStatement());
                }
            }
            if (Statements.isBatch(request)) {
                for (int row : updatedRows) {
                    resultBuilder.addBatchRowsUpdated((long)row);
                }
            } else if (executeResult) {
                this.rs = this.statement.getResultSet();
                if (request.getOptions().hasFetchSize()) {
                    this.fetchSize = request.getOptions().getFetchSize();
                }
                this.resultState = ResultSets.populateResultFromResultSet(resultBuilder, this.statement, this.rs, this.fetchSize);
                if (this.resultState.hasMoreResults() || this.resultState.hasMoreRows()) {
                    resultBuilder.setStatementId(this.statementId);
                    resultBuilder.setMoreResults(this.resultState.hasMoreResults());
                    resultBuilder.setMoreRows(this.resultState.hasMoreRows());
                    this.outParameters = resultBuilder.getOutputVariableList();
                    this.lastUpdateCount = this.resultState.updateCount;
                }
            } else {
                resultBuilder.setRowsUpdated((long)this.statement.getUpdateCount());
                if (generatedKeys) {
                    LocalStatement.populateGeneratedKeys(this.statement, resultBuilder);
                }
            }
            LocalStatement.populateSqlWarnings(this.statement, resultBuilder);
        }
        catch (SQLException e) {
            sqlException = e;
        }
        finally {
            if (!resultBuilder.getMoreResults() && !resultBuilder.getMoreRows()) {
                SQLException closeException = Util.closeAll(this.statement, this.rs);
                if (sqlException == null) {
                    sqlException = closeException;
                }
            }
        }
        if (sqlException != null) {
            resultBuilder.setSqlException(Util.toClientSqlException(sqlException));
        }
        return ExecResponse.newBuilder().setResult(resultBuilder).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecResponse next() {
        Client.ResultProto.Builder resultBuilder;
        block4: {
            resultBuilder = Client.ResultProto.newBuilder();
            try {
                this.resultState = ResultSets.populateResultFromResultSet(resultBuilder, this.statement, this.rs, this.fetchSize);
                if (!this.resultState.hasMoreResults() && !this.resultState.hasMoreRows()) break block4;
                resultBuilder.setStatementId(this.statementId);
                resultBuilder.setMoreResults(this.resultState.hasMoreResults());
                resultBuilder.setMoreRows(this.resultState.hasMoreRows());
                this.outParameters = resultBuilder.getOutputVariableList();
                this.lastUpdateCount = this.resultState.updateCount;
            }
            catch (SQLException e) {
                try {
                    resultBuilder.setSqlException(Util.toClientSqlException(e));
                }
                catch (Throwable throwable) {
                    SQLException closeException = resultBuilder.getMoreResults() || resultBuilder.getMoreRows() ? Util.close(this.rs) : Util.closeAll(this.statement, this.rs);
                    throw throwable;
                }
                SQLException sQLException = resultBuilder.getMoreResults() || resultBuilder.getMoreRows() ? Util.close(this.rs) : Util.closeAll(this.statement, this.rs);
            }
        }
        SQLException closeException = resultBuilder.getMoreResults() || resultBuilder.getMoreRows() ? Util.close(this.rs) : Util.closeAll(this.statement, this.rs);
        return ExecResponse.newBuilder().setResult(resultBuilder).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void populateGeneratedKeys(Statement stmt, Client.ResultProto.Builder resultBuilder) throws SQLException {
        ResultSet rs = stmt.getGeneratedKeys();
        try {
            while (rs.next()) {
                resultBuilder.addGeneratedKeys(ByteString.copyFromUtf8((String)rs.getString(1)));
            }
        }
        finally {
            Util.close(rs);
        }
    }

    private static void populateSqlWarnings(Statement stmt, Client.ResultProto.Builder resultBuilder) throws SQLException {
        for (SQLWarning warning = stmt.getWarnings(); warning != null; warning = warning.getNextWarning()) {
            resultBuilder.addWarnings(Util.toClientSqlException(warning));
        }
    }

    private void populateOutParameters(ExecRequest request, CallableStatement cs, Client.ResultProto.Builder resultBuilder) throws SQLException {
        ArrayList parameterMetadata = com.google.cloud.sql.jdbc.internal.Util.newArrayList();
        int namedPosition = 1;
        for (Client.BindVariableProto bv : request.getBindVariableList()) {
            if (bv.getDirection() == Client.BindVariableProto.Direction.IN) continue;
            Client.BindVariableProto.Builder outParamBuilder = Client.BindVariableProto.newBuilder((Client.BindVariableProto)bv).clearValue();
            Object value = null;
            if (bv.hasPosition()) {
                value = cs.getObject(bv.getPosition());
            } else if (bv.hasName()) {
                outParamBuilder.setPosition(namedPosition++);
                parameterMetadata.add(Client.ParameterMetadata.newBuilder().setName(bv.getName()).build());
                value = cs.getObject(bv.getName());
            } else {
                throw Exceptions.newSqlException((String)"Missing position or name in output parameter");
            }
            if (!cs.wasNull()) {
                DataTypeConverter converter = JdbcType.fromCode((int)bv.getType()).getConverter();
                outParamBuilder.setValue(converter.toByteString(value));
            }
            resultBuilder.addOutputVariable(outParamBuilder.build());
        }
        if (!parameterMetadata.isEmpty()) {
            resultBuilder.addAllParameterMetadata((Iterable)parameterMetadata);
        }
    }

    boolean getNextResult(ExecOpResponse.Builder responseBuilder) throws SQLException {
        this.resultState = ResultState.unknownState();
        Client.ResultProto.Builder resultBuilder = responseBuilder.getResultBuilder();
        responseBuilder.getResultBuilder().addAllOutputVariable(this.outParameters);
        if (this.lastUpdateCount == -1L) {
            Util.close(this.rs);
            this.rs = this.statement.getResultSet();
            try {
                this.resultState = ResultSets.populateResultFromResultSet(resultBuilder, this.statement, this.rs, this.fetchSize);
            }
            catch (SQLException e) {
                Util.closeAll(this.statement, this.rs);
                throw e;
            }
            SQLException closeException = Util.close(this.rs);
            if (closeException != null) {
                Util.close(this.statement);
                throw closeException;
            }
        } else {
            resultBuilder.setRowsUpdated(this.lastUpdateCount);
        }
        try {
            if (this.resultState == ResultState.unknownState()) {
                this.resultState = ResultSets.checkForMoreResultsAndAdvanceResultSet(this.statement);
            }
            if (this.resultState.hasMoreResults()) {
                this.lastUpdateCount = this.resultState.updateCount;
                resultBuilder.setStatementId(this.statementId);
                resultBuilder.setMoreResults(true);
            }
            if (this.resultState.hasMoreRows()) {
                resultBuilder.setStatementId(this.statementId);
                resultBuilder.setMoreRows(true);
            }
        }
        catch (SQLException e) {
            Util.close(this.statement);
            throw e;
        }
        if (!resultBuilder.getMoreResults()) {
            Util.close(this.statement);
            return false;
        }
        return true;
    }

    ResultState getResultState() {
        return this.resultState;
    }

    long getStatementId() {
        return this.statementId;
    }

    void close() {
        Util.close(this.statement);
        Util.close(this.rs);
    }

    public String toString() {
        return "LocalStatement #" + this.getStatementId();
    }
}

