/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.org.apache.commons.httpclient;

import com.google.appengine.repackaged.org.apache.commons.httpclient.HostConfiguration;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnection;
import com.google.appengine.repackaged.org.apache.commons.httpclient.HttpConnectionManager;
import com.google.appengine.repackaged.org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import com.google.appengine.repackaged.org.apache.commons.logging.LogFactory;
import java.io.IOException;
import java.io.InputStream;

public class SimpleHttpConnectionManager
implements HttpConnectionManager {
    private static final Log LOG = LogFactory.getLog(SimpleHttpConnectionManager.class);
    private static final String MISUSE_MESSAGE = "SimpleHttpConnectionManager being used incorrectly.  Be sure that HttpMethod.releaseConnection() is always called and that only one thread and/or method is using this connection manager at a time.";
    protected HttpConnection httpConnection;
    private HttpConnectionManagerParams params = new HttpConnectionManagerParams();
    private long idleStartTime = Long.MAX_VALUE;
    private volatile boolean inUse = false;
    private boolean alwaysClose = false;

    static void finishLastResponse(HttpConnection httpConnection) {
        InputStream inputStream = httpConnection.getLastResponseInputStream();
        if (inputStream != null) {
            httpConnection.setLastResponseInputStream(null);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                httpConnection.close();
            }
        }
    }

    public SimpleHttpConnectionManager(boolean bl) {
        this.alwaysClose = bl;
    }

    public SimpleHttpConnectionManager() {
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration) {
        return this.getConnection(hostConfiguration, 0L);
    }

    public boolean isConnectionStaleCheckingEnabled() {
        return this.params.isStaleCheckingEnabled();
    }

    public void setConnectionStaleCheckingEnabled(boolean bl) {
        this.params.setStaleCheckingEnabled(bl);
    }

    public HttpConnection getConnectionWithTimeout(HostConfiguration hostConfiguration, long l) {
        if (this.httpConnection == null) {
            this.httpConnection = new HttpConnection(hostConfiguration);
            this.httpConnection.setHttpConnectionManager(this);
            this.httpConnection.getParams().setDefaults(this.params);
        } else if (!hostConfiguration.hostEquals(this.httpConnection) || !hostConfiguration.proxyEquals(this.httpConnection)) {
            if (this.httpConnection.isOpen()) {
                this.httpConnection.close();
            }
            this.httpConnection.setHost(hostConfiguration.getHost());
            this.httpConnection.setPort(hostConfiguration.getPort());
            this.httpConnection.setProtocol(hostConfiguration.getProtocol());
            this.httpConnection.setLocalAddress(hostConfiguration.getLocalAddress());
            this.httpConnection.setProxyHost(hostConfiguration.getProxyHost());
            this.httpConnection.setProxyPort(hostConfiguration.getProxyPort());
        } else {
            SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
        }
        this.idleStartTime = Long.MAX_VALUE;
        if (this.inUse) {
            LOG.warn(MISUSE_MESSAGE);
        }
        this.inUse = true;
        return this.httpConnection;
    }

    public HttpConnection getConnection(HostConfiguration hostConfiguration, long l) {
        return this.getConnectionWithTimeout(hostConfiguration, l);
    }

    public void releaseConnection(HttpConnection httpConnection) {
        if (httpConnection != this.httpConnection) {
            throw new IllegalStateException("Unexpected release of an unknown connection.");
        }
        if (this.alwaysClose) {
            this.httpConnection.close();
        } else {
            SimpleHttpConnectionManager.finishLastResponse(this.httpConnection);
        }
        this.inUse = false;
        this.idleStartTime = System.currentTimeMillis();
    }

    public HttpConnectionManagerParams getParams() {
        return this.params;
    }

    public void setParams(HttpConnectionManagerParams httpConnectionManagerParams) {
        if (httpConnectionManagerParams == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        this.params = httpConnectionManagerParams;
    }

    public void closeIdleConnections(long l) {
        long l2 = System.currentTimeMillis() - l;
        if (this.idleStartTime <= l2) {
            this.httpConnection.close();
        }
    }

    public void shutdown() {
        this.httpConnection.close();
    }
}

