/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.BlobstoreServicePb;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.blobstore.dev.BlobStorageFactory;
import com.google.appengine.api.blobstore.dev.BlobUploadSession;
import com.google.appengine.api.blobstore.dev.BlobUploadSessionStorage;
import com.google.appengine.api.blobstore.dev.MemoryBlobStorage;
import com.google.appengine.repackaged.com.google.common.io.ByteStreams;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.utils.config.GenerationDirectory;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalBlobstoreService
extends AbstractLocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalBlobstoreService.class.getName());
    public static final String BACKING_STORE_PROPERTY = "blobstore.backing_store";
    public static final String NO_STORAGE_PROPERTY = "blobstore.no_storage";
    public static final String PACKAGE = "blobstore";
    static final String UPLOAD_URL_PREFIX = "/_ah/upload/";
    private BlobStorage blobStorage;
    private BlobUploadSessionStorage uploadSessionStorage;

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.uploadSessionStorage = new BlobUploadSessionStorage();
        String noStorage = properties.get(NO_STORAGE_PROPERTY);
        if (noStorage != null && Boolean.valueOf(noStorage).booleanValue()) {
            BlobStorageFactory.setMemoryBlobStorage();
        } else {
            String filePath = properties.get(BACKING_STORE_PROPERTY);
            File file = filePath != null ? new File(filePath) : GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            file.mkdirs();
            BlobStorageFactory.setFileBlobStorage(file);
        }
        this.blobStorage = BlobStorageFactory.getBlobStorage();
    }

    public void start() {
    }

    public void stop() {
        if (this.blobStorage instanceof MemoryBlobStorage) {
            ((MemoryBlobStorage)this.blobStorage).deleteAllBlobs();
        }
    }

    public BlobstoreServicePb.CreateUploadURLResponse createUploadURL(LocalRpcService.Status status, BlobstoreServicePb.CreateUploadURLRequest request) {
        String sessionId = this.uploadSessionStorage.createSession(new BlobUploadSession(request.getSuccessPath()));
        BlobstoreServicePb.CreateUploadURLResponse response = new BlobstoreServicePb.CreateUploadURLResponse();
        response.setUrl(UPLOAD_URL_PREFIX + sessionId);
        return response;
    }

    public ApiBasePb.VoidProto deleteBlob(LocalRpcService.Status status, final BlobstoreServicePb.DeleteBlobRequest request) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                for (String blobKeyString : request.blobKeys()) {
                    BlobKey blobKey = new BlobKey(blobKeyString);
                    if (!LocalBlobstoreService.this.blobStorage.hasBlob(blobKey)) continue;
                    try {
                        LocalBlobstoreService.this.blobStorage.deleteBlob(blobKey);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "Could not delete blob: " + blobKey, ex);
                        throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.INTERNAL_ERROR.ordinal(), ex.toString());
                    }
                }
                return null;
            }
        });
        return new ApiBasePb.VoidProto();
    }

    public BlobstoreServicePb.FetchDataResponse fetchData(LocalRpcService.Status status, final BlobstoreServicePb.FetchDataRequest request) {
        if (request.getStartIndex() < 0L) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.DATA_INDEX_OUT_OF_RANGE.ordinal(), "Start index must be >= 0.");
        }
        if (request.getEndIndex() < request.getStartIndex()) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.DATA_INDEX_OUT_OF_RANGE.ordinal(), "End index must be >= startIndex.");
        }
        long fetchSize = request.getEndIndex() - request.getStartIndex() + 1L;
        if (fetchSize > 1015808L) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.BLOB_FETCH_SIZE_TOO_LARGE.ordinal(), "Blob fetch size too large.");
        }
        BlobstoreServicePb.FetchDataResponse response = new BlobstoreServicePb.FetchDataResponse();
        final BlobKey blobKey = new BlobKey(request.getBlobKey());
        BlobInfo blobInfo = new BlobInfoFactory().loadBlobInfo(blobKey);
        if (blobInfo == null) {
            throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.BLOB_NOT_FOUND.ordinal(), "Blob not found.");
        }
        long endIndex = request.getEndIndex() > blobInfo.getSize() - 1L ? blobInfo.getSize() - 1L : request.getEndIndex();
        if (request.getStartIndex() > endIndex) {
            response.setData("");
        } else {
            final byte[] data = new byte[(int)(endIndex - request.getStartIndex() + 1L)];
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        InputStream stream = LocalBlobstoreService.this.blobStorage.fetchBlob(blobKey);
                        ByteStreams.skipFully((InputStream)stream, (long)request.getStartIndex());
                        ByteStreams.readFully((InputStream)stream, (byte[])data);
                    }
                    catch (IOException ex) {
                        logger.log(Level.WARNING, "Could not fetch data: " + blobKey, ex);
                        throw new ApiProxy.ApplicationException(BlobstoreServicePb.BlobstoreServiceError.ErrorCode.INTERNAL_ERROR.ordinal(), ex.toString());
                    }
                    return null;
                }
            });
            response.setDataAsBytes(data);
        }
        return response;
    }
}

