/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore.dev;

import com.google.appengine.api.datastore.EntityProtoComparators;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.dev.DefaultHighRepJobPolicy;
import com.google.appengine.api.datastore.dev.HighRepJobPolicy;
import com.google.appengine.api.datastore.dev.KindPseudoKind;
import com.google.appengine.api.datastore.dev.LocalCompositeIndexManager;
import com.google.appengine.api.datastore.dev.LocalDatastoreJob;
import com.google.appengine.api.datastore.dev.LocalFullTextIndex;
import com.google.appengine.api.datastore.dev.NamespacePseudoKind;
import com.google.appengine.api.datastore.dev.PropertyPseudoKind;
import com.google.appengine.api.datastore.dev.PseudoKinds;
import com.google.appengine.api.datastore.dev.WriteLatencyAdjuster;
import com.google.appengine.api.taskqueue.TaskQueuePb;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Predicate;
import com.google.appengine.repackaged.com.google.common.base.Predicates;
import com.google.appengine.repackaged.com.google.common.collect.Iterators;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.Clock;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ServiceProvider(value=LocalRpcService.class)
public final class LocalDatastoreService
extends AbstractLocalRpcService {
    private static final Logger logger = Logger.getLogger(LocalDatastoreService.class.getName());
    static final int DEFAULT_BATCH_SIZE = 20;
    static final int MAXIMUM_RESULTS_SIZE = 1000;
    public static final String PACKAGE = "datastore_v3";
    public static final String MAX_QUERY_LIFETIME_PROPERTY = "datastore.max_query_lifetime";
    private static final int DEFAULT_MAX_QUERY_LIFETIME = 30000;
    public static final String MAX_TRANSACTION_LIFETIME_PROPERTY = "datastore.max_txn_lifetime";
    private static final int DEFAULT_MAX_TRANSACTION_LIFETIME = 300000;
    public static final String STORE_DELAY_PROPERTY = "datastore.store_delay";
    static final int DEFAULT_STORE_DELAY_MS = 30000;
    public static final String BACKING_STORE_PROPERTY = "datastore.backing_store";
    public static final String NO_INDEX_AUTO_GEN_PROP = "datastore.no_index_auto_gen";
    public static final String NO_STORAGE_PROPERTY = "datastore.no_storage";
    public static final String HIGH_REP_JOB_POLICY_CLASS_PROPERTY = "datastore.high_replication_job_policy_class";
    private static final Pattern RESERVED_NAME = Pattern.compile("^__.*__$");
    private static final Set<String> RESERVED_NAME_WHITELIST = new HashSet<String>(Arrays.asList("__BlobUploadSession__", "__BlobInfo__"));
    static final String ENTITY_GROUP_MESSAGE = "can't operate on multiple entity groups in a single transaction.";
    static final String CONTENTION_MESSAGE = "too much contention on these datastore entities. please try again.";
    static final String TRANSACTION_NOT_FOUND = "transaction not found";
    static final String QUERY_NOT_FOUND = "query not found";
    private final AtomicLong entityId = new AtomicLong(1L);
    private final AtomicLong queryId = new AtomicLong(0L);
    private String backingStore;
    private Map<String, Profile> profiles = Collections.synchronizedMap(new HashMap());
    private Clock clock;
    private static final long MAX_BATCH_GET_KEYS = 1000000000L;
    private static final long MAX_ACTIONS_PER_TXN = 5L;
    private int maxQueryLifetimeMs;
    private int maxTransactionLifetimeMs;
    private final ScheduledThreadPoolExecutor scheduler = new ScheduledThreadPoolExecutor(2, new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            return thread;
        }
    });
    private final RemoveStaleQueries removeStaleQueriesTask = new RemoveStaleQueries();
    private final RemoveStaleTransactions removeStaleTransactionsTask = new RemoveStaleTransactions();
    private final PersistDatastore persistDatastoreTask = new PersistDatastore();
    private final AtomicInteger transactionHandleProvider = new AtomicInteger(0);
    private int storeDelayMs;
    private volatile boolean dirty;
    private final ReadWriteLock globalLock = new ReentrantReadWriteLock();
    private boolean noStorage;
    private Thread shutdownHook;
    private PseudoKinds pseudoKinds;
    private HighRepJobPolicy highRepJobPolicy;
    private boolean isHighRep;
    private static Map<String, SpecialProperty> specialPropertyMap = Collections.singletonMap("__scatter__", SpecialProperty.SCATTER);

    public void clearProfiles() {
        for (Profile profile : this.profiles.values()) {
            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
            if (fullTextIndex == null) continue;
            fullTextIndex.close();
        }
        this.profiles.clear();
    }

    public LocalDatastoreService() {
        this.setMaxQueryLifetime(30000);
        this.setMaxTransactionLifetime(300000);
        this.setStoreDelay(30000);
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.clock = context.getClock();
        String storeFile = properties.get(BACKING_STORE_PROPERTY);
        String noStorageProp = properties.get(NO_STORAGE_PROPERTY);
        if (noStorageProp != null) {
            this.noStorage = Boolean.valueOf(noStorageProp);
        }
        if (storeFile == null && !this.noStorage) {
            File dir = GenerationDirectory.getGenerationDirectory((File)context.getLocalServerEnvironment().getAppDir());
            dir.mkdirs();
            storeFile = dir.getAbsolutePath() + File.separator + "local_db.bin";
        }
        this.setBackingStore(storeFile);
        String storeDelayTime = properties.get(STORE_DELAY_PROPERTY);
        this.storeDelayMs = LocalDatastoreService.parseInt(storeDelayTime, this.storeDelayMs, STORE_DELAY_PROPERTY);
        String maxQueryLifetime = properties.get(MAX_QUERY_LIFETIME_PROPERTY);
        this.maxQueryLifetimeMs = LocalDatastoreService.parseInt(maxQueryLifetime, this.maxQueryLifetimeMs, MAX_QUERY_LIFETIME_PROPERTY);
        String maxTxnLifetime = properties.get(MAX_TRANSACTION_LIFETIME_PROPERTY);
        this.maxTransactionLifetimeMs = LocalDatastoreService.parseInt(maxTxnLifetime, this.maxTransactionLifetimeMs, MAX_TRANSACTION_LIFETIME_PROPERTY);
        LocalCompositeIndexManager.getInstance().setAppDir(context.getLocalServerEnvironment().getAppDir());
        LocalCompositeIndexManager.getInstance().setClock(this.clock);
        String noIndexAutoGenProp = properties.get(NO_INDEX_AUTO_GEN_PROP);
        if (noIndexAutoGenProp != null) {
            LocalCompositeIndexManager.getInstance().setNoIndexAutoGen(Boolean.valueOf(noIndexAutoGenProp));
        }
        this.pseudoKinds = new PseudoKinds();
        this.pseudoKinds.register(new KindPseudoKind(this));
        this.pseudoKinds.register(new PropertyPseudoKind(this));
        this.pseudoKinds.register(new NamespacePseudoKind(this));
        this.initHighRepJobPolicy(properties);
    }

    boolean isHighRep() {
        return this.isHighRep;
    }

    private void initHighRepJobPolicy(Map<String, String> properties) {
        String highRepJobPolicyStr = properties.get(HIGH_REP_JOB_POLICY_CLASS_PROPERTY);
        if (highRepJobPolicyStr == null) {
            DefaultHighRepJobPolicy defaultPolicy = new DefaultHighRepJobPolicy(properties);
            this.isHighRep = defaultPolicy.unappliedJobCutoff > 0;
            this.highRepJobPolicy = defaultPolicy;
        } else {
            this.isHighRep = true;
            try {
                Class<?> highRepJobPolicyCls = Class.forName(highRepJobPolicyStr);
                Constructor<?> ctor = highRepJobPolicyCls.getDeclaredConstructor(new Class[0]);
                ctor.setAccessible(true);
                this.highRepJobPolicy = (HighRepJobPolicy)ctor.newInstance(new Object[0]);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    private static int parseInt(String valStr, int defaultVal, String propName) {
        if (valStr != null) {
            try {
                return Integer.parseInt(valStr);
            }
            catch (NumberFormatException e) {
                logger.log(Level.WARNING, "Expected a numeric value for property " + propName + "but received, " + valStr + ". Resetting property to the default.");
            }
        }
        return defaultVal;
    }

    public void start() {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                LocalDatastoreService.this.start_();
                return null;
            }
        });
    }

    private void start_() {
        this.load();
        this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleQueriesTask, this.maxQueryLifetimeMs * 5, this.maxQueryLifetimeMs * 5, TimeUnit.MILLISECONDS);
        this.scheduler.scheduleWithFixedDelay(this.removeStaleTransactionsTask, this.maxTransactionLifetimeMs * 5, this.maxTransactionLifetimeMs * 5, TimeUnit.MILLISECONDS);
        if (!this.noStorage) {
            this.scheduler.scheduleWithFixedDelay(this.persistDatastoreTask, this.storeDelayMs, this.storeDelayMs, TimeUnit.MILLISECONDS);
        }
        this.shutdownHook = new Thread(){

            public void run() {
                LocalDatastoreService.this.stop();
            }
        };
        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
    }

    public void stop() {
        this.scheduler.shutdown();
        if (!this.noStorage) {
            this.rollForwardAllUnappliedJobs();
            this.persistDatastoreTask.run();
        }
        this.clearProfiles();
        try {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void rollForwardAllUnappliedJobs() {
        for (Profile profile : this.profiles.values()) {
            if (profile.getGroups() == null) continue;
            for (Profile.EntityGroup eg : profile.getGroups().values()) {
                eg.rollForwardUnappliedJobs();
            }
        }
    }

    public void setMaxQueryLifetime(int milliseconds) {
        this.maxQueryLifetimeMs = milliseconds;
    }

    public void setMaxTransactionLifetime(int milliseconds) {
        this.maxTransactionLifetimeMs = milliseconds;
    }

    public void setBackingStore(String backingStore) {
        this.backingStore = backingStore;
    }

    public void setStoreDelay(int delayMs) {
        this.storeDelayMs = delayMs;
    }

    public void setNoStorage(boolean noStorage) {
        this.noStorage = noStorage;
    }

    public String getPackage() {
        return PACKAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=10)
    public DatastorePb.GetResponse get(LocalRpcService.Status status, DatastorePb.GetRequest request) {
        DatastorePb.GetResponse response = new DatastorePb.GetResponse();
        LiveTxn liveTxn = null;
        for (OnestoreEntity.Reference key : request.keys()) {
            Profile profile;
            String app = key.getApp();
            OnestoreEntity.Path groupPath = this.getGroup(key);
            DatastorePb.GetResponse.Entity responseEntity = response.addEntity();
            Profile profile2 = profile = this.getOrCreateProfile(app);
            synchronized (profile2) {
                boolean eventualConsistency;
                OnestoreEntity.EntityProto entity;
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                }
                if ((entity = eg.get(liveTxn, key, eventualConsistency = request.hasFailoverMs() && liveTxn == null)) != null) {
                    responseEntity.getMutableEntity().copyFrom((ProtocolMessage)entity);
                    this.processEntityForSpecialProperties(responseEntity.getMutableEntity(), false);
                }
                profile.groom();
            }
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=30, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastorePb.PutResponse put(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.PutResponse putResponse = this.putImpl(status, request);
            return putResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private void processEntityForSpecialProperties(OnestoreEntity.EntityProto entity, boolean store) {
        Iterator iter = entity.propertyIterator();
        while (iter.hasNext()) {
            if (!LocalDatastoreService.getSpecialPropertyMap().containsKey(((OnestoreEntity.Property)iter.next()).getName())) continue;
            iter.remove();
        }
        for (SpecialProperty specialProp : LocalDatastoreService.getSpecialPropertyMap().values()) {
            OnestoreEntity.PropertyValue value;
            if (!(store ? specialProp.isStored() : specialProp.isVisible()) || (value = specialProp.getValue(entity)) == null) continue;
            entity.addProperty(specialProp.getProperty(value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.PutResponse putImpl(LocalRpcService.Status status, DatastorePb.PutRequest request) {
        Profile profile;
        DatastorePb.PutResponse response = new DatastorePb.PutResponse();
        if (request.entitySize() == 0) {
            return response;
        }
        String app = ((OnestoreEntity.EntityProto)request.entitys().get(0)).getKey().getApp();
        ArrayList<OnestoreEntity.EntityProto> clones = new ArrayList<OnestoreEntity.EntityProto>();
        for (OnestoreEntity.EntityProto entity : request.entitys()) {
            this.validateAndProcessEntityProto(entity);
            OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)entity.clone();
            clones.add(clone);
            Preconditions.checkArgument((boolean)clone.hasKey());
            OnestoreEntity.Reference key = clone.getKey();
            Preconditions.checkArgument((key.getPath().elementSize() > 0 ? 1 : 0) != 0);
            clone.getMutableKey().setApp(app);
            OnestoreEntity.Path.Element lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
            if (lastPath.getId() == 0L && !lastPath.hasName()) {
                lastPath.setId(this.entityId.getAndIncrement());
            }
            this.processEntityForSpecialProperties(clone, true);
            if (clone.getEntityGroup().elementSize() == 0) {
                OnestoreEntity.Path path = clone.getMutableEntityGroup();
                OnestoreEntity.Path.Element root = (OnestoreEntity.Path.Element)key.getPath().elements().get(0);
                OnestoreEntity.Path.Element pathElement = path.addElement();
                pathElement.setType(root.getType());
                if (root.hasName()) {
                    pathElement.setName(root.getName());
                    continue;
                }
                pathElement.setId(root.getId());
                continue;
            }
            Preconditions.checkState((clone.hasEntityGroup() && clone.getEntityGroup().elementSize() > 0 ? 1 : 0) != 0);
        }
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>> entitiesByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.EntityProto>>();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            Profile.EntityGroup eg;
            LiveTxn liveTxn = null;
            for (OnestoreEntity.EntityProto entityProto : clones) {
                eg = profile.getGroup(entityProto.getEntityGroup());
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    eg.addTransaction(liveTxn);
                    liveTxn.addWrittenEntity(entityProto);
                } else {
                    ArrayList<OnestoreEntity.EntityProto> entities = (ArrayList<OnestoreEntity.EntityProto>)entitiesByEntityGroup.get(entityProto.getEntityGroup());
                    if (entities == null) {
                        entities = new ArrayList<OnestoreEntity.EntityProto>();
                        entitiesByEntityGroup.put(entityProto.getEntityGroup(), entities);
                    }
                    entities.add(entityProto);
                }
                response.mutableKeys().add(entityProto.getKey());
            }
            for (final Map.Entry entry : entitiesByEntityGroup.entrySet()) {
                eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

                    public void applyInternal() {
                        for (OnestoreEntity.EntityProto entityProto : (List)entry.getValue()) {
                            String kind = ((OnestoreEntity.Path.Element)LocalDatastoreService.getLast(entityProto.getKey().getPath().elements())).getType();
                            Extent extent = LocalDatastoreService.this.getOrCreateExtent(profile, kind);
                            extent.getEntities().put(entityProto.getKey(), entityProto);
                            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
                            if (fullTextIndex == null) continue;
                            fullTextIndex.write(entityProto);
                        }
                        LocalDatastoreService.this.dirty = true;
                    }
                };
                eg.apply(job);
            }
        }
        if (!request.hasTransaction()) {
            logger.fine("put: " + request.entitySize() + " entities");
        }
        return response;
    }

    private void validateAndProcessEntityProto(OnestoreEntity.EntityProto entity) {
        this.validatePathForPut(entity.getKey());
        for (OnestoreEntity.Property prop : entity.propertys()) {
            this.validateAndProcessProperty(prop);
        }
        for (OnestoreEntity.Property prop : entity.rawPropertys()) {
            this.validateAndProcessProperty(prop);
        }
    }

    private void validatePathForPut(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        for (OnestoreEntity.Path.Element ele : path.elements()) {
            String type = ele.getType();
            if (!RESERVED_NAME.matcher(type).matches() || RESERVED_NAME_WHITELIST.contains(type)) continue;
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), String.format("illegal key.path.element.type: %s", ele.getType()));
        }
    }

    private void validateAndProcessProperty(OnestoreEntity.Property prop) {
        if (RESERVED_NAME.matcher(prop.getName()).matches()) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), String.format("illegal property.name: %s", prop.getName()));
        }
        OnestoreEntity.PropertyValue val = prop.getMutableValue();
        if (val.hasUserValue()) {
            OnestoreEntity.PropertyValue.UserValue userVal = val.getMutableUserValue();
            userVal.setObfuscatedGaiaid(Integer.toString(userVal.getEmail().hashCode()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=40, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastorePb.DeleteResponse delete(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.DeleteResponse deleteResponse = this.deleteImpl(status, request);
            return deleteResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=1)
    public ApiBasePb.VoidProto addActions(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        try {
            this.globalLock.readLock().lock();
            this.addActionsImpl(status, request);
        }
        finally {
            this.globalLock.readLock().unlock();
        }
        return new ApiBasePb.VoidProto();
    }

    private OnestoreEntity.Path getGroup(OnestoreEntity.Reference key) {
        OnestoreEntity.Path path = key.getPath();
        OnestoreEntity.Path group = new OnestoreEntity.Path();
        group.addElement(path.getElement(0));
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatastorePb.DeleteResponse deleteImpl(LocalRpcService.Status status, DatastorePb.DeleteRequest request) {
        DatastorePb.DeleteResponse response = new DatastorePb.DeleteResponse();
        if (request.keySize() == 0) {
            return response;
        }
        String app = ((OnestoreEntity.Reference)request.keys().get(0)).getApp();
        final Profile profile = this.getOrCreateProfile(app);
        LiveTxn liveTxn = null;
        LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>> keysByEntityGroup = new LinkedHashMap<OnestoreEntity.Path, ArrayList<OnestoreEntity.Reference>>();
        Profile profile2 = profile;
        synchronized (profile2) {
            for (OnestoreEntity.Reference reference : request.keys()) {
                OnestoreEntity.Path group = this.getGroup(reference);
                if (request.hasTransaction()) {
                    if (liveTxn == null) {
                        liveTxn = profile.getTxn(request.getTransaction().getHandle());
                    }
                    Profile.EntityGroup eg = profile.getGroup(group);
                    eg.addTransaction(liveTxn);
                    liveTxn.addDeletedEntity(reference);
                    continue;
                }
                ArrayList<OnestoreEntity.Reference> keysToDelete = (ArrayList<OnestoreEntity.Reference>)keysByEntityGroup.get(group);
                if (keysToDelete == null) {
                    keysToDelete = new ArrayList<OnestoreEntity.Reference>();
                    keysByEntityGroup.put(group, keysToDelete);
                }
                keysToDelete.add(reference);
            }
            for (final Map.Entry entry : keysByEntityGroup.entrySet()) {
                Profile.EntityGroup eg = profile.getGroup((OnestoreEntity.Path)entry.getKey());
                eg.incrementVersion();
                LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

                    public void applyInternal() {
                        for (OnestoreEntity.Reference key : (List)entry.getValue()) {
                            OnestoreEntity.Path.Element lastPath;
                            String kind;
                            Map<String, Extent> extents = profile.getExtents();
                            Extent extent = extents.get(kind = (lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType());
                            if (extent == null) continue;
                            extent.getEntities().remove(key);
                            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
                            if (fullTextIndex == null) continue;
                            fullTextIndex.delete(key);
                        }
                        LocalDatastoreService.this.dirty = true;
                    }
                };
                eg.apply(job);
            }
        }
        return new DatastorePb.DeleteResponse();
    }

    private void addActionsImpl(LocalRpcService.Status status, TaskQueuePb.TaskQueueBulkAddRequest request) {
        if (request.addRequestSize() == 0) {
            return;
        }
        ArrayList<TaskQueuePb.TaskQueueAddRequest> addRequests = new ArrayList<TaskQueuePb.TaskQueueAddRequest>(request.addRequestSize());
        for (TaskQueuePb.TaskQueueAddRequest addRequest : request.addRequests()) {
            addRequests.add(((TaskQueuePb.TaskQueueAddRequest)addRequest.clone()).clearTransaction());
        }
        Profile profile = this.profiles.get(((TaskQueuePb.TaskQueueAddRequest)request.addRequests().get(0)).getTransaction().getApp());
        LiveTxn liveTxn = profile.getTxn(((TaskQueuePb.TaskQueueAddRequest)request.addRequests().get(0)).getTransaction().getHandle());
        liveTxn.addActions(addRequests);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=20)
    public DatastorePb.QueryResult runQuery(LocalRpcService.Status status, DatastorePb.Query query) {
        Profile profile;
        final LocalCompositeIndexManager.ValidatedQuery validatedQuery = new LocalCompositeIndexManager.ValidatedQuery(query);
        query = validatedQuery.getQuery();
        String app = query.getApp();
        Profile profile2 = profile = this.getOrCreateProfile(app);
        synchronized (profile2) {
            if (query.hasTransaction() || query.hasAncestor()) {
                OnestoreEntity.Path groupPath = this.getGroup(query.getAncestor());
                Profile.EntityGroup eg = profile.getGroup(groupPath);
                if (query.hasTransaction()) {
                    if (!app.equals(query.getTransaction().getApp())) {
                        throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), "Can't query app " + app + "in a transaction on app " + query.getTransaction().getApp());
                    }
                    LiveTxn liveTxn = profile.getTxn(query.getTransaction().getHandle());
                    eg.addTransaction(liveTxn);
                }
                if (query.hasAncestor() && (query.hasTransaction() || !query.hasFailoverMs())) {
                    eg.rollForwardUnappliedJobs();
                }
            }
            LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
            if (query.hasSearchQuery() && fullTextIndex == null) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "full-text search unsupported");
            }
            List<Object> queryEntities = this.pseudoKinds.runQuery(query);
            if (queryEntities == null) {
                Map<String, Extent> extents = profile.getExtents();
                Extent extent = extents.get(query.getKind());
                if (!query.hasSearchQuery()) {
                    if (extent != null) {
                        queryEntities = new ArrayList<OnestoreEntity.EntityProto>(extent.getEntities().values());
                    } else if (!query.hasKind()) {
                        queryEntities = profile.getAllEntities();
                        if (query.orderSize() == 0) {
                            query.addOrder(new DatastorePb.Query.Order().setDirection(DatastorePb.Query.Order.Direction.ASCENDING).setProperty("__key__"));
                        }
                    }
                } else {
                    List<OnestoreEntity.Reference> keys = fullTextIndex.search(query.getKind(), query.getSearchQuery());
                    ArrayList<OnestoreEntity.EntityProto> entities = new ArrayList<OnestoreEntity.EntityProto>(keys.size());
                    for (OnestoreEntity.Reference key : keys) {
                        entities.add(extent.getEntities().get(key));
                    }
                    queryEntities = entities;
                }
            }
            profile.groom();
            if (queryEntities == null) {
                queryEntities = Collections.emptyList();
            }
            ArrayList<Object> predicates = new ArrayList<Object>();
            if (query.hasAncestor()) {
                final List ancestorPath = query.getAncestor().getPath().elements();
                predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                    public boolean apply(OnestoreEntity.EntityProto entity) {
                        List path = entity.getKey().getPath().elements();
                        return path.size() >= ancestorPath.size() && ((Object)path.subList(0, ancestorPath.size())).equals(ancestorPath);
                    }
                });
            }
            final boolean hasNamespace = query.hasNameSpace();
            final String namespace = query.getNameSpace();
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    OnestoreEntity.Reference ref = entity.getKey();
                    return !(hasNamespace ? !ref.hasNameSpace() || !namespace.equals(ref.getNameSpace()) : ref.hasNameSpace());
                }
            });
            final EntityProtoComparators.EntityProtoComparator entityComparator = new EntityProtoComparators.EntityProtoComparator(validatedQuery.getQuery().orders(), validatedQuery.getQuery().filters());
            predicates.add(new Predicate<OnestoreEntity.EntityProto>(){

                public boolean apply(OnestoreEntity.EntityProto entity) {
                    return entityComparator.matches(entity);
                }
            });
            Iterators.removeIf(queryEntities.iterator(), (Predicate)Predicates.not((Predicate)Predicates.and(predicates)));
            Collections.sort(queryEntities, entityComparator);
            LiveQuery liveQuery = new LiveQuery(queryEntities, query, entityComparator, this.clock);
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    LocalCompositeIndexManager.getInstance().processQuery(validatedQuery.getQuery());
                    return null;
                }
            });
            int count = query.hasCount() ? query.getCount() : (query.hasLimit() ? query.getLimit() : 20);
            DatastorePb.QueryResult result = this.nextImpl(liveQuery, query.getOffset(), count, query.isCompile());
            if (query.isCompile()) {
                result.setCompiledQuery(liveQuery.compileQuery());
            }
            if (result.isMoreResults()) {
                long cursor = this.queryId.getAndIncrement();
                profile.addQuery(cursor, liveQuery);
                result.getMutableCursor().setApp(query.getApp()).setCursor(cursor);
            }
            return result;
        }
    }

    private static <T> T safeGetFromExpiringMap(Map<Long, T> map, long key, String errorMsg) {
        T value = map.get(key);
        if (value == null) {
            throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.INTERNAL_ERROR.getValue(), errorMsg);
        }
        return value;
    }

    @LatencyPercentiles(latency50th=50)
    public DatastorePb.QueryResult next(LocalRpcService.Status status, DatastorePb.NextRequest request) {
        Profile profile = this.profiles.get(request.getCursor().getApp());
        LiveQuery liveQuery = profile.getQuery(request.getCursor().getCursor());
        int count = request.hasCount() ? request.getCount() : 20;
        DatastorePb.QueryResult result = this.nextImpl(liveQuery, request.getOffset(), count, request.isCompile());
        if (result.isMoreResults()) {
            result.setCursor(request.getCursor());
        } else {
            profile.removeQuery(request.getCursor().getCursor());
        }
        return result;
    }

    private DatastorePb.QueryResult nextImpl(LiveQuery liveQuery, int offset, int count, boolean compile) {
        DatastorePb.QueryResult result = new DatastorePb.QueryResult();
        if (offset > 0) {
            result.setSkippedResults(liveQuery.offsetResults(offset));
        }
        if (offset == result.getSkippedResults()) {
            int end = Math.min(1000, count);
            for (OnestoreEntity.EntityProto proto : liveQuery.nextResults(end)) {
                OnestoreEntity.EntityProto clone = (OnestoreEntity.EntityProto)proto.clone();
                this.processEntityForSpecialProperties(clone, false);
                result.addResult(clone);
            }
        }
        result.setMoreResults(liveQuery.entitiesRemaining().size() > 0);
        result.setKeysOnly(liveQuery.isKeysOnly());
        if (compile) {
            result.getMutableCompiledCursor().addPosition(liveQuery.compilePosition());
        }
        return result;
    }

    public ApiBasePb.Integer64Proto count(LocalRpcService.Status status, DatastorePb.Query request) {
        LocalRpcService.Status queryStatus = new LocalRpcService.Status();
        DatastorePb.QueryResult queryResult = this.runQuery(queryStatus, request);
        long cursor = queryResult.getCursor().getCursor();
        Profile profile = this.profiles.get(request.getApp());
        int sizeRemaining = profile.getQuery(cursor).entitiesRemaining().size();
        profile.removeQuery(cursor);
        ApiBasePb.Integer64Proto results = new ApiBasePb.Integer64Proto();
        results.setValue((long)(sizeRemaining + queryResult.resultSize()));
        return results;
    }

    public ApiBasePb.VoidProto deleteCursor(LocalRpcService.Status status, DatastorePb.Cursor request) {
        Profile profile = this.profiles.get(request.getApp());
        profile.removeQuery(request.getCursor());
        return new ApiBasePb.VoidProto();
    }

    @LatencyPercentiles(latency50th=1)
    public DatastorePb.Transaction beginTransaction(LocalRpcService.Status status, DatastorePb.BeginTransactionRequest req) {
        Profile profile = this.getOrCreateProfile(req.getApp());
        DatastorePb.Transaction txn = new DatastorePb.Transaction().setApp(req.getApp()).setHandle((long)this.transactionHandleProvider.getAndIncrement());
        profile.addTxn(txn.getHandle(), new LiveTxn(this.clock));
        return txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=20, dynamicAdjuster=WriteLatencyAdjuster.class)
    public DatastorePb.CommitResponse commit(LocalRpcService.Status status, final DatastorePb.Transaction req) {
        final Profile profile = this.profiles.get(req.getApp());
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                LiveTxn liveTxn = profile.removeTxn(req.getHandle());
                if (liveTxn.isDirty()) {
                    try {
                        LocalDatastoreService.this.globalLock.readLock().lock();
                        LocalDatastoreService.this.commitImpl(liveTxn, profile);
                    }
                    finally {
                        LocalDatastoreService.this.globalLock.readLock().unlock();
                    }
                }
                for (TaskQueuePb.TaskQueueAddRequest action : liveTxn.getActions()) {
                    try {
                        ApiProxy.makeSyncCall((String)"taskqueue", (String)"Add", (byte[])action.toByteArray());
                    }
                    catch (ApiProxy.ApplicationException e) {
                        logger.log(Level.WARNING, "Transactional task: " + action + " has been dropped.", e);
                    }
                }
            }
        };
        Profile profile2 = profile;
        synchronized (profile2) {
            runnable.run();
        }
        return new DatastorePb.CommitResponse();
    }

    private void commitImpl(LiveTxn liveTxn, final Profile profile) {
        Profile.EntityGroup eg = liveTxn.getEntityGroup();
        liveTxn.checkEntityGroupVersion();
        eg.incrementVersion();
        final Collection<OnestoreEntity.EntityProto> writtenEntities = liveTxn.getWrittenEntities();
        final Collection<OnestoreEntity.Reference> deletedKeys = liveTxn.getDeletedKeys();
        LocalDatastoreJob job = new LocalDatastoreJob(this.highRepJobPolicy, eg.pathAsKey()){

            void applyInternal() {
                String kind;
                OnestoreEntity.Path.Element lastPath;
                LocalFullTextIndex fullTextIndex = profile.getFullTextIndex();
                for (OnestoreEntity.EntityProto entity : writtenEntities) {
                    lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(entity.getKey().getPath().elements());
                    kind = lastPath.getType();
                    Extent extent = LocalDatastoreService.this.getOrCreateExtent(profile, kind);
                    extent.getEntities().put(entity.getKey(), entity);
                    if (fullTextIndex == null) continue;
                    fullTextIndex.write(entity);
                }
                for (OnestoreEntity.Reference key : deletedKeys) {
                    lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements());
                    kind = lastPath.getType();
                    Map<String, Extent> extents = profile.getExtents();
                    Extent extent = extents.get(kind);
                    if (extent != null) {
                        extent.getEntities().remove(key);
                    }
                    if (fullTextIndex == null) continue;
                    fullTextIndex.delete(key);
                }
                LocalDatastoreService.this.dirty = true;
            }
        };
        eg.apply(job);
        logger.fine("committed: " + writtenEntities.size() + " puts, " + deletedKeys.size() + " deletes");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=1)
    public ApiBasePb.VoidProto rollback(LocalRpcService.Status status, DatastorePb.Transaction req) {
        final Profile profile = this.profiles.get(req.getApp());
        final long handle = req.getHandle();
        Runnable runnable = new Runnable(){

            public void run() {
                profile.removeTxn(handle);
            }
        };
        Profile profile2 = profile;
        synchronized (profile2) {
            runnable.run();
        }
        return new ApiBasePb.VoidProto();
    }

    public ApiBasePb.Integer64Proto createIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto updateIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public DatastorePb.CompositeIndices getIndices(LocalRpcService.Status status, ApiBasePb.StringProto req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public ApiBasePb.VoidProto deleteIndex(LocalRpcService.Status status, OnestoreEntity.CompositeIndex req) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LatencyPercentiles(latency50th=1)
    public DatastorePb.AllocateIdsResponse allocateIds(LocalRpcService.Status status, DatastorePb.AllocateIdsRequest req) {
        try {
            this.globalLock.readLock().lock();
            DatastorePb.AllocateIdsResponse allocateIdsResponse = this.allocateIdsImpl(req);
            return allocateIdsResponse;
        }
        finally {
            this.globalLock.readLock().unlock();
        }
    }

    private DatastorePb.AllocateIdsResponse allocateIdsImpl(DatastorePb.AllocateIdsRequest req) {
        if (req.hasSize()) {
            if (req.getSize() > 1000000000L) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "cannot get more than 1000000000 keys in a single call");
            }
            long start = this.entityId.getAndAdd(req.getSize());
            return new DatastorePb.AllocateIdsResponse().setStart(start).setEnd(start + req.getSize() - 1L);
        }
        long current = this.entityId.get();
        while (current <= req.getMax() && !this.entityId.compareAndSet(current, req.getMax() + 1L)) {
            current = this.entityId.get();
        }
        return new DatastorePb.AllocateIdsResponse().setStart(current).setEnd(Math.max(req.getMax(), current - 1L));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Profile getOrCreateProfile(String app) {
        Map<String, Profile> map = this.profiles;
        synchronized (map) {
            Preconditions.checkArgument((app != null && app.length() > 0 ? 1 : 0) != 0, (Object)"appId not set");
            Profile profile = this.profiles.get(app);
            if (profile == null) {
                profile = new Profile();
                this.profiles.put(app, profile);
            }
            return profile;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Extent getOrCreateExtent(Profile profile, String kind) {
        Map<String, Extent> extents;
        Map<String, Extent> map = extents = profile.getExtents();
        synchronized (map) {
            Extent e = extents.get(kind);
            if (e == null) {
                e = new Extent();
                extents.put(kind, e);
            }
            return e;
        }
    }

    private void load() {
        if (this.noStorage) {
            return;
        }
        File backingStoreFile = new File(this.backingStore);
        String path = backingStoreFile.getAbsolutePath();
        if (!backingStoreFile.exists()) {
            logger.log(Level.INFO, "The backing store, " + path + ", does not exist. " + "It will be created.");
            return;
        }
        try {
            Map profilesOnDisk;
            long start = this.clock.getCurrentTime();
            ObjectInputStream objectIn = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.backingStore)));
            this.entityId.set(objectIn.readLong());
            this.profiles = profilesOnDisk = (Map)objectIn.readObject();
            objectIn.close();
            long end = this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to load datastore: " + (end - start) + " ms");
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Failed to find the backing store, " + path);
        }
        catch (IOException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.INFO, "Failed to load from the backing store, " + path, e);
        }
    }

    private static <T> T getLast(List<T> list) {
        return list.get(list.size() - 1);
    }

    static void pruneHasCreationTimeMap(long now, int maxLifetimeMs, Map<Long, ? extends HasCreationTime> hasCreationTimeMap) {
        long deadline = now - (long)maxLifetimeMs;
        Iterator<Map.Entry<Long, ? extends HasCreationTime>> queryIt = hasCreationTimeMap.entrySet().iterator();
        while (queryIt.hasNext()) {
            Map.Entry<Long, ? extends HasCreationTime> entry = queryIt.next();
            HasCreationTime query = entry.getValue();
            if (query.getCreationTime() >= deadline) continue;
            queryIt.remove();
        }
    }

    static Map<String, SpecialProperty> getSpecialPropertyMap() {
        return specialPropertyMap;
    }

    void removeStaleQueriesNow() {
        this.removeStaleQueriesTask.run();
    }

    void removeStaleTxnsNow() {
        this.removeStaleTransactionsTask.run();
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 30.0;
    }

    private class PersistDatastore
    implements Runnable {
        private PersistDatastore() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                LocalDatastoreService.this.globalLock.writeLock().lock();
                this.privilegedPersist();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unable to save the datastore", e);
            }
            finally {
                LocalDatastoreService.this.globalLock.writeLock().unlock();
            }
        }

        private void privilegedPersist() throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                    @Override
                    public Object run() throws IOException {
                        PersistDatastore.this.persist();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException e) {
                Throwable t = e.getCause();
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new RuntimeException(t);
            }
        }

        private void persist() throws IOException {
            if (LocalDatastoreService.this.noStorage || !LocalDatastoreService.this.dirty) {
                return;
            }
            long start = LocalDatastoreService.this.clock.getCurrentTime();
            ObjectOutputStream objectOut = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(LocalDatastoreService.this.backingStore)));
            objectOut.writeLong(LocalDatastoreService.this.entityId.get());
            objectOut.writeObject(LocalDatastoreService.this.profiles);
            objectOut.close();
            LocalDatastoreService.this.dirty = false;
            long end = LocalDatastoreService.this.clock.getCurrentTime();
            logger.log(Level.INFO, "Time to persist datastore: " + (end - start) + " ms");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SpecialProperty {
        SCATTER(false, true){
            private static final int SMALL_LENGTH = 2;

            OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
                int hashCode = 0;
                for (OnestoreEntity.Path.Element elem : entity.getKey().getPath().elements()) {
                    if (elem.hasId()) {
                        hashCode = (int)((long)hashCode ^ elem.getId());
                        continue;
                    }
                    if (elem.hasName()) {
                        hashCode ^= elem.getName().hashCode();
                        continue;
                    }
                    throw new IllegalStateException("Couldn't find name or id for entity " + entity.getKey());
                }
                try {
                    byte[] digest = MessageDigest.getInstance("MD5").digest(("" + hashCode).getBytes());
                    byte[] miniDigest = new byte[2];
                    System.arraycopy(digest, 0, miniDigest, 0, 2);
                    if ((miniDigest[0] & 1) != 0) {
                        OnestoreEntity.PropertyValue value = new OnestoreEntity.PropertyValue();
                        value.setStringValueAsBytes(miniDigest);
                        return value;
                    }
                }
                catch (NoSuchAlgorithmException ex) {
                    Logger logger = Logger.getLogger(SpecialProperty.class.getName());
                    logger.log(Level.WARNING, "Your JDK doesn't have an MD5 implementation, which is required for scatter  property support.");
                }
                return null;
            }
        };

        private final String name = "__" + this.name().toLowerCase() + "__";
        private final boolean isVisible;
        private final boolean isStored;

        private SpecialProperty(boolean isVisible, boolean isStored) {
            this.isVisible = isVisible;
            this.isStored = isStored;
        }

        public final String getName() {
            return this.name;
        }

        public final boolean isVisible() {
            return this.isVisible;
        }

        final boolean isStored() {
            return this.isStored;
        }

        OnestoreEntity.PropertyValue getValue(OnestoreEntity.EntityProto entity) {
            throw new UnsupportedOperationException();
        }

        OnestoreEntity.Property getProperty(OnestoreEntity.PropertyValue value) {
            OnestoreEntity.Property processedProp = new OnestoreEntity.Property();
            processedProp.setName(this.getName());
            processedProp.setValue(value);
            processedProp.setMultiple(false);
            return processedProp;
        }
    }

    private class RemoveStaleTransactions
    implements Runnable {
        private RemoveStaleTransactions() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (Profile profile : LocalDatastoreService.this.profiles.values()) {
                Map map = profile.getTxns();
                synchronized (map) {
                    LocalDatastoreService.pruneHasCreationTimeMap(LocalDatastoreService.this.clock.getCurrentTime(), LocalDatastoreService.this.maxTransactionLifetimeMs, profile.getTxns());
                }
            }
        }
    }

    private class RemoveStaleQueries
    implements Runnable {
        private RemoveStaleQueries() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            for (Profile profile : LocalDatastoreService.this.profiles.values()) {
                Map map = profile.getQueries();
                synchronized (map) {
                    LocalDatastoreService.pruneHasCreationTimeMap(LocalDatastoreService.this.clock.getCurrentTime(), LocalDatastoreService.this.maxQueryLifetimeMs, profile.getQueries());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveTxn
    extends HasCreationTime {
        private Profile.EntityGroup entityGroup;
        private Long entityGroupVersion;
        private final Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> written = new HashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();
        private final Set<OnestoreEntity.Reference> deleted = new HashSet<OnestoreEntity.Reference>();
        private final List<TaskQueuePb.TaskQueueAddRequest> actions = new ArrayList<TaskQueuePb.TaskQueueAddRequest>();

        public LiveTxn(Clock clock) {
            super(clock.getCurrentTime());
        }

        public synchronized void setEntityGroup(Profile.EntityGroup newEntityGroup) {
            if (newEntityGroup == null) {
                throw new NullPointerException("entityGroup cannot be null");
            }
            if (this.entityGroupVersion == null) {
                this.entityGroupVersion = newEntityGroup.getVersion();
                this.entityGroup = newEntityGroup;
            }
            if (!newEntityGroup.equals(this.entityGroup)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "can't operate on multiple entity groups in a single transaction. found both " + this.entityGroup + " and " + newEntityGroup);
            }
        }

        public synchronized Profile.EntityGroup getEntityGroup() {
            return this.entityGroup;
        }

        public synchronized void checkEntityGroupVersion() {
            if (!this.entityGroupVersion.equals(this.entityGroup.getVersion())) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.CONCURRENT_TRANSACTION.getValue(), LocalDatastoreService.CONTENTION_MESSAGE);
            }
        }

        public synchronized Long getEntityGroupVersion() {
            return this.entityGroupVersion;
        }

        public synchronized void addWrittenEntity(OnestoreEntity.EntityProto entity) {
            OnestoreEntity.Reference key = entity.getKey();
            this.written.put(key, entity);
            this.deleted.remove(key);
        }

        public synchronized void addDeletedEntity(OnestoreEntity.Reference key) {
            this.deleted.add(key);
            this.written.remove(key);
        }

        public synchronized void addActions(Collection<TaskQueuePb.TaskQueueAddRequest> newActions) {
            if ((long)(this.actions.size() + newActions.size()) > 5L) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "Too many messages, maximum allowed: 5");
            }
            this.actions.addAll(newActions);
        }

        public synchronized Collection<OnestoreEntity.EntityProto> getWrittenEntities() {
            return new ArrayList<OnestoreEntity.EntityProto>(this.written.values());
        }

        public synchronized Collection<OnestoreEntity.Reference> getDeletedKeys() {
            return new ArrayList<OnestoreEntity.Reference>(this.deleted);
        }

        public synchronized Collection<TaskQueuePb.TaskQueueAddRequest> getActions() {
            return new ArrayList<TaskQueuePb.TaskQueueAddRequest>(this.actions);
        }

        public synchronized boolean isDirty() {
            return this.written.size() + this.deleted.size() > 0;
        }

        public synchronized void close() {
            if (this.entityGroup != null) {
                this.entityGroup.removeTransaction(this);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LiveQuery
    extends HasCreationTime {
        private final Set<String> orderProperties;
        private final DatastorePb.Query query;
        private List<OnestoreEntity.EntityProto> entities;
        private OnestoreEntity.EntityProto lastResult = null;

        public LiveQuery(List<OnestoreEntity.EntityProto> entities, DatastorePb.Query query, EntityProtoComparators.EntityProtoComparator entityComparator, Clock clock) {
            super(clock.getCurrentTime());
            if (entities == null) {
                throw new NullPointerException("entities cannot be null");
            }
            this.query = query;
            this.entities = entities;
            this.orderProperties = new HashSet<String>();
            for (DatastorePb.Query.Order order : entityComparator.getAdjustedOrders()) {
                this.orderProperties.add(order.getProperty());
            }
            this.applyCursors(entityComparator);
            this.applyLimit();
            entities = Lists.newArrayList(entities);
        }

        private void applyCursors(EntityProtoComparators.EntityProtoComparator entityComparator) {
            DecompiledCursor startCursor = new DecompiledCursor(this.query.getCompiledCursor());
            this.lastResult = startCursor.getCursorEntity();
            int endCursorPos = new DecompiledCursor(this.query.getEndCompiledCursor()).getPosition(entityComparator, this.entities.size());
            int startCursorPos = Math.min(endCursorPos, startCursor.getPosition(entityComparator, 0));
            this.entities = this.entities.subList(startCursorPos, endCursorPos);
        }

        private void applyLimit() {
            if (this.query.hasLimit()) {
                int toIndex = this.query.getLimit() + this.query.getOffset();
                if (toIndex < 0 || toIndex > this.entities.size()) {
                    toIndex = this.entities.size();
                }
                this.entities = this.entities.subList(0, toIndex);
            }
        }

        public List<OnestoreEntity.EntityProto> entitiesRemaining() {
            return this.entities;
        }

        public int offsetResults(int offset) {
            int real_offset = Math.min(Math.min(offset, this.entities.size()), 1000);
            if (real_offset > 0) {
                this.lastResult = this.entities.get(real_offset - 1);
                this.entities = this.entities.subList(real_offset, this.entities.size());
            }
            return real_offset;
        }

        public List<OnestoreEntity.EntityProto> nextResults(int end) {
            ArrayList<OnestoreEntity.EntityProto> result;
            List<OnestoreEntity.EntityProto> subList = this.entities.subList(0, Math.min(end, this.entities.size()));
            if (subList.size() > 0) {
                this.lastResult = subList.get(subList.size() - 1);
            }
            if (this.query.isKeysOnly()) {
                result = new ArrayList();
                for (OnestoreEntity.EntityProto entity : subList) {
                    result.add(((OnestoreEntity.EntityProto)entity.clone()).clearOwner().clearProperty().clearRawProperty());
                }
            } else {
                result = new ArrayList<OnestoreEntity.EntityProto>(subList);
            }
            subList.clear();
            return result;
        }

        public void restrictRange(int fromIndex, int toIndex) {
            toIndex = Math.max(fromIndex, toIndex);
            if (fromIndex > 0) {
                this.lastResult = this.entities.get(fromIndex - 1);
            }
            if (fromIndex != 0 || toIndex != this.entities.size()) {
                this.entities = new ArrayList<OnestoreEntity.EntityProto>(this.entities.subList(fromIndex, toIndex));
            }
        }

        public boolean isKeysOnly() {
            return this.query.isKeysOnly();
        }

        public OnestoreEntity.EntityProto decompilePosition(DatastorePb.CompiledCursor.Position position) {
            OnestoreEntity.EntityProto result = new OnestoreEntity.EntityProto();
            result.mergeFrom(position.getStartKeyAsBytes());
            DatastorePb.Query relevantInfo = new DatastorePb.Query();
            relevantInfo.mergeFrom(result.getKey().getPath().getElement(0).getTypeAsBytes());
            if (!this.validateQuery(relevantInfo)) {
                throw new ApiProxy.ApplicationException(DatastorePb.Error.ErrorCode.BAD_REQUEST.getValue(), "Cursor does not match query.");
            }
            result.getKey().getPath().removeElement(0);
            return result;
        }

        private DatastorePb.Query getValidationInfo() {
            DatastorePb.Query relevantInfo = new DatastorePb.Query();
            for (DatastorePb.Query.Filter filter : this.query.filters()) {
                relevantInfo.addFilter(filter);
            }
            for (DatastorePb.Query.Order order : this.query.orders()) {
                relevantInfo.addOrder(order);
            }
            if (this.query.hasAncestor()) {
                relevantInfo.setAncestor(this.query.getAncestor());
            }
            if (this.query.hasKind()) {
                relevantInfo.setKind(this.query.getKind());
            }
            if (this.query.hasSearchQuery()) {
                relevantInfo.setSearchQuery(this.query.getSearchQuery());
            }
            return relevantInfo;
        }

        private boolean validateQuery(DatastorePb.Query relevantInfo) {
            if (!((Object)relevantInfo.filters()).equals(this.query.filters())) {
                return false;
            }
            if (!((Object)relevantInfo.orders()).equals(this.query.orders())) {
                return false;
            }
            if (relevantInfo.hasAncestor() ? !this.query.hasAncestor() || !relevantInfo.getAncestor().equals(this.query.getAncestor()) : this.query.hasAncestor()) {
                return false;
            }
            if (relevantInfo.hasKind() ? !this.query.hasKind() || !relevantInfo.getKind().equals(this.query.getKind()) : this.query.hasKind()) {
                return false;
            }
            return !(relevantInfo.hasSearchQuery() ? !this.query.hasSearchQuery() || !relevantInfo.getSearchQuery().equals(this.query.getSearchQuery()) : this.query.hasSearchQuery());
        }

        public DatastorePb.CompiledCursor.Position compilePosition() {
            DatastorePb.CompiledCursor.Position position = new DatastorePb.CompiledCursor.Position();
            if (this.lastResult != null) {
                OnestoreEntity.EntityProto savedEntity = new OnestoreEntity.EntityProto();
                savedEntity.setKey((OnestoreEntity.Reference)this.lastResult.getKey().clone());
                savedEntity.getKey().getPath().insertElement(0, new OnestoreEntity.Path.Element().setTypeAsBytes(this.getValidationInfo().toByteArray()));
                for (OnestoreEntity.Property prop : this.lastResult.propertys()) {
                    if (!this.orderProperties.contains(prop.getName())) continue;
                    savedEntity.addProperty((OnestoreEntity.Property)prop.clone());
                }
                position.setStartKeyAsBytes(savedEntity.toByteArray());
                position.setStartInclusive(false);
            }
            return position;
        }

        public DatastorePb.CompiledQuery compileQuery() {
            DatastorePb.CompiledQuery result = new DatastorePb.CompiledQuery();
            DatastorePb.CompiledQuery.PrimaryScan scan = result.getMutablePrimaryScan();
            scan.setIndexNameAsBytes(this.query.toByteArray());
            return result;
        }

        class DecompiledCursor {
            final OnestoreEntity.EntityProto cursorEntity;
            final boolean inclusive;

            public DecompiledCursor(DatastorePb.CompiledCursor compiledCursor) {
                if (compiledCursor == null || compiledCursor.positionSize() == 0) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    return;
                }
                DatastorePb.CompiledCursor.Position position = compiledCursor.getPosition(0);
                if (!position.hasStartKey()) {
                    this.cursorEntity = null;
                    this.inclusive = false;
                    return;
                }
                this.cursorEntity = LiveQuery.this.decompilePosition(position);
                this.inclusive = position.isStartInclusive();
            }

            public int getPosition(EntityProtoComparators.EntityProtoComparator entityComparator, int defaultValue) {
                if (this.cursorEntity == null) {
                    return defaultValue;
                }
                int loc = Collections.binarySearch(LiveQuery.this.entities, this.cursorEntity, entityComparator);
                if (loc < 0) {
                    return -(loc + 1);
                }
                return this.inclusive ? loc : loc + 1;
            }

            public OnestoreEntity.EntityProto getCursorEntity() {
                return this.cursorEntity;
            }
        }
    }

    static class HasCreationTime {
        private final long creationTime;

        HasCreationTime(long creationTime) {
            this.creationTime = creationTime;
        }

        long getCreationTime() {
            return this.creationTime;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Extent
    implements Serializable {
        private Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = new LinkedHashMap<OnestoreEntity.Reference, OnestoreEntity.EntityProto>();

        Extent() {
        }

        public Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> getEntities() {
            return this.entities;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Profile
    implements Serializable {
        private final Map<String, Extent> extents = Collections.synchronizedMap(new HashMap());
        private transient Map<OnestoreEntity.Path, EntityGroup> groups;
        private transient Set<OnestoreEntity.Path> groupsWithUnappliedJobs;
        private transient Map<Long, LiveQuery> queries;
        private transient Map<Long, LiveTxn> txns;
        private final LocalFullTextIndex fullTextIndex = this.createFullTextIndex();

        public synchronized List<OnestoreEntity.EntityProto> getAllEntities() {
            ArrayList<OnestoreEntity.EntityProto> entities = new ArrayList<OnestoreEntity.EntityProto>();
            for (Extent extent : this.extents.values()) {
                entities.addAll(extent.getEntities().values());
            }
            return entities;
        }

        private LocalFullTextIndex createFullTextIndex() {
            Class<LocalFullTextIndex> indexClass = this.getFullTextIndexClass();
            if (indexClass == null) {
                return null;
            }
            try {
                return indexClass.newInstance();
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }

        private Class<LocalFullTextIndex> getFullTextIndexClass() {
            try {
                return Class.forName("com.google.appengine.api.datastore.dev.LuceneFullTextIndex");
            }
            catch (ClassNotFoundException e) {
                return null;
            }
            catch (NoClassDefFoundError e) {
                return null;
            }
        }

        public Map<String, Extent> getExtents() {
            return this.extents;
        }

        public synchronized EntityGroup getGroup(OnestoreEntity.Path path) {
            Map<OnestoreEntity.Path, EntityGroup> map = this.getGroups();
            EntityGroup group = map.get(path);
            if (group == null) {
                group = new EntityGroup(path);
                map.put(path, group);
            }
            return group;
        }

        private synchronized void groom() {
            for (OnestoreEntity.Path path : new HashSet<OnestoreEntity.Path>(this.getGroupsWithUnappliedJobs())) {
                EntityGroup eg = this.getGroup(path);
                eg.maybeRollForwardUnappliedJobs();
            }
        }

        public synchronized LiveQuery getQuery(long cursor) {
            return (LiveQuery)LocalDatastoreService.safeGetFromExpiringMap(this.getQueries(), cursor, LocalDatastoreService.QUERY_NOT_FOUND);
        }

        public synchronized void addQuery(long cursor, LiveQuery query) {
            this.getQueries().put(cursor, query);
        }

        private synchronized LiveQuery removeQuery(long cursor) {
            LiveQuery query = this.getQuery(cursor);
            this.queries.remove(cursor);
            return query;
        }

        private synchronized Map<Long, LiveQuery> getQueries() {
            if (this.queries == null) {
                this.queries = new HashMap<Long, LiveQuery>();
            }
            return this.queries;
        }

        public synchronized LiveTxn getTxn(long handle) {
            return (LiveTxn)LocalDatastoreService.safeGetFromExpiringMap(this.getTxns(), handle, LocalDatastoreService.TRANSACTION_NOT_FOUND);
        }

        public LocalFullTextIndex getFullTextIndex() {
            return this.fullTextIndex;
        }

        public synchronized void addTxn(long handle, LiveTxn txn) {
            this.getTxns().put(handle, txn);
        }

        private synchronized LiveTxn removeTxn(long handle) {
            LiveTxn txn = this.getTxn(handle);
            txn.close();
            this.txns.remove(handle);
            return txn;
        }

        private synchronized Map<Long, LiveTxn> getTxns() {
            if (this.txns == null) {
                this.txns = new HashMap<Long, LiveTxn>();
            }
            return this.txns;
        }

        private synchronized Map<OnestoreEntity.Path, EntityGroup> getGroups() {
            if (this.groups == null) {
                this.groups = new LinkedHashMap<OnestoreEntity.Path, EntityGroup>();
            }
            return this.groups;
        }

        private synchronized Set<OnestoreEntity.Path> getGroupsWithUnappliedJobs() {
            if (this.groupsWithUnappliedJobs == null) {
                this.groupsWithUnappliedJobs = new LinkedHashSet<OnestoreEntity.Path>();
            }
            return this.groupsWithUnappliedJobs;
        }

        private class EntityGroup {
            private final OnestoreEntity.Path path;
            private final AtomicLong version = new AtomicLong();
            private final WeakHashMap<LiveTxn, Profile> snapshots = new WeakHashMap();
            private final LinkedList<LocalDatastoreJob> unappliedJobs = new LinkedList();

            private EntityGroup(OnestoreEntity.Path path) {
                this.path = path;
            }

            public long getVersion() {
                return this.version.get();
            }

            public void incrementVersion() {
                long oldVersion = this.version.getAndIncrement();
                Profile snapshot = null;
                for (LiveTxn txn : this.snapshots.keySet()) {
                    if (txn.getEntityGroupVersion() != oldVersion) continue;
                    if (snapshot == null) {
                        snapshot = this.takeSnapshot();
                    }
                    this.snapshots.put(txn, snapshot);
                }
            }

            public OnestoreEntity.EntityProto get(LiveTxn liveTxn, OnestoreEntity.Reference key, boolean eventualConsistency) {
                OnestoreEntity.Path.Element lastPath;
                Profile profile;
                Map<String, Extent> extents;
                Extent extent;
                if (!eventualConsistency) {
                    this.rollForwardUnappliedJobs();
                }
                if ((extent = (extents = (profile = this.getSnapshot(liveTxn)).getExtents()).get((lastPath = (OnestoreEntity.Path.Element)LocalDatastoreService.getLast(key.getPath().elements())).getType())) != null) {
                    Map<OnestoreEntity.Reference, OnestoreEntity.EntityProto> entities = extent.getEntities();
                    return entities.get(key);
                }
                return null;
            }

            public void addTransaction(LiveTxn txn) {
                txn.setEntityGroup(this);
                if (!this.snapshots.containsKey(txn)) {
                    this.snapshots.put(txn, null);
                }
            }

            public void removeTransaction(LiveTxn txn) {
                this.snapshots.remove(txn);
            }

            private Profile getSnapshot(LiveTxn txn) {
                if (txn == null) {
                    return Profile.this;
                }
                Profile snapshot = this.snapshots.get(txn);
                if (snapshot == null) {
                    return Profile.this;
                }
                return snapshot;
            }

            private Profile takeSnapshot() {
                try {
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    ObjectOutputStream oos = new ObjectOutputStream(bos);
                    oos.writeObject(Profile.this);
                    oos.close();
                    ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
                    ObjectInputStream ois = new ObjectInputStream(bis);
                    return (Profile)ois.readObject();
                }
                catch (IOException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
                catch (ClassNotFoundException ex) {
                    throw new RuntimeException("Unable to take transaction snapshot.", ex);
                }
            }

            public String toString() {
                return this.path.toString();
            }

            public void apply(LocalDatastoreJob job) {
                this.unappliedJobs.addLast(job);
                Profile.this.getGroupsWithUnappliedJobs().add(this.path);
                this.maybeRollForwardUnappliedJobs();
            }

            public void rollForwardUnappliedJobs() {
                if (!this.unappliedJobs.isEmpty()) {
                    for (LocalDatastoreJob applyJob : this.unappliedJobs) {
                        applyJob.apply();
                    }
                    this.unappliedJobs.clear();
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                    logger.fine("Rolled forward unapplied jobs for " + this.path);
                }
            }

            public void maybeRollForwardUnappliedJobs() {
                int jobsAtStart = this.unappliedJobs.size();
                logger.fine(String.format("Maybe rolling forward %d unapplied jobs for %s.", jobsAtStart, this.path));
                int applied = 0;
                Iterator iter = this.unappliedJobs.iterator();
                while (iter.hasNext() && ((LocalDatastoreJob)iter.next()).tryApplyJob()) {
                    iter.remove();
                    ++applied;
                }
                if (this.unappliedJobs.isEmpty()) {
                    Profile.this.getGroupsWithUnappliedJobs().remove(this.path);
                }
                logger.fine(String.format("Rolled forward %d of %d jobs for %s", applied, jobsAtStart, this.path));
            }

            public Key pathAsKey() {
                OnestoreEntity.Reference entityGroupRef = new OnestoreEntity.Reference();
                entityGroupRef.setPath(this.path);
                return LocalCompositeIndexManager.KeyTranslator.createFromPb((OnestoreEntity.Reference)entityGroupRef);
            }
        }
    }
}

