/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.BlobstoreFile;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.api.files.dev.Session;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.apphosting.api.ApiProxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FileMetadata {
    protected FileServicePb.FileContentType.ContentType contentType;
    protected boolean finalized = false;
    private Session lockOwner;
    private Map<String, OpenState> sessionToStateMap = new ConcurrentHashMap<String, OpenState>(10);

    public FileMetadata(FileServicePb.FileContentType.ContentType contentType) {
        this.contentType = contentType;
    }

    public void setFinalized() {
        this.finalized = true;
    }

    public boolean isFinalized() {
        return this.finalized;
    }

    public FileServicePb.FileContentType.ContentType getContentType() {
        return this.contentType;
    }

    public void lock(Session session) {
        this.lockOwner = session;
    }

    public LockState getLockState(Session session) {
        if (null == this.lockOwner) {
            return LockState.UNLOCKED;
        }
        if (this.lockOwner == session) {
            return LockState.LOCKED_IN_CURRENT_SESSION;
        }
        return LockState.LOCKED_IN_OTHER_SESSION;
    }

    public void setState(OpenState state, Session session) {
        if (OpenState.CLOSED == state) {
            this.sessionToStateMap.remove(session.getID());
            if (session == this.lockOwner) {
                this.lockOwner = null;
            }
        } else {
            this.sessionToStateMap.put(session.getID(), state);
        }
    }

    public OpenState getOpenState(Session session) {
        OpenState state = this.sessionToStateMap.get(session.getID());
        if (null == state) {
            state = OpenState.CLOSED;
        }
        return state;
    }

    public boolean isOpenInDifferentSession(Session session) {
        int size = this.sessionToStateMap.size();
        if (size > 1) {
            return true;
        }
        if (0 == size) {
            return false;
        }
        return null == this.sessionToStateMap.get(session.getID());
    }

    public abstract ByteString read(FileServicePb.ReadRequest var1);

    public abstract void append(FileServicePb.AppendRequest var1);

    public static boolean isSpecialReadOnlyName(ParsedFileName parsedName) {
        String fileSystem = parsedName.getFileSystem();
        if (BlobstoreFile.FILE_SYSTEM.equals(fileSystem)) {
            return BlobstoreFile.isSpecialReadOnlyName(parsedName);
        }
        throw new ApiProxy.ApplicationException(5);
    }

    public static FileMetadata newInstance(LocalFileService localFileService, ParsedFileName parsedName, FileServicePb.OpenRequest.OpenMode openMode, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) {
        String fileSystem = parsedName.getFileSystem();
        if (BlobstoreFile.FILE_SYSTEM.equals(fileSystem)) {
            return BlobstoreFile.newInstance(localFileService, parsedName, openMode, contentType, parameters);
        }
        throw new ApiProxy.ApplicationException(5);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LockState {
        LOCKED_IN_CURRENT_SESSION,
        LOCKED_IN_OTHER_SESSION,
        UNLOCKED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OpenState {
        OPENED_FOR_READ,
        OPENED_FOR_APPEND,
        CLOSED;

    }
}

