/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.conversion.dev;

import com.google.appengine.api.conversion.ConversionServicePb;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LatencyPercentiles;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.appengine.tools.development.ServiceProvider;
import com.google.apphosting.api.ApiProxy;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

@ServiceProvider(value=LocalRpcService.class)
public final class LocalConversionService
extends AbstractLocalRpcService {
    private static final String STATIC_FILES_DIR = "static/";
    public static final ImmutableMap<String, String> CONVERTED_FILES_STUB = new ImmutableMap.Builder().put((Object)"application/pdf", (Object)"test.pdf").put((Object)"image/png", (Object)"test.png").put((Object)"text/html", (Object)"test.html").put((Object)"text/plain", (Object)"test.txt").build();
    private static final ImmutableSet<String> IMAGE_OCR_OUTPUT_TYPES = new ImmutableSet.Builder().add((Object)"application/pdf").add((Object)"text/html").add((Object)"text/plain").build();
    private static final ImmutableSet<String> PDF_OUTPUT_TYPES = new ImmutableSet.Builder().add((Object)"image/png").add((Object)"text/html").add((Object)"text/plain").build();
    private static final ImmutableSet<String> HTML_OUTPUT_TYPES = new ImmutableSet.Builder().add((Object)"application/pdf").add((Object)"image/png").add((Object)"text/plain").build();
    private static final ImmutableSet<String> TXT_OUTPUT_TYPES = new ImmutableSet.Builder().add((Object)"application/pdf").add((Object)"image/png").add((Object)"text/html").build();
    private static final ImmutableMap<String, ImmutableSet<String>> SUPPORTED_PATHS = new ImmutableMap.Builder().put((Object)"application/pdf", PDF_OUTPUT_TYPES).put((Object)"image/bmp", IMAGE_OCR_OUTPUT_TYPES).put((Object)"image/gif", IMAGE_OCR_OUTPUT_TYPES).put((Object)"image/jpeg", IMAGE_OCR_OUTPUT_TYPES).put((Object)"image/png", IMAGE_OCR_OUTPUT_TYPES).put((Object)"text/html", HTML_OUTPUT_TYPES).put((Object)"text/plain", TXT_OUTPUT_TYPES).build();
    public static final String PACKAGE = "conversion";

    public String getPackage() {
        return PACKAGE;
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
    }

    public void start() {
    }

    public void stop() {
    }

    private static void validateConversionRequest(ConversionServicePb.ConversionRequest request) {
        if (!request.isInitialized()) {
            throw new ApiProxy.ApplicationException(7, "The conversion request is not initialized correctly");
        }
        if (request.getConversionCount() == 0) {
            throw new ApiProxy.ApplicationException(7, "At least one conversion is required in the request");
        }
        if (request.getConversionCount() > 10) {
            throw new ApiProxy.ApplicationException(6, String.format("At most %d conversions are allowed in one request.", 10));
        }
        for (ConversionServicePb.ConversionInput conversion : request.getConversionList()) {
            String outputMimeType;
            if (conversion.toByteArray().length > 0x200000) {
                throw new ApiProxy.ApplicationException(5, String.format("Each conversion should not be over %d bytes.", 0x200000));
            }
            if (conversion.getInput().getAssetCount() == 0) {
                throw new ApiProxy.ApplicationException(7, "At least one asset is required in input document");
            }
            for (int i = 0; i < conversion.getInput().getAssetCount(); ++i) {
                ConversionServicePb.AssetInfo asset = conversion.getInput().getAsset(i);
                if (!asset.hasData()) {
                    throw new ApiProxy.ApplicationException(7, "Asset data field must be set in input document");
                }
                if (!asset.hasMimeType()) {
                    throw new ApiProxy.ApplicationException(7, "Asset mime type field must be set in input document");
                }
                if (i <= 0 || asset.hasName()) continue;
                throw new ApiProxy.ApplicationException(7, "Additional assets must be set with name");
            }
            String inputMimeType = conversion.getInput().getAsset(0).getMimeType();
            if (LocalConversionService.isSupported(inputMimeType, outputMimeType = conversion.getOutputMimeType())) continue;
            throw new ApiProxy.ApplicationException(4, String.format("Conversion from %s to %s is not supported", inputMimeType, outputMimeType));
        }
    }

    private static boolean isSupported(String inputMimeType, String outputMimeType) {
        return SUPPORTED_PATHS.containsKey((Object)inputMimeType) && ((ImmutableSet)SUPPORTED_PATHS.get((Object)inputMimeType)).contains((Object)outputMimeType);
    }

    public static byte[] readStubFile(String outputMimeType) throws ApiProxy.ApplicationException, IOException {
        InputStream inputFile = LocalConversionService.class.getResourceAsStream(STATIC_FILES_DIR + (String)CONVERTED_FILES_STUB.get((Object)outputMimeType));
        if (inputFile == null) {
            throw new ApiProxy.ApplicationException(ConversionServicePb.ConversionServiceError.ErrorCode.INTERNAL_ERROR.getNumber(), "Failed to find the stub file static/" + File.separator + (String)CONVERTED_FILES_STUB.get((Object)outputMimeType));
        }
        BufferedInputStream bfInputFile = new BufferedInputStream(inputFile);
        try {
            byte[] outputData = new byte[bfInputFile.available()];
            bfInputFile.read(outputData);
            byte[] byArray = outputData;
            return byArray;
        }
        catch (IOException ex) {
            throw new ApiProxy.ApplicationException(ConversionServicePb.ConversionServiceError.ErrorCode.INTERNAL_ERROR.getNumber(), "Failed to read from stub file static/" + File.separator + (String)CONVERTED_FILES_STUB.get((Object)outputMimeType));
        }
        finally {
            bfInputFile.close();
        }
    }

    @LatencyPercentiles(latency50th=5000)
    public ConversionServicePb.ConversionResponse convert(LocalRpcService.Status status, ConversionServicePb.ConversionRequest request) throws IOException {
        LocalConversionService.validateConversionRequest(request);
        ConversionServicePb.ConversionResponse.Builder response = ConversionServicePb.ConversionResponse.newBuilder();
        for (ConversionServicePb.ConversionInput conversion : request.getConversionList()) {
            String outputMimeType = conversion.getOutputMimeType();
            ConversionServicePb.DocumentInfo.Builder docBuilder = ConversionServicePb.DocumentInfo.newBuilder();
            for (int i = 0; i < conversion.getInput().getAssetCount(); ++i) {
                docBuilder.addAsset(ConversionServicePb.AssetInfo.newBuilder().setMimeType(outputMimeType).setData(ByteString.copyFrom((byte[])LocalConversionService.readStubFile(outputMimeType))).setName((String)CONVERTED_FILES_STUB.get((Object)outputMimeType)).build());
            }
            response.addResult(ConversionServicePb.ConversionOutput.newBuilder().setErrorCode(ConversionServicePb.ConversionServiceError.ErrorCode.OK).setOutput(docBuilder.build()).build());
        }
        return response.build();
    }
}

