/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.rdbms.dev;

import com.google.appengine.api.rdbms.dev.LocalRdbms;
import com.google.appengine.api.rdbms.dev.LocalRdbmsProperties;
import com.google.appengine.api.rdbms.dev.LocalRdbmsService;
import com.google.appengine.api.rdbms.dev.Util;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.tools.development.AbstractLocalRpcService;
import com.google.appengine.tools.development.LocalRpcService;
import com.google.appengine.tools.development.LocalServiceContext;
import com.google.cloud.sql.jdbc.internal.ConnectionProperty;
import com.google.cloud.sql.jdbc.internal.SqlClientFactory;
import com.google.cloud.sql.jdbc.internal.SqlRpc;
import com.google.cloud.sql.jdbc.internal.SqlRpcOptions;
import com.google.cloud.sql.jdbc.internal.SqlState;
import com.google.cloud.sql.jdbc.internal.Url;
import com.google.protos.cloud.sql.Client;
import com.google.protos.cloud.sql.CloseConnectionRequest;
import com.google.protos.cloud.sql.CloseConnectionResponse;
import com.google.protos.cloud.sql.ExecOpRequest;
import com.google.protos.cloud.sql.ExecOpResponse;
import com.google.protos.cloud.sql.ExecRequest;
import com.google.protos.cloud.sql.ExecResponse;
import com.google.protos.cloud.sql.MetadataRequest;
import com.google.protos.cloud.sql.MetadataResponse;
import com.google.protos.cloud.sql.OpenConnectionRequest;
import com.google.protos.cloud.sql.OpenConnectionResponse;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

public class LocalRdbmsServiceRemoteDriver
extends AbstractLocalRpcService
implements LocalRdbms {
    private static final Logger logger = Logger.getLogger(LocalRdbmsServiceRemoteDriver.class.getCanonicalName());
    private static final String CLIENT_FACTORY_ERROR_MESSAGE = "Unable to create Client Factory.";
    private static final String OAUTH2_REFRESH_OR_ACCESS_TOKEN_NOT_FOUND = "An OAuth2 refresh or access token was not able to be loaded. Please connect with the Google Cloud SQL tool at least one time to enable access to your hosted instance.";
    private static final String PREFS_PACKAGE = "/com/google/cloud/sqlservice/oauth2";
    private static final Client.SqlException CONNECTION_NOT_FOUND_EXCEPTION = Client.SqlException.newBuilder().setCode(1007).setSqlState(SqlState.forError((int)1007)).setMessage("Invalid connection id.").build();
    private SqlClientFactory clientFactory;
    private final ConcurrentMap<ByteString, UrlAndRpc> connections = new ConcurrentHashMap<ByteString, UrlAndRpc>();
    private LocalRdbmsProperties properties;

    public String getPackage() {
        throw new IllegalStateException("getPackage() not expected on this delegate");
    }

    public void init(LocalServiceContext context, Map<String, String> properties) {
        this.properties = new LocalRdbmsProperties(properties);
    }

    public void start() {
        try {
            this.clientFactory = Class.forName(this.properties.getHostedClientFactoryClass()).asSubclass(SqlClientFactory.class).newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(CLIENT_FACTORY_ERROR_MESSAGE, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Iterator iter = this.connections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            try {
                ByteString id = (ByteString)entry.getKey();
                Url url = ((UrlAndRpc)entry.getValue()).url();
                SqlRpc rpc = ((UrlAndRpc)entry.getValue()).rpc();
                try {
                    rpc.closeConnection(SqlRpcOptions.defaultOptions((Url)url), CloseConnectionRequest.newBuilder().setConnectionId(id).setInstance(url.getInstance()).build());
                }
                catch (SQLException ex) {
                    logger.log(Level.FINE, MessageFormat.format("Unable to close connection id %s to instance %s", id, url.getInstance()), ex);
                }
                finally {
                    iter.remove();
                }
            }
            catch (RuntimeException e) {
                logger.log(Level.WARNING, "Unexpected exception closing connections.", e);
            }
        }
    }

    private Map<String, String> getExtraProperties() {
        Map<String, String> map = this.properties.getExtraProperties();
        if (!map.containsKey(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key()) && !map.containsKey(ConnectionProperty.OAUTH2_ACCESS_TOKEN.key())) {
            String accessToken;
            Url defaultSpeckleUrl;
            Preferences prefs = Preferences.userRoot().node(PREFS_PACKAGE);
            String refreshToken = prefs.get((defaultSpeckleUrl = Url.create((String)"jdbc:google:rdbms://n:i", (Properties)new Properties())).getOAuth2RefreshTokenKey(), null);
            if (refreshToken != null) {
                map.put(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key(), refreshToken);
            }
            if ((accessToken = prefs.get(defaultSpeckleUrl.getOAuth2AccessTokenKey(), null)) != null) {
                map.put(ConnectionProperty.OAUTH2_ACCESS_TOKEN.key(), accessToken);
            }
        }
        return map;
    }

    public Double getDefaultDeadline(boolean isOfflineRequest) {
        return 120.0;
    }

    public Double getMaximumDeadline(boolean isOfflineRequest) {
        return 120.0;
    }

    public Integer getMaxApiRequestSize() {
        return LocalRdbmsService.MAX_API_REQUEST_SIZE;
    }

    @Override
    public OpenConnectionResponse openConnection(LocalRpcService.Status status, OpenConnectionRequest originalRequest) {
        try {
            Map<String, String> props = Util.overrideConnectionProperties(this.properties, this.getExtraProperties());
            if (!props.containsKey(ConnectionProperty.OAUTH2_REFRESH_TOKEN.key()) && !props.containsKey(ConnectionProperty.OAUTH2_ACCESS_TOKEN.key())) {
                logger.fine("extra properties = " + props);
                String params = props.get(ConnectionProperty.GOOGLEAPI_PARAMS.key());
                if (params == null || !params.contains("fakeUser=1")) {
                    throw new SQLException(OAUTH2_REFRESH_OR_ACCESS_TOKEN_NOT_FOUND, SqlState.forError((int)1007));
                }
            }
            String instanceName = this.properties.getHostedInstance(originalRequest.getInstance());
            Map<String, String> info = Util.concat(Util.toPropertyMap(originalRequest.getPropertyList()), props);
            info.put(ConnectionProperty.INSTANCE.key(), instanceName);
            Url url = Url.createFromMap((String)String.format("%s//%s", "jdbc:google:rdbms:", instanceName), info);
            SqlRpc rpc = this.clientFactory.create(url).getRpc();
            OpenConnectionRequest.Builder builder = originalRequest.toBuilder().setInstance(instanceName).clearProperty();
            for (Map.Entry e : url.getProperties().entrySet()) {
                builder.addProperty(Client.Property.newBuilder().setKey((String)e.getKey()).setValue((String)e.getValue()));
            }
            OpenConnectionResponse response = rpc.openConnection(SqlRpcOptions.defaultOptions((Url)url), builder.build());
            this.connections.put(response.getConnectionId(), new UrlAndRpc(url, rpc));
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "openConnection", e);
            return OpenConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public CloseConnectionResponse closeConnection(LocalRpcService.Status status, CloseConnectionRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.remove(request.getConnectionId());
            if (urlAndRpc == null) {
                return CloseConnectionResponse.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            CloseConnectionResponse response = rpc.closeConnection(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request.toBuilder().setInstance(this.properties.getHostedInstance(request.getInstance())).build());
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return CloseConnectionResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public ExecResponse exec(LocalRpcService.Status status, ExecRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return ExecResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION)).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            ExecResponse response = rpc.exec(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request.toBuilder().setInstance(this.properties.getHostedInstance(request.getInstance())).build());
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return ExecResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(Util.toClientSqlException(e))).build();
        }
    }

    @Override
    public ExecOpResponse execOp(LocalRpcService.Status status, ExecOpRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return ExecOpResponse.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            ExecOpResponse response = rpc.execOp(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request.toBuilder().setInstance(this.properties.getHostedInstance(request.getInstance())).build());
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return ExecOpResponse.newBuilder().setSqlException(Util.toClientSqlException(e)).build();
        }
    }

    @Override
    public MetadataResponse getMetadata(LocalRpcService.Status status, MetadataRequest request) {
        try {
            UrlAndRpc urlAndRpc = (UrlAndRpc)this.connections.get(request.getConnectionId());
            if (urlAndRpc == null) {
                return MetadataResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(CONNECTION_NOT_FOUND_EXCEPTION)).build();
            }
            SqlRpc rpc = urlAndRpc.rpc();
            MetadataResponse response = rpc.getMetadata(SqlRpcOptions.defaultOptions((Url)urlAndRpc.url()), request.toBuilder().setInstance(this.properties.getHostedInstance(request.getInstance())).build());
            return response;
        }
        catch (SQLException e) {
            logger.log(Level.WARNING, "closeConnection", e);
            return MetadataResponse.newBuilder().setResult(Client.ResultProto.newBuilder().setSqlException(Util.toClientSqlException(e))).build();
        }
    }

    private static class UrlAndRpc {
        private final Url url;
        private final SqlRpc rpc;

        UrlAndRpc(Url url, SqlRpc rpc) {
            this.url = url;
            this.rpc = rpc;
        }

        Url url() {
            return this.url;
        }

        SqlRpc rpc() {
            return this.rpc;
        }
    }
}

