/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.blobstore.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobInfoStorage;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class FileBlobStorage
implements BlobStorage {
    private final File rootDirectory;
    private final BlobInfoStorage blobInfoStorage;

    FileBlobStorage(File rootDirectory, BlobInfoStorage blobInfoStorage) {
        this.rootDirectory = rootDirectory;
        this.blobInfoStorage = blobInfoStorage;
    }

    @Override
    public boolean hasBlob(BlobKey blobKey) {
        return this.getFileForBlob(blobKey).exists();
    }

    @Override
    public OutputStream storeBlob(BlobKey blobKey) throws IOException {
        return new FileOutputStream(this.getFileForBlob(blobKey));
    }

    @Override
    public InputStream fetchBlob(BlobKey blobKey) throws IOException {
        return new FileInputStream(this.getFileForBlob(blobKey));
    }

    @Override
    public void deleteBlob(BlobKey blobKey) throws IOException {
        File file = this.getFileForBlob(blobKey);
        if (!file.delete()) {
            throw new IOException("Could not delete: " + file);
        }
        this.blobInfoStorage.deleteBlobInfo(blobKey);
    }

    private File getFileForBlob(BlobKey blobKey) {
        return new File(this.rootDirectory, blobKey.getKeyString());
    }
}

