/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.NamespaceManager;
import com.google.appengine.api.blobstore.BlobInfo;
import com.google.appengine.api.blobstore.BlobInfoFactory;
import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.blobstore.dev.BlobStorage;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.FileMetadata;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.tools.development.Clock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;

public class BlobstoreFile
extends FileMetadata {
    public static final String FILE_SYSTEM = AppEngineFile.FileSystem.BLOBSTORE.getName();
    private static final String PREFIX = "/" + FILE_SYSTEM + "/";
    public static final String CREATION_HANDLE_PREFIX = "writable:";
    static final String PARAMETER_MIME_TYPE = "content_type";
    static final String PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME = "file_name";
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    static final String BLOB_FILE_INDEX_BLOBKEY_PROPERTY = "blob_key";
    private static final String BLOB_INFO_CREATION_HANDLE_PROPERTY = "creation_handle";
    private BlobKey blobKey;
    private final String mimeType;
    private final String blobInfoUploadedFileName;
    private final LocalFileService localFileService;
    private final Clock clock;

    public static String buildFullPath(String namePart) {
        return PREFIX + namePart;
    }

    private BlobstoreFile(FileServicePb.FileContentType.ContentType contentType, String namePart, BlobKey blobKey, boolean finalized, Map<String, String> parameters, LocalFileService localFileService, Clock clock) {
        super(namePart, namePart, contentType);
        this.localFileService = localFileService;
        this.clock = clock;
        this.finalized = finalized;
        this.blobKey = blobKey;
        if (parameters != null) {
            this.mimeType = parameters.containsKey(PARAMETER_MIME_TYPE) ? parameters.get(PARAMETER_MIME_TYPE) : DEFAULT_MIME_TYPE;
            this.blobInfoUploadedFileName = parameters.containsKey(PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME) ? parameters.get(PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME) : "";
        } else {
            this.mimeType = DEFAULT_MIME_TYPE;
            this.blobInfoUploadedFileName = "";
        }
    }

    public static FileMetadata create(LocalFileService localFileService, Clock clock, String fileName, String randomString, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) {
        if (!fileName.isEmpty()) {
            LocalFileService.throwError(FileServicePb.FileServiceErrors.ErrorCode.FILE_NAME_SPECIFIED, "File name shouldn't be specified");
        }
        BlobstoreFile.checkParameters(parameters, PARAMETER_BLOB_INFO_UPLOADED_FILE_NAME, PARAMETER_MIME_TYPE);
        BlobKey noBlobKey = null;
        boolean notFinalized = false;
        return new BlobstoreFile(contentType, BlobstoreFile.buildFullPath(CREATION_HANDLE_PREFIX + randomString), noBlobKey, notFinalized, parameters, localFileService, clock);
    }

    public static FileMetadata newFinalizedInstance(LocalFileService localFileService, Clock clock, ParsedFileName parsedName) {
        String namePart = parsedName.getNamePart();
        BlobKey blobKey = BlobstoreFile.getBlobKey(namePart, localFileService.getDatastore());
        if (null == blobKey) {
            return null;
        }
        FileServicePb.FileContentType.ContentType noContentType = null;
        boolean finalized = true;
        Map<String, String> noParameters = null;
        return new BlobstoreFile(noContentType, namePart, blobKey, finalized, noParameters, localFileService, clock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static BlobKey getBlobKey(String namePart, DatastoreService datastore) {
        Entity blobInfoEntity;
        String creationHandle;
        String string = creationHandle = namePart.startsWith(CREATION_HANDLE_PREFIX) ? namePart : null;
        if (null == creationHandle) {
            return new BlobKey(namePart);
        }
        String origNamespace = NamespaceManager.get();
        NamespaceManager.set((String)"");
        Entity blobFileIndexEntity = datastore.get(KeyFactory.createKey((String)"__BlobFileIndex__", (String)creationHandle));
        String blobKey = (String)blobFileIndexEntity.getProperty(BLOB_FILE_INDEX_BLOBKEY_PROPERTY);
        BlobKey blobKey2 = new BlobKey(blobKey);
        NamespaceManager.set((String)origNamespace);
        return blobKey2;
        {
            catch (EntityNotFoundException ex) {
                try {
                    Query query = new Query("__BlobInfo__");
                    query.addFilter(BLOB_INFO_CREATION_HANDLE_PROPERTY, Query.FilterOperator.EQUAL, (Object)creationHandle);
                    blobInfoEntity = datastore.prepare(query).asSingleEntity();
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    NamespaceManager.set((String)origNamespace);
                }
            }
        }
        if (null == blobInfoEntity) {
            return null;
        }
        BlobInfo blobInfo = new BlobInfoFactory().createBlobInfo(blobInfoEntity);
        return blobInfo.getBlobKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveBlobInfo(DatastoreService datastoreService, BlobInfo blobInfo, String creationHandle) {
        String namespace = NamespaceManager.get();
        try {
            NamespaceManager.set((String)"");
            String blobKeyString = blobInfo.getBlobKey().getKeyString();
            Entity blobInfoEntity = new Entity("__BlobInfo__", blobKeyString);
            blobInfoEntity.setProperty(PARAMETER_MIME_TYPE, (Object)blobInfo.getContentType());
            blobInfoEntity.setProperty("creation", (Object)blobInfo.getCreation());
            blobInfoEntity.setProperty("filename", (Object)blobInfo.getFilename());
            blobInfoEntity.setProperty("size", (Object)blobInfo.getSize());
            blobInfoEntity.setProperty(BLOB_INFO_CREATION_HANDLE_PROPERTY, (Object)creationHandle);
            Entity fileIndexEntity = new Entity("__BlobFileIndex__", creationHandle);
            fileIndexEntity.setProperty(BLOB_FILE_INDEX_BLOBKEY_PROPERTY, (Object)blobKeyString);
            datastoreService.put(fileIndexEntity);
            datastoreService.put(blobInfoEntity);
        }
        finally {
            NamespaceManager.set((String)namespace);
        }
    }

    @Override
    public void setFinalized() {
        super.setFinalized();
        BlobInfo blobInfo = new BlobInfo(this.blobKey, this.mimeType, new Date(this.clock.getCurrentTime()), this.blobInfoUploadedFileName, (long)this.tempBytes.size());
        BlobstoreFile.saveBlobInfo(this.localFileService.getDatastore(), blobInfo, new ParsedFileName(this.appendName).getNamePart());
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        BlobStorage blobStorage = this.localFileService.getBlobStorage();
        String blobKeyString = this.localFileService.nextRandomString();
        this.blobKey = new BlobKey(blobKeyString);
        return blobStorage.storeBlob(this.blobKey);
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.localFileService.getBlobStorage().fetchBlob(this.blobKey);
    }

    BlobKey getBlobKey() {
        return this.blobKey;
    }
}

