/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.files.dev;

import com.google.appengine.api.blobstore.BlobKey;
import com.google.appengine.api.files.AppEngineFile;
import com.google.appengine.api.files.FileServicePb;
import com.google.appengine.api.files.dev.FileMetadata;
import com.google.appengine.api.files.dev.LocalFileService;
import com.google.appengine.api.files.dev.ParsedFileName;
import com.google.appengine.repackaged.com.google.common.util.Base64;
import com.google.appengine.tools.development.Clock;
import com.google.apphosting.api.ApiProxy;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

public class GSFile
extends FileMetadata {
    public static final String FILE_SYSTEM = AppEngineFile.FileSystem.GS.getName();
    private static final String PREFIX = "/" + FILE_SYSTEM + "/";
    public static final String CREATION_HANDLE_PREFIX = "writable:";
    static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    static final String PARAMETER_MIME_TYPE = "content_type";
    static final String PARAMETER_CANNED_ACL = "acl";
    static final String PARAMETER_CONTENT_ENCODING = "content_encoding";
    static final String PARAMETER_CONTENT_DISPOSITION = "content_disposition";
    static final String PARAMETER_CACHE_CONTROL = "cache_control";
    private final LocalFileService localFileService;

    private static String urlEncodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static String base64EncodeString(String string) {
        return Base64.encodeWebSafe((byte[])string.getBytes(), (boolean)false);
    }

    public static String buildWritablePath(String randomString, String fileName) {
        ParsedFileName parsedName = new ParsedFileName(fileName);
        return "/" + parsedName.getFileSystem() + "/" + CREATION_HANDLE_PREFIX + randomString + "?name=" + GSFile.urlEncodeString(parsedName.getNamePart());
    }

    public GSFile(String readName, String appendName, FileServicePb.FileContentType.ContentType contentType, boolean finalized, LocalFileService localFileService) {
        super(readName, appendName, contentType);
        this.localFileService = localFileService;
        this.finalized = finalized;
    }

    public static FileMetadata create(LocalFileService localFileService, Clock clock, String fileName, String randomString, FileServicePb.FileContentType.ContentType contentType, Map<String, String> parameters) {
        GSFile.checkParameters(parameters, PARAMETER_CANNED_ACL, PARAMETER_MIME_TYPE, PARAMETER_CONTENT_ENCODING, PARAMETER_CONTENT_DISPOSITION, PARAMETER_CACHE_CONTROL);
        String appendName = GSFile.buildWritablePath(randomString, fileName);
        boolean notFinalized = false;
        return new GSFile(fileName, appendName, contentType, notFinalized, localFileService);
    }

    protected static FileMetadata newFinalizedInstance(LocalFileService localFileService, Clock clock, ParsedFileName parsedName) {
        String readName = parsedName.getNamePart();
        if (readName.startsWith(CREATION_HANDLE_PREFIX)) {
            throw new ApiProxy.ApplicationException(FileServicePb.FileServiceErrors.ErrorCode.INVALID_FILE_NAME.getNumber(), "cannot read from an appendable file");
        }
        boolean finalized = true;
        String noAppendName = null;
        FileServicePb.FileContentType.ContentType noContentType = null;
        return new GSFile(readName, noAppendName, noContentType, finalized, localFileService);
    }

    @Override
    protected OutputStream getOutputStream() throws IOException {
        return this.localFileService.getBlobStorage().storeBlob(new BlobKey(GSFile.base64EncodeString(this.readName)));
    }

    @Override
    protected InputStream getInputStream() throws IOException {
        return this.localFileService.getBlobStorage().fetchBlob(new BlobKey(GSFile.base64EncodeString(PREFIX + this.readName)));
    }
}

